/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table;

import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class TableCellRenderBox
extends BlockRenderBox {
    private int colSpan;
    private int rowSpan;
    private Border effectiveBorder;
    private int columnIndex;
    private boolean bodySection;

    public TableCellRenderBox(StyleSheet styleSheet, InstanceID instanceID, BoxDefinition boxDefinition, ElementType elementType, ReportAttributeMap attributes, ReportStateKey stateKey) {
        super(styleSheet, instanceID, boxDefinition, elementType, attributes, stateKey);
        this.rowSpan = 1;
        this.columnIndex = -1;
        Integer colspan = (Integer)attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/table", "colspan");
        this.colSpan = colspan == null ? 1 : Math.max(1, colspan);
        Integer rowSpan = (Integer)attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/table", "rowspan");
        this.rowSpan = rowSpan == null ? 1 : Math.max(1, rowSpan);
    }

    @Override
    protected void reinit(StyleSheet styleSheet, ElementType elementType, ReportAttributeMap attributes, InstanceID instanceId) {
        super.reinit(styleSheet, elementType, attributes, instanceId);
        this.colSpan = 1;
        this.rowSpan = 1;
        this.columnIndex = -1;
    }

    public TableCellRenderBox() {
        this.colSpan = 1;
        this.rowSpan = 1;
        this.columnIndex = -1;
    }

    @Override
    public boolean useMinimumChunkWidth() {
        return true;
    }

    @Override
    public int getNodeType() {
        return 294914;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public void update(int rowSpan, int colSpan) {
        this.rowSpan = Math.max(1, rowSpan);
        this.colSpan = Math.max(1, colSpan);
        this.resetCacheState(true);
    }

    @Override
    public boolean isIgnorableForRendering() {
        return false;
    }

    public Border getEffectiveBorder() {
        return this.effectiveBorder;
    }

    public void setEffectiveBorder(Border effectiveBorder) {
        this.effectiveBorder = effectiveBorder;
    }

    public Border getOriginalBorder() {
        return this.getBoxDefinition().getBorder();
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public boolean isBodySection() {
        return this.bodySection;
    }

    public void setBodySection(boolean bodySection) {
        this.bodySection = bodySection;
    }
}

