/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table;

import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableLayoutInfo;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.SeparateColumnModel;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.TableColumnModel;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TableLayout;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class TableRenderBox
extends BlockRenderBox {
    private TableColumnModel columnModel = new SeparateColumnModel();
    private TableLayoutInfo tableInfo = new TableLayoutInfo();
    private boolean structureValidated;
    private boolean predefinedColumnsValidated;

    public TableRenderBox() {
        this(SimpleStyleSheet.EMPTY_STYLE, new InstanceID(), BoxDefinition.EMPTY, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.EMPTY_MAP, null);
    }

    public TableRenderBox(StyleSheet styleSheet, InstanceID instanceID, BoxDefinition boxDefinition, ElementType elementType, ReportAttributeMap attributes, ReportStateKey stateKey) {
        super(styleSheet, instanceID, boxDefinition, elementType, attributes, stateKey);
        this.tableInfo.setDisplayEmptyCells(true);
        this.tableInfo.setCollapsingBorderModel(false);
        Object styleProperty = styleSheet.getStyleProperty(BandStyleKeys.TABLE_LAYOUT);
        this.tableInfo.setAutoLayout(TableLayout.auto.equals(styleProperty));
        this.tableInfo.setRowSpacing(RenderLength.EMPTY);
        this.increaseTableReferenceCount(1, this);
    }

    @Override
    public int getNodeType() {
        return 266242;
    }

    public boolean isPredefinedColumnsValidated() {
        return this.predefinedColumnsValidated;
    }

    public void setPredefinedColumnsValidated(boolean predefinedColumnsValidated) {
        this.predefinedColumnsValidated = predefinedColumnsValidated;
    }

    public boolean isStructureValidated() {
        return this.structureValidated;
    }

    public void setStructureValidated(boolean structureValidated) {
        this.structureValidated = structureValidated;
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public RenderLength getRowSpacing() {
        return this.tableInfo.getRowSpacing();
    }

    public boolean isDisplayEmptyCells() {
        return this.tableInfo.isDisplayEmptyCells();
    }

    public boolean isCollapsingBorderModel() {
        return this.tableInfo.isCollapsingBorderModel();
    }

    public boolean isAutoLayout() {
        return this.tableInfo.isAutoLayout();
    }

    @Override
    public boolean useMinimumChunkWidth() {
        return true;
    }

    @Override
    public Object clone() {
        try {
            TableRenderBox box = (TableRenderBox)super.clone();
            if (!box.isStructureValidated()) {
                box.columnModel = (TableColumnModel)this.columnModel.clone();
            }
            return box;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed for some reason.");
        }
    }
}

