/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table.rows;

import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRow;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRowModel;
import org.pentaho.reporting.engine.classic.core.util.BulkArrayList;

public abstract class AbstractRowModel
implements TableRowModel {
    private BulkArrayList<TableRow> rows = new BulkArrayList(1000);

    @Override
    public void addRow() {
        this.rows.add(new TableRow());
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public TableRow getRow(int i) {
        return this.rows.get(i);
    }

    public TableRow[] getRows() {
        return this.rows.toArray((TableRow[])new TableRow[this.rows.size()]);
    }

    @Override
    public void prune(int rows) {
        if (rows <= 1) {
            return;
        }
        long validatedSize = 0L;
        long preferredSize = 0L;
        int split = 0;
        int runningMaxRowSpan = 0;
        for (int r = 0; r < rows; ++r) {
            --runningMaxRowSpan;
            TableRow row = this.getRow(r);
            validatedSize += row.getValidateSize();
            preferredSize += row.getPreferredSize();
            if ((runningMaxRowSpan = Math.max(runningMaxRowSpan, row.getMaximumRowSpan())) != 1) continue;
            split = r;
        }
        if (split == 0) {
            return;
        }
        TableRow newRow = new TableRow();
        newRow.updateDefinedSize(1, preferredSize);
        newRow.updateValidatedSize(1, 0L, validatedSize);
        newRow.setPreferredSize(preferredSize);
        newRow.setValidateSize(validatedSize);
        this.rows.set(0, newRow);
        this.rows.removeRange(1, rows - 1);
    }

    @Override
    public long getRowSpacing() {
        return 0L;
    }

    @Override
    public void updateDefinedSize(int rowNumber, int rowSpan, long preferredSize) {
        this.getRow(rowNumber).updateDefinedSize(rowSpan, preferredSize);
    }

    @Override
    public void updateValidatedSize(int rowNumber, int rowSpan, long leading, long height) {
        this.getRow(rowNumber).updateValidatedSize(rowSpan, leading, height);
    }

    @Override
    public long getValidatedRowSpanSize(int rowNumber) {
        int maximumRowSpan = this.getRow(rowNumber).getMaximumRowSpan();
        int endIndex = rowNumber + maximumRowSpan;
        long retval = 0L;
        for (int i = rowNumber; i < endIndex; ++i) {
            retval += this.getValidatedRowSize(i);
        }
        return retval;
    }

    @Override
    public long getValidatedRowSize(int rowNumber) {
        return this.getRow(rowNumber).getValidateSize();
    }

    @Override
    public long getPreferredRowSize(int rowNumber) {
        return this.getRow(rowNumber).getPreferredSize();
    }

    @Override
    public int getMaximumRowSpan(int rowNumber) {
        return this.getRow(rowNumber).getMaximumRowSpan();
    }
}

