/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table.rows;

import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.AbstractRowModel;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRow;

public class SeparateRowModel
extends AbstractRowModel {
    private boolean validatedSize;
    private long rowSpacing;

    @Override
    public void addRow() {
        super.addRow();
    }

    @Override
    public long getRowSpacing() {
        return this.rowSpacing;
    }

    @Override
    public void initialize(TableRenderBox table) {
        this.rowSpacing = table.getRowSpacing().resolve(0L);
    }

    @Override
    public void validateSizes() {
        if (this.validatedSize) {
            return;
        }
        int maxRowSpan = 0;
        TableRow[] rows = this.getRows();
        int rowCount = rows.length;
        for (int i = 0; i < rowCount; ++i) {
            TableRow row = rows[i];
            int cs = row.getMaximumRowSpan();
            if (cs <= maxRowSpan) continue;
            maxRowSpan = cs;
        }
        long[] preferredSizes = new long[rowCount];
        for (int rowspan = 1; rowspan <= maxRowSpan; ++rowspan) {
            for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
                TableRow row = rows[rowIdx];
                long preferredSize = row.getPreferredSize(rowspan);
                this.distribute(preferredSize, preferredSizes, rowIdx, rowspan);
            }
        }
        for (int i = 0; i < rowCount; ++i) {
            TableRow row = rows[i];
            row.setPreferredSize(preferredSizes[i]);
        }
        this.validatedSize = true;
    }

    @Override
    public void validateActualSizes() {
        this.validateSizes();
        int maxRowSpan = 0;
        TableRow[] rows = this.getRows();
        int rowCount = rows.length;
        for (int i = 0; i < rowCount; ++i) {
            TableRow row = rows[i];
            int cs = row.getMaxValidatedRowSpan();
            if (cs <= maxRowSpan) continue;
            maxRowSpan = cs;
        }
        long[] trailingSizes = new long[rowCount];
        for (int rowspan = 1; rowspan <= maxRowSpan; ++rowspan) {
            for (int rowIdx = 0; rowIdx < trailingSizes.length; ++rowIdx) {
                TableRow row = rows[rowIdx];
                long size = row.getValidatedTrailingSize(rowspan);
                this.distribute(size, trailingSizes, rowIdx, rowspan);
            }
        }
        for (int i = 0; i < trailingSizes.length; ++i) {
            TableRow row = rows[i];
            long validateSize = trailingSizes[i] + row.getValidatedLeadingSize();
            row.setValidateSize(Math.max(row.getPreferredSize(), validateSize));
        }
    }

    private void distribute(long usedSpace, long[] allSpaces, int colIdx, int colspanX) {
        int maxColspan = Math.min(colIdx + colspanX, allSpaces.length) - colIdx;
        long usedPrev = 0L;
        int maxSize = Math.min(allSpaces.length, colIdx + maxColspan);
        for (int i = colIdx; i < maxSize; ++i) {
            usedPrev += allSpaces[i];
        }
        if (usedSpace <= usedPrev) {
            return;
        }
        long distSpace = usedSpace - usedPrev;
        long delta = distSpace / (long)maxColspan;
        for (int i = 0; i < maxColspan - 1; ++i) {
            int n = colIdx + i;
            allSpaces[n] = allSpaces[n] + delta;
        }
        int n = colIdx + maxColspan - 1;
        allSpaces[n] = allSpaces[n] + (distSpace - (long)(maxColspan - 1) * delta);
    }

    @Override
    public void clear() {
        for (TableRow row : this.getRows()) {
            row.clear();
        }
    }
}

