/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table.rows;

import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.util.LongList;

public class TableRow {
    private Border border;
    private long preferredSize;
    private long validateSize;
    private LongList preferredSizes;
    private long validatedLeadingSize;
    private LongList validatedTrailingSize;
    private long changeTracker;

    public TableRow() {
        this(Border.EMPTY_BORDER);
    }

    public TableRow(Border border) {
        this.border = border;
        this.preferredSizes = new LongList(10);
        this.validatedLeadingSize = 0L;
        this.validatedTrailingSize = new LongList(10);
    }

    public long getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(long preferredSize) {
        this.preferredSize = preferredSize;
    }

    public long getPreferredSize(int colspan) {
        int index = colspan - 1;
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (this.preferredSizes.size() <= index) {
            return 0L;
        }
        return this.preferredSizes.get(index);
    }

    public void updateDefinedSize(int rowSpan, long preferredHeight) {
        if (rowSpan < 1) {
            throw new IllegalArgumentException();
        }
        int idx = rowSpan - 1;
        if (idx >= this.preferredSizes.size() || this.preferredSizes.get(idx) < preferredHeight) {
            this.preferredSizes.set(idx, preferredHeight);
        }
    }

    public long getValidatedLeadingSize() {
        return this.validatedLeadingSize;
    }

    public long getValidatedTrailingSize(int rowSpan) {
        if (rowSpan > this.validatedTrailingSize.size()) {
            return 0L;
        }
        return this.validatedTrailingSize.get(rowSpan - 1);
    }

    public int getMaxValidatedRowSpan() {
        return this.validatedTrailingSize.size();
    }

    public void updateValidatedSize(int rowSpan, long leading, long trailing) {
        int idx = rowSpan - 1;
        if (this.validatedLeadingSize < leading) {
            this.validatedLeadingSize = leading;
        }
        if (idx >= this.validatedTrailingSize.size() || this.validatedTrailingSize.get(idx) < trailing) {
            this.validatedTrailingSize.set(idx, trailing);
        }
    }

    public long getValidateSize() {
        return this.validateSize;
    }

    public void setValidateSize(long validateSize) {
        this.validateSize = validateSize;
    }

    public Border getBorder() {
        return this.border;
    }

    public void clear() {
        this.validatedTrailingSize.clear();
        this.validateSize = 0L;
    }

    public void clearSizes() {
        this.preferredSizes.clear();
        this.preferredSize = 0L;
    }

    public int getMaximumRowSpan() {
        return this.preferredSizes.size();
    }
}

