/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.EmptyReportException;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportEventException;
import org.pentaho.reporting.engine.classic.core.ReportInterruptedException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.AbstractRenderer;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultLayoutPagebreakHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultOutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultPageStateList;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.output.FastPageStateList;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.PageState;
import org.pentaho.reporting.engine.classic.core.layout.output.PageStateList;
import org.pentaho.reporting.engine.classic.core.layout.output.PerformanceProgressLogger;
import org.pentaho.reporting.engine.classic.core.layout.output.ReportProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.YieldReportListener;
import org.pentaho.reporting.engine.classic.core.states.CollectingReportErrorHandler;
import org.pentaho.reporting.engine.classic.core.states.IgnoreEverythingReportErrorHandler;
import org.pentaho.reporting.engine.classic.core.states.InitialLayoutProcess;
import org.pentaho.reporting.engine.classic.core.states.ProcessStateHandle;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.process.PendingPagesHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;
import org.pentaho.reporting.engine.classic.core.states.process.RestartOnNewPageHandler;
import org.pentaho.reporting.engine.classic.core.util.IntList;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.base.util.MemoryUsageMessage;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentMetaData;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public abstract class AbstractReportProcessor
implements ReportProcessor {
    private static final Log logger = LogFactory.getLog(AbstractReportProcessor.class);
    private static final boolean SHOW_ROLLBACKS = logger.isTraceEnabled();
    protected static final int MAX_EVENTS_PER_RUN = 200;
    protected static final int MIN_ROWS_PER_EVENT = 100;
    protected static final int COMMIT_RATE = 10;
    private boolean handleInterruptedState;
    private ArrayList<ReportProgressListener> listeners;
    private transient Object[] listenersCache;
    private MasterReport report;
    private OutputProcessor outputProcessor;
    private PageStateList stateList;
    private transient ProcessStateHandle activeDataFactory;
    private IntList physicalMapping;
    private IntList logicalMapping;
    private boolean paranoidChecks;
    private boolean fullStreamingProcessor;
    private boolean pagebreaksSupported;

    protected AbstractReportProcessor(MasterReport report, OutputProcessor outputProcessor) throws ReportProcessingException {
        String profile;
        if (report == null) {
            throw new NullPointerException("Report cannot be null.");
        }
        if (outputProcessor == null) {
            throw new NullPointerException("OutputProcessor cannot be null");
        }
        this.fullStreamingProcessor = true;
        this.handleInterruptedState = true;
        this.outputProcessor = outputProcessor;
        ModifiableConfiguration configuration = report.getReportConfiguration();
        this.paranoidChecks = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.layout.ParanoidChecks"));
        String yieldRateText = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.YieldRate");
        int yieldRate = ParserUtil.parseInt((String)yieldRateText, (int)0);
        if (yieldRate > 0) {
            this.addReportProgressListener(new YieldReportListener(yieldRate));
        }
        if ("true".equals(profile = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.ProfileReportProcessing"))) {
            boolean logLevelProgress = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.performance.LogLevelProgress"));
            boolean logPageProgress = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.performance.LogPageProgress"));
            boolean logRowProgress = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.performance.LogRowProgress"));
            this.addReportProgressListener(new PerformanceProgressLogger(logLevelProgress, logPageProgress, logRowProgress));
        }
        boolean designtime = outputProcessor.getMetaData().isFeatureSupported(OutputProcessorFeature.DESIGNTIME);
        this.report = report.derive(designtime);
    }

    protected ProcessStateHandle getProcessStateHandle() {
        return this.activeDataFactory;
    }

    protected MasterReport getReport() {
        return this.report;
    }

    public OutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    protected OutputProcessorMetaData getOutputProcessorMetaData() {
        return this.outputProcessor.getMetaData();
    }

    @Override
    public void addReportProgressListener(ReportProgressListener l) {
        if (l == null) {
            throw new NullPointerException("Listener == null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList(5);
        }
        this.listenersCache = null;
        this.listeners.add(l);
    }

    @Override
    public void removeReportProgressListener(ReportProgressListener l) {
        if (l == null) {
            throw new NullPointerException("Listener == null");
        }
        if (this.listeners == null) {
            return;
        }
        this.listenersCache = null;
        this.listeners.remove(l);
    }

    protected void fireStateUpdate(ReportProgressEvent state) {
        if (this.listeners == null) {
            return;
        }
        if (this.listenersCache == null) {
            this.listenersCache = this.listeners.toArray();
        }
        int length = this.listenersCache.length;
        for (int i = 0; i < length; ++i) {
            ReportProgressListener l = (ReportProgressListener)this.listenersCache[i];
            l.reportProcessingUpdate(state);
        }
    }

    protected void fireProcessingStarted(ReportProgressEvent state) {
        if (this.listeners == null) {
            return;
        }
        if (this.listenersCache == null) {
            this.listenersCache = this.listeners.toArray();
        }
        int length = this.listenersCache.length;
        for (int i = 0; i < length; ++i) {
            ReportProgressListener l = (ReportProgressListener)this.listenersCache[i];
            l.reportProcessingStarted(state);
        }
    }

    protected void fireProcessingFinished(ReportProgressEvent state) {
        if (this.listeners == null) {
            return;
        }
        if (this.listenersCache == null) {
            this.listenersCache = this.listeners.toArray();
        }
        int length = this.listenersCache.length;
        for (int i = 0; i < length; ++i) {
            ReportProgressListener l = (ReportProgressListener)this.listenersCache[i];
            l.reportProcessingFinished(state);
        }
    }

    @Override
    public boolean isHandleInterruptedState() {
        return this.handleInterruptedState;
    }

    @Override
    public void setHandleInterruptedState(boolean handleInterruptedState) {
        this.handleInterruptedState = handleInterruptedState;
    }

    protected final void checkInterrupted() throws ReportInterruptedException {
        if (this.isHandleInterruptedState() && Thread.currentThread().isInterrupted()) {
            throw new ReportInterruptedException("Current thread [" + Thread.currentThread().getName() + "]is interrupted. Returning.");
        }
    }

    @Override
    public synchronized void close() {
        if (this.activeDataFactory != null) {
            this.activeDataFactory.close();
            this.activeDataFactory = null;
            this.stateList = null;
            this.physicalMapping = null;
            this.logicalMapping = null;
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.report.getConfiguration();
    }

    protected DefaultProcessingContext createProcessingContext() throws ReportProcessingException {
        OutputProcessorMetaData metaData = this.getOutputProcessorMetaData();
        MasterReport report = this.getReport();
        DocumentBundle bundle = report.getBundle();
        Object documentMetaData = bundle != null ? bundle.getMetaData() : new MemoryDocumentMetaData();
        Integer compatibilityLevel = report.getCompatibilityLevel();
        int cLevel = compatibilityLevel == null ? -1 : compatibilityLevel;
        return new DefaultProcessingContext(metaData, report.getResourceBundleFactory(), report.getConfiguration(), report.getResourceManager(), report.getContentBase(), (DocumentMetaData)documentMetaData, report.getReportEnvironment(), cLevel);
    }

    protected ProcessState processPrepareLevels(ProcessState state, int maxRows) throws ReportProcessingException {
        boolean failOnError = AbstractReportProcessor.isStrictErrorHandling((Configuration)this.getReport().getReportConfiguration());
        CollectingReportErrorHandler errorHandler = new CollectingReportErrorHandler();
        state.setErrorHandler(errorHandler);
        int lastRow = -1;
        int eventCount = 0;
        int eventTrigger = maxRows <= 0 ? Math.max(maxRows / 200, 100) : Math.min(maxRows, Math.max(maxRows / 200, 100));
        ReportProgressEvent repaginationState = new ReportProgressEvent(this);
        while (!state.isFinish()) {
            this.checkInterrupted();
            if (lastRow != state.getCurrentRow()) {
                lastRow = state.getCurrentRow();
                if (eventCount == 0) {
                    repaginationState.reuse(1, state, 0);
                    this.fireStateUpdate(repaginationState);
                    ++eventCount;
                } else {
                    eventCount = eventCount == eventTrigger ? 0 : ++eventCount;
                }
            }
            ProcessState nextState = state.advance();
            state.setErrorHandler(IgnoreEverythingReportErrorHandler.INSTANCE);
            state = nextState.commit();
            if (!errorHandler.isErrorOccured()) continue;
            List<Exception> childExceptions = Arrays.asList(errorHandler.getErrors());
            errorHandler.clearErrors();
            if (failOnError) {
                throw new ReportEventException("Failed to dispatch an event.", childExceptions);
            }
            ReportEventException exception = new ReportEventException("Failed to dispatch an event.", childExceptions);
            logger.error((Object)"Failed to dispatch an event.", (Throwable)exception);
        }
        return state;
    }

    protected abstract OutputFunction createLayoutManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareReportProcessing() throws ReportProcessingException {
        boolean hasNext;
        int index;
        int[] levels;
        if (this.stateList != null) {
            return;
        }
        long start = System.currentTimeMillis();
        DefaultProcessingContext processingContext = this.createProcessingContext();
        MasterReport report = this.getReport();
        OutputFunction lm = this.createLayoutManager();
        ProcessState startState = new ProcessState();
        try {
            startState.initializeForMasterReport(report, processingContext, new InitialLayoutProcess((OutputFunction)lm.getInstance()));
        }
        finally {
            this.activeDataFactory = startState.getProcessHandle();
        }
        ProcessState state = startState;
        int maxRows = startState.getNumberOfRows();
        processingContext.setPrepareRun(true);
        if (state.isStructuralPreprocessingNeeded()) {
            state = this.performStructuralPreprocessing(state, processingContext);
            levels = state.getRequiredRuntimeLevels();
            index = 1;
        } else {
            levels = state.getRequiredRuntimeLevels();
            index = 0;
        }
        if (levels.length == 0) {
            throw new IllegalStateException("Assertation Failed: No functions defined, invalid implementation.");
        }
        processingContext.setProgressLevelCount(levels.length);
        int level = levels[index];
        do {
            processingContext.setProcessingLevel(level);
            processingContext.setProgressLevel(index);
            if (level == -2) {
                this.stateList = this.isFullStreamingProcessor() ? new FastPageStateList(this) : new DefaultPageStateList(this);
                this.physicalMapping = new IntList(40);
                this.logicalMapping = new IntList(20);
                logger.debug((Object)"Pagination started ..");
                state = this.processPaginationLevel(state, this.stateList, maxRows);
            } else {
                state = this.processPrepareLevels(state, maxRows);
            }
            boolean bl = hasNext = index < levels.length - 1;
            if (!hasNext) continue;
            level = levels[++index];
            processingContext.setProcessingLevel(level);
            processingContext.setProgressLevel(index);
            if (state.isFinish()) {
                state = state.restart();
                continue;
            }
            throw new IllegalStateException("Repaginate did not produce an finish state");
        } while (hasNext);
        processingContext.setPrepareRun(false);
        long end = System.currentTimeMillis();
        logger.debug((Object)("Pagination-Time: " + (end - start)));
    }

    public void setFullStreamingProcessor(boolean fullStreamingProcessor) {
        this.fullStreamingProcessor = fullStreamingProcessor;
    }

    public boolean isFullStreamingProcessor() {
        return this.fullStreamingProcessor;
    }

    private ProcessState performStructuralPreprocessing(ProcessState startState, DefaultProcessingContext processingContext) throws ReportProcessingException {
        processingContext.setProcessingLevel(Integer.MAX_VALUE);
        processingContext.setProgressLevel(-1);
        int maxRows = startState.getNumberOfRows();
        ProcessState state = this.processPrepareLevels(startState, maxRows);
        if (!state.isFinish()) {
            throw new IllegalStateException("Repaginate did not produce an finish state");
        }
        state = state.restart();
        return state;
    }

    private ProcessState processPaginationLevel(ProcessState startState, PageStateList pageStates, int maxRows) throws ReportProcessingException {
        try {
            boolean failOnError = AbstractReportProcessor.isStrictErrorHandling((Configuration)this.getReport().getReportConfiguration());
            CollectingReportErrorHandler errorHandler = new CollectingReportErrorHandler();
            DefaultLayoutPagebreakHandler pagebreakHandler = new DefaultLayoutPagebreakHandler();
            ProcessState initialReportState = startState.deriveForStorage();
            PageState initialPageState = new PageState(initialReportState, this.outputProcessor.getPageCursor());
            pageStates.add(initialPageState);
            ReportProgressEvent repaginationState = new ReportProgressEvent(this);
            int eventTrigger = maxRows <= 0 ? Math.max(maxRows / 200, 100) : Math.min(maxRows, Math.max(maxRows / 200, 100));
            ProcessState state = startState.deriveForStorage();
            state.setErrorHandler(errorHandler);
            this.validate(state);
            OutputProcessorMetaData metaData = state.getFlowController().getReportContext().getOutputProcessorMetaData();
            this.pagebreaksSupported = metaData.isFeatureSupported(OutputProcessorFeature.PAGEBREAKS);
            int pageEventCount = 0;
            ProcessState fallBackState = this.pagebreaksSupported ? state.deriveForPagebreak() : null;
            ProcessState globalState = this.pagebreaksSupported ? state.deriveForStorage() : null;
            ReportStateKey rollbackPageState = null;
            boolean isInRollBackMode = false;
            int eventCount = 0;
            int lastRow = -1;
            while (!state.isFinish()) {
                ProcessState restoreState;
                int logPageCount = this.outputProcessor.getLogicalPageCount();
                int physPageCount = this.outputProcessor.getPhysicalPageCount();
                this.checkInterrupted();
                if (lastRow != state.getCurrentRow()) {
                    lastRow = state.getCurrentRow();
                    if (eventCount == 0) {
                        if (this.isPagebreaksSupported() && fallBackState != null) {
                            repaginationState.reuse(2, fallBackState, this.calculatePageCount(fallBackState));
                        } else {
                            repaginationState.reuse(2, state, this.calculatePageCount(state));
                        }
                        this.fireStateUpdate(repaginationState);
                        ++eventCount;
                    } else {
                        eventCount = eventCount == eventTrigger ? 0 : ++eventCount;
                    }
                }
                ProcessState realFallbackState = fallBackState;
                if (this.pagebreaksSupported && !state.isArtifcialState()) {
                    restoreState = fallBackState;
                    if (!isInRollBackMode && pageEventCount >= 10) {
                        OutputFunction outputFunction = state.getLayoutProcess().getOutputFunction();
                        if (outputFunction.createRollbackInformation()) {
                            realFallbackState = state.deriveForPagebreak();
                            if (SHOW_ROLLBACKS) {
                                logger.debug((Object)("Paginate: Try to generate new fallback state after commit count reached: " + state.getProcessKey()));
                            }
                            this.validate(state);
                        } else {
                            realFallbackState = null;
                        }
                    }
                } else {
                    restoreState = null;
                }
                ProcessState nextState = state.advance();
                state.setErrorHandler(IgnoreEverythingReportErrorHandler.INSTANCE);
                state = nextState;
                this.validate(state);
                ReportStateKey nextStateKey = state.getProcessKey();
                if (errorHandler.isErrorOccured()) {
                    List<Exception> childExceptions = Arrays.asList(errorHandler.getErrors());
                    errorHandler.clearErrors();
                    ReportEventException exception = new ReportEventException("Failed to dispatch an event.", childExceptions);
                    if (failOnError) {
                        throw exception;
                    }
                    logger.error((Object)"Failed to dispatch an event.", (Throwable)exception);
                }
                if (state.isArtifcialState()) {
                    if (SHOW_ROLLBACKS) {
                        logger.debug((Object)("Paginate: Silent commit as we are in an artificial state: " + state.getProcessKey()));
                    }
                    state = state.commit();
                    if (!SHOW_ROLLBACKS) continue;
                    logger.debug((Object)("Paginate: Post Silent commit as we are in an artificial state: " + state.getProcessKey()));
                    continue;
                }
                OutputFunction outputFunction = state.getLayoutProcess().getOutputFunction();
                if (!(outputFunction instanceof DefaultOutputFunction)) {
                    if (!(state = state.commit()).isFinish() || pageStates.size() != 1) continue;
                    this.physicalMapping.add(0);
                    this.logicalMapping.add(0);
                    continue;
                }
                DefaultOutputFunction lm = (DefaultOutputFunction)outputFunction;
                Renderer renderer = lm.getRenderer();
                renderer.setStateKey(state.getProcessKey());
                pagebreakHandler.setReportState(state);
                boolean assertExpectPagebreak = false;
                if (isInRollBackMode && nextStateKey.equals(rollbackPageState)) {
                    if (SHOW_ROLLBACKS) {
                        logger.debug((Object)("Paginate: Found real pagebreak position. This might be the last state we process: " + rollbackPageState));
                        logger.debug((Object)("Paginate:   (Current state process key)           : " + state.getProcessKey()));
                        logger.debug((Object)("Paginate:   (Handler)                             : " + state.getAdvanceHandler().getClass().getName()));
                    }
                    assertExpectPagebreak = true;
                    renderer.addPagebreak();
                }
                Renderer.LayoutResult pagebreakEncountered = renderer.validatePages();
                if (SHOW_ROLLBACKS) {
                    logger.debug((Object)("Paginate: Validate Page returned " + (Object)((Object)pagebreakEncountered)));
                    if (assertExpectPagebreak && pagebreakEncountered != Renderer.LayoutResult.LAYOUT_PAGEBREAK) {
                        logger.debug((Object)"Paginate: Missed the pagebreak. This smells fishy!");
                    }
                }
                if (pagebreakEncountered != Renderer.LayoutResult.LAYOUT_UNVALIDATABLE) {
                    if (this.pagebreaksSupported && !state.isArtifcialState() && !isInRollBackMode) {
                        if (pageEventCount >= 10) {
                            if (SHOW_ROLLBACKS) {
                                logger.debug((Object)("Paginate: Try to apply new fallback state after commit count reached: " + state.getProcessKey()));
                                logger.debug((Object)("Paginate:        : " + renderer.getLastStateKey()));
                            }
                            fallBackState = realFallbackState;
                            pageEventCount = 0;
                        } else {
                            if (SHOW_ROLLBACKS) {
                                logger.debug((Object)("Paginate: Increase counter: " + state.getProcessKey()));
                            }
                            ++pageEventCount;
                        }
                    }
                } else if (SHOW_ROLLBACKS && this.pagebreaksSupported && !state.isArtifcialState() && !isInRollBackMode) {
                    logger.debug((Object)("Paginate: SKIP : " + state.getProcessKey()));
                }
                if (pagebreakEncountered == Renderer.LayoutResult.LAYOUT_PAGEBREAK) {
                    boolean onGoingPageBreak;
                    ReportStateKey lastVisibleStateKey = renderer.getLastStateKey();
                    if (this.isPagebreaksSupported() && !isInRollBackMode && lastVisibleStateKey != null && renderer.isOpen()) {
                        if (!lastVisibleStateKey.equals(nextStateKey) && lastVisibleStateKey.getSequenceCounter() > globalState.getProcessKey().getSequenceCounter()) {
                            rollbackPageState = lastVisibleStateKey;
                            ReportStateKey restoreStateProcessKey = restoreState.getProcessKey();
                            if (SHOW_ROLLBACKS) {
                                logger.debug((Object)("Paginate: Encountered bad break, need to roll-back: " + rollbackPageState));
                                logger.debug((Object)("Paginate:    Next StateKey                        : " + state.getProcessKey()));
                                logger.debug((Object)("Paginate:    Restored Key                         : " + restoreStateProcessKey));
                                logger.debug((Object)("Paginate:    Position in event chain              : " + restoreState.getSequenceCounter()));
                            }
                            if (lastVisibleStateKey.getSequenceCounter() < restoreStateProcessKey.getSequenceCounter()) {
                                if (SHOW_ROLLBACKS) {
                                    logger.debug((Object)("Paginate: Fall back to start of page              : " + globalState.getProcessKey()));
                                }
                                if (lastVisibleStateKey.getSequenceCounter() <= globalState.getProcessKey().getSequenceCounter()) {
                                    throw new ReportProcessingException("Paginate: Error, fallback position is after last visible state.");
                                }
                                state = globalState.deriveForStorage();
                            } else {
                                if (SHOW_ROLLBACKS) {
                                    logger.debug((Object)("Paginate: Fall back to save-state                 : " + restoreStateProcessKey));
                                }
                                state = restoreState.deriveForPagebreak();
                            }
                            DefaultOutputFunction rollbackOutputFunction = (DefaultOutputFunction)state.getLayoutProcess().getOutputFunction();
                            Renderer rollbackRenderer = rollbackOutputFunction.getRenderer();
                            rollbackRenderer.rollback();
                            this.validate(state);
                            isInRollBackMode = true;
                            fallBackState = null;
                            continue;
                        }
                        if (SHOW_ROLLBACKS) {
                            logger.debug((Object)("Paginate: Encountered on-going break " + lastVisibleStateKey));
                        }
                        onGoingPageBreak = true;
                        rollbackPageState = null;
                    } else {
                        if (SHOW_ROLLBACKS) {
                            if (isInRollBackMode) {
                                logger.debug((Object)("Paginate: Encountered a roll-back break: " + isInRollBackMode));
                                if (!assertExpectPagebreak) {
                                    logger.debug((Object)("Paginate: next state:     " + nextStateKey));
                                    if (!nextStateKey.equals(rollbackPageState)) {
                                        logger.debug((Object)("Paginate: rollback state: " + rollbackPageState));
                                    }
                                }
                            } else {
                                logger.debug((Object)("Paginate: Encountered a good break: " + isInRollBackMode));
                            }
                            logger.debug((Object)("Paginate:                                              : " + state.getProcessKey()));
                        }
                        isInRollBackMode = false;
                        rollbackPageState = null;
                        onGoingPageBreak = false;
                    }
                    if (!this.isPagebreaksSupported()) {
                        renderer.applyAutoCommit();
                    }
                    if (!renderer.processPage(pagebreakHandler, state.getProcessKey(), true)) {
                        throw new IllegalStateException("This cannot be. If the validation said we get a new page, how can we now get lost here");
                    }
                    if (this.isPagebreaksSupported()) {
                        if (renderer.isPendingPageHack() && !renderer.isCurrentPageEmpty() && !renderer.isPageStartPending()) {
                            if (SHOW_ROLLBACKS) {
                                logger.debug((Object)("Paginate: Delaying next event to allow pending pages to be processed: " + state.getProcessKey()));
                            }
                            state = PendingPagesHandler.create(state);
                        } else {
                            if (SHOW_ROLLBACKS) {
                                logger.debug((Object)("Paginate: Adding RestartOnNewPageHandler to open Page in time: " + state.getProcessKey()));
                            }
                            state = RestartOnNewPageHandler.create(state.commit());
                        }
                    } else {
                        if (SHOW_ROLLBACKS) {
                            logger.debug((Object)("Paginate: Commit on page-break: " + state.getProcessKey() + " " + state.getAdvanceHandler().getClass().getName()));
                        }
                        state = state.commit();
                    }
                    if (onGoingPageBreak) {
                        renderer.setStateKey(state.getProcessKey());
                        renderer.addProgressBox();
                    }
                    if (SHOW_ROLLBACKS) {
                        logger.debug((Object)("Paginate: Post Commit: " + state.getProcessKey() + " " + state.getAdvanceHandler().getClass().getName()));
                    }
                    int newLogPageCount = this.outputProcessor.getLogicalPageCount();
                    int newPhysPageCount = this.outputProcessor.getPhysicalPageCount();
                    int result = pageStates.size() - 1;
                    while (physPageCount < newPhysPageCount) {
                        this.physicalMapping.add(result);
                        ++physPageCount;
                    }
                    while (logPageCount < newLogPageCount) {
                        this.logicalMapping.add(result);
                        ++logPageCount;
                    }
                    if (!state.isFinish()) {
                        PageState pageState = new PageState(state, this.outputProcessor.getPageCursor());
                        pageStates.add(pageState);
                    }
                    if (!this.isPagebreaksSupported()) continue;
                    fallBackState = state.deriveForPagebreak();
                    globalState = state.deriveForStorage();
                    if (SHOW_ROLLBACKS) {
                        logger.debug((Object)("Paginate: Generating new fallback state after pagebreak found: " + state.getProcessKey()));
                    }
                    pageEventCount = 0;
                    eventCount = 0;
                    continue;
                }
                if (!this.isPagebreaksSupported()) {
                    renderer.applyAutoCommit();
                }
                if (pageEventCount == 0 && !isInRollBackMode && pagebreakEncountered == Renderer.LayoutResult.LAYOUT_NO_PAGEBREAK) {
                    if (SHOW_ROLLBACKS) {
                        logger.debug((Object)("Paginate: Perform incremental update: " + state.getProcessKey()));
                    }
                    renderer.processIncrementalUpdate(false);
                }
                if (SHOW_ROLLBACKS) {
                    logger.debug((Object)("Paginate: Commit: " + state.getProcessKey() + " " + state.getAdvanceHandler().getClass().getName()));
                }
                state = state.commit();
                if (SHOW_ROLLBACKS) {
                    logger.debug((Object)("Paginate: Post Commit: " + state.getProcessKey() + " " + state.getAdvanceHandler().getClass().getName()));
                }
                if (!this.pagebreaksSupported || fallBackState == restoreState) continue;
                DefaultOutputFunction commitableOutputFunction = (DefaultOutputFunction)state.getLayoutProcess().getOutputFunction();
                Renderer commitableRenderer = commitableOutputFunction.getRenderer();
                commitableRenderer.applyRollbackInformation();
            }
            return initialReportState;
        }
        catch (ContentProcessingException e) {
            throw new ReportProcessingException("Content-Processing failed.", e);
        }
    }

    private void printLayoutStateToFile(ProcessState state, boolean print, boolean inRollBackMode) {
        DefaultOutputFunction of = (DefaultOutputFunction)state.getLayoutProcess().getOutputFunction();
        AbstractRenderer ar = (AbstractRenderer)of.getRenderer();
        ar.printLayoutStateToFile(state, print, inRollBackMode);
    }

    protected int calculatePageCount(ProcessState state) {
        OutputFunction outputFunction = state.getLayoutProcess().getOutputFunction();
        if (!(outputFunction instanceof DefaultOutputFunction)) {
            return 0;
        }
        DefaultOutputFunction lm = (DefaultOutputFunction)outputFunction;
        Renderer renderer = lm.getRenderer();
        return renderer.getPageCount() + 1;
    }

    private void validate(ProcessState state) {
        if (this.paranoidChecks) {
            OutputFunction outputFunction = state.getLayoutProcess().getOutputFunction();
            if (!(outputFunction instanceof DefaultOutputFunction)) {
                return;
            }
            DefaultOutputFunction of = (DefaultOutputFunction)outputFunction;
            Renderer renderer = of.getRenderer();
            if (renderer instanceof AbstractRenderer) {
                AbstractRenderer r = (AbstractRenderer)renderer;
                r.performParanoidModelCheck();
            }
        }
    }

    public boolean isPaginated() {
        return this.stateList != null;
    }

    protected PageState getLogicalPageState(int page) {
        int index = this.logicalMapping.get(page);
        PageState pageState = this.stateList.get(index);
        if (pageState == null) {
            throw new IndexOutOfBoundsException("The logical mapping between page " + page + " and index " + index + " is invalid.");
        }
        return pageState;
    }

    protected PageState getPhysicalPageState(int page) {
        int index = this.physicalMapping.get(page);
        PageState pageState = this.stateList.get(index);
        if (pageState == null) {
            throw new IndexOutOfBoundsException("The physical mapping between page " + page + " and index " + index + " is invalid.");
        }
        return pageState;
    }

    protected static boolean isStrictErrorHandling(Configuration config) {
        String strictError = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.StrictErrorHandling");
        return "true".equals(strictError);
    }

    @Override
    public PageState processPage(PageState pageState, boolean performOutput) throws ReportProcessingException {
        if (pageState == null) {
            throw new NullPointerException("PageState must not be null.");
        }
        boolean failOnError = AbstractReportProcessor.isStrictErrorHandling((Configuration)this.getReport().getReportConfiguration());
        CollectingReportErrorHandler errorHandler = new CollectingReportErrorHandler();
        if (SHOW_ROLLBACKS) {
            logger.debug((Object)("Process Page: Starting with : " + pageState.getReportState().getProcessKey()));
        }
        try {
            ProcessState startState = pageState.getReportState();
            this.outputProcessor.setPageCursor(pageState.getPageCursor());
            int maxRows = startState.getNumberOfRows();
            ReportProgressEvent repaginationState = new ReportProgressEvent(this);
            DefaultLayoutPagebreakHandler pagebreakHandler = new DefaultLayoutPagebreakHandler();
            int eventTrigger = maxRows <= 0 ? Math.max(maxRows / 200, 100) : Math.min(maxRows, Math.max(maxRows / 200, 100));
            boolean pagebreaksSupported = this.isPagebreaksSupported();
            ReportStateKey rollbackPageState = null;
            ProcessState state = startState.deriveForStorage();
            ProcessState fallBackState = pagebreaksSupported ? state.deriveForPagebreak() : null;
            ProcessState globalState = pagebreaksSupported ? state.deriveForStorage() : null;
            state.setErrorHandler(errorHandler);
            boolean isInRollBackMode = false;
            int lastRow = -1;
            int eventCount = 0;
            int pageEventCount = 0;
            while (!state.isFinish()) {
                ProcessState restoreState;
                this.checkInterrupted();
                if (lastRow != state.getCurrentRow()) {
                    lastRow = state.getCurrentRow();
                    if (eventCount == 0) {
                        repaginationState.reuse(3, state, this.calculatePageCount(state));
                        this.fireStateUpdate(repaginationState);
                        ++eventCount;
                    } else {
                        eventCount = eventCount == eventTrigger ? 0 : ++eventCount;
                    }
                }
                ProcessState realFallbackState = fallBackState;
                if (pagebreaksSupported && !state.isArtifcialState()) {
                    restoreState = fallBackState;
                    if (!isInRollBackMode && pageEventCount >= 10) {
                        OutputFunction outputFunction = state.getLayoutProcess().getOutputFunction();
                        if (outputFunction.createRollbackInformation()) {
                            if (SHOW_ROLLBACKS) {
                                logger.debug((Object)("Print: Try to generate new fallback state after commit count reached: " + state.getProcessKey()));
                            }
                            realFallbackState = state.deriveForPagebreak();
                        } else {
                            realFallbackState = null;
                        }
                    }
                } else {
                    restoreState = null;
                }
                ProcessState nextState = state.advance();
                state.setErrorHandler(IgnoreEverythingReportErrorHandler.INSTANCE);
                state = nextState;
                ReportStateKey nextStateKey = state.getProcessKey();
                if (errorHandler.isErrorOccured()) {
                    List<Exception> childExceptions = Arrays.asList(errorHandler.getErrors());
                    errorHandler.clearErrors();
                    if (failOnError) {
                        throw new ReportEventException("Failed to dispatch an event.", childExceptions);
                    }
                    ReportEventException exception = new ReportEventException("Failed to dispatch an event.", childExceptions);
                    logger.error((Object)"Failed to dispatch an event.", (Throwable)exception);
                }
                if (state.isArtifcialState()) {
                    if (SHOW_ROLLBACKS) {
                        logger.debug((Object)("Print: Silent commit as we are in an artificial state: " + state.getProcessKey()));
                    }
                    state = state.commit();
                    if (!SHOW_ROLLBACKS) continue;
                    logger.debug((Object)("Print: Post Silent commit as we are in an artificial state: " + state.getProcessKey()));
                    continue;
                }
                OutputFunction outputFunction = state.getLayoutProcess().getOutputFunction();
                if (!(outputFunction instanceof DefaultOutputFunction)) {
                    if (SHOW_ROLLBACKS) {
                        logger.debug((Object)("Print: Silent commit as we are have no access to the renderer: " + state.getProcessKey()));
                    }
                    state = state.commit();
                    continue;
                }
                DefaultOutputFunction lm = (DefaultOutputFunction)outputFunction;
                Renderer renderer = lm.getRenderer();
                renderer.setStateKey(state.getProcessKey());
                pagebreakHandler.setReportState(state);
                boolean assertExpectPagebreak = false;
                if (isInRollBackMode && nextStateKey.equals(rollbackPageState)) {
                    if (SHOW_ROLLBACKS) {
                        logger.debug((Object)("Print: Found real pagebreak position. This might be the last state we process: " + rollbackPageState));
                        logger.debug((Object)("Print:   (Current state process key)           : " + state.getProcessKey()));
                        logger.debug((Object)("Print:   (Handler)                             : " + state.getAdvanceHandler().getClass().getName()));
                    }
                    assertExpectPagebreak = true;
                    renderer.addPagebreak();
                }
                Renderer.LayoutResult pagebreakEncountered = renderer.validatePages();
                if (SHOW_ROLLBACKS) {
                    logger.debug((Object)("Print: Validate Page returned " + (Object)((Object)pagebreakEncountered)));
                    if (assertExpectPagebreak && pagebreakEncountered != Renderer.LayoutResult.LAYOUT_PAGEBREAK) {
                        logger.debug((Object)"Print: Missed the pagebreak. This smells fishy!");
                    }
                }
                if (pagebreakEncountered != Renderer.LayoutResult.LAYOUT_UNVALIDATABLE) {
                    if (pagebreaksSupported && !state.isArtifcialState() && !isInRollBackMode) {
                        if (pageEventCount >= 10) {
                            if (SHOW_ROLLBACKS) {
                                logger.debug((Object)("Print: Try to apply new fallback state after commit count reached: " + state.getProcessKey()));
                                logger.debug((Object)("Print:        : " + renderer.getLastStateKey()));
                            }
                            fallBackState = realFallbackState;
                            pageEventCount = 0;
                        } else {
                            if (SHOW_ROLLBACKS) {
                                logger.debug((Object)("Print: Increase counter: " + state.getProcessKey()));
                            }
                            ++pageEventCount;
                        }
                    }
                } else if (SHOW_ROLLBACKS && pagebreaksSupported && !state.isArtifcialState() && !isInRollBackMode) {
                    logger.debug((Object)("Print: SKIP : " + state.getProcessKey()));
                }
                if (pagebreakEncountered == Renderer.LayoutResult.LAYOUT_PAGEBREAK) {
                    boolean onGoingPageBreak;
                    ReportStateKey lastVisibleStateKey = renderer.getLastStateKey();
                    if (pagebreaksSupported && !isInRollBackMode && renderer.isOpen() && lastVisibleStateKey != null) {
                        if (!lastVisibleStateKey.equals(nextStateKey) && lastVisibleStateKey.getSequenceCounter() > globalState.getProcessKey().getSequenceCounter()) {
                            rollbackPageState = lastVisibleStateKey;
                            ReportStateKey restoreStateProcessKey = restoreState.getProcessKey();
                            if (SHOW_ROLLBACKS) {
                                logger.debug((Object)("Print: Encountered bad break, need to roll-back: " + rollbackPageState));
                                logger.debug((Object)("Print:    Next StateKey                        : " + state.getProcessKey()));
                                logger.debug((Object)("Print:    Restored Key                         : " + restoreStateProcessKey));
                                logger.debug((Object)("Print:    Position in event chain              : " + restoreState.getSequenceCounter()));
                            }
                            if (lastVisibleStateKey.getSequenceCounter() < restoreStateProcessKey.getSequenceCounter()) {
                                if (SHOW_ROLLBACKS) {
                                    logger.debug((Object)("Print: Fall back to start of page              : " + globalState.getProcessKey()));
                                }
                                if (lastVisibleStateKey.getSequenceCounter() <= globalState.getProcessKey().getSequenceCounter()) {
                                    throw new ReportProcessingException("Print: Error, fallback position is after last visible state.");
                                }
                                state = globalState.deriveForStorage();
                            } else {
                                if (SHOW_ROLLBACKS) {
                                    logger.debug((Object)("Print: Fall back to save-state                 : " + restoreStateProcessKey));
                                }
                                state = restoreState.deriveForPagebreak();
                            }
                            DefaultOutputFunction rollbackOutputFunction = (DefaultOutputFunction)state.getLayoutProcess().getOutputFunction();
                            Renderer rollbackRenderer = rollbackOutputFunction.getRenderer();
                            rollbackRenderer.rollback();
                            this.validate(state);
                            isInRollBackMode = true;
                            continue;
                        }
                        if (SHOW_ROLLBACKS) {
                            logger.debug((Object)("Print: Encountered on-going break " + lastVisibleStateKey));
                        }
                        onGoingPageBreak = true;
                        rollbackPageState = null;
                    } else {
                        if (SHOW_ROLLBACKS) {
                            if (isInRollBackMode) {
                                if (!assertExpectPagebreak) {
                                    logger.debug((Object)("Print: Encountered a roll-back break: " + isInRollBackMode));
                                    if (!assertExpectPagebreak) {
                                        logger.debug((Object)("Print: next state:     " + nextStateKey));
                                        if (!nextStateKey.equals(rollbackPageState)) {
                                            logger.debug((Object)("Print: rollback state: " + rollbackPageState));
                                        }
                                    }
                                }
                            } else {
                                logger.debug((Object)("Print: Encountered a good break: " + isInRollBackMode));
                            }
                            logger.debug((Object)("Print:                                              : " + state.getProcessKey()));
                        }
                        onGoingPageBreak = false;
                    }
                    if (!pagebreaksSupported) {
                        renderer.applyAutoCommit();
                    }
                    if (!renderer.processPage(pagebreakHandler, state.getProcessKey(), performOutput)) {
                        throw new IllegalStateException("This must not be.");
                    }
                    if (this.isPagebreaksSupported()) {
                        if (renderer.isPendingPageHack() && !renderer.isCurrentPageEmpty() && !renderer.isPageStartPending()) {
                            if (SHOW_ROLLBACKS) {
                                logger.debug((Object)("Print: Delaying next event to allow pending pages to be processed: " + state.getProcessKey()));
                            }
                            state = PendingPagesHandler.create(state);
                        } else {
                            if (SHOW_ROLLBACKS) {
                                logger.debug((Object)("Print: Adding RestartOnNewPageHandler to open Page in time: " + state.getProcessKey()));
                            }
                            state = RestartOnNewPageHandler.create(state.commit());
                        }
                    } else {
                        if (SHOW_ROLLBACKS) {
                            logger.debug((Object)("Print: Commit on page-break: " + state.getProcessKey() + " " + state.getAdvanceHandler().getClass().getName()));
                        }
                        state = state.commit();
                    }
                    if (onGoingPageBreak) {
                        renderer.setStateKey(state.getProcessKey());
                        renderer.addProgressBox();
                    }
                    if (SHOW_ROLLBACKS) {
                        logger.debug((Object)("Print: Post Commit: " + state.getProcessKey() + " " + state.getAdvanceHandler().getClass().getName()));
                    }
                    if (this.isPagebreaksSupported() && SHOW_ROLLBACKS) {
                        logger.debug((Object)("Print: Generating new fallback state after pagebreak found: " + state.getProcessKey()));
                    }
                    if (!renderer.isOpen()) continue;
                    return new PageState(state, this.outputProcessor.getPageCursor());
                }
                if (!pagebreaksSupported) {
                    renderer.applyAutoCommit();
                }
                if (pageEventCount == 0 && !isInRollBackMode && pagebreakEncountered == Renderer.LayoutResult.LAYOUT_NO_PAGEBREAK) {
                    if (SHOW_ROLLBACKS) {
                        logger.debug((Object)("Print: Perform incremental update: " + state.getProcessKey()));
                    }
                    renderer.processIncrementalUpdate(performOutput);
                }
                if (SHOW_ROLLBACKS) {
                    logger.debug((Object)("Print: Commit: " + state.getProcessKey() + " " + state.getAdvanceHandler().getClass().getName()));
                }
                state = state.commit();
                if (SHOW_ROLLBACKS) {
                    logger.debug((Object)("Print: Post Commit: " + state.getProcessKey() + " " + state.getAdvanceHandler().getClass().getName()));
                }
                if (!pagebreaksSupported || fallBackState == restoreState) continue;
                DefaultOutputFunction commitableOutputFunction = (DefaultOutputFunction)state.getLayoutProcess().getOutputFunction();
                Renderer commitableRenderer = commitableOutputFunction.getRenderer();
                commitableRenderer.applyRollbackInformation();
            }
            return null;
        }
        catch (ContentProcessingException e) {
            throw new ReportProcessingException("Content-Processing failed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paginate() throws ReportProcessingException {
        this.fireProcessingStarted(new ReportProgressEvent(this));
        try {
            if (!this.isPaginated()) {
                this.prepareReportProcessing();
            }
        }
        finally {
            this.fireProcessingFinished(new ReportProgressEvent(this));
        }
        return true;
    }

    @Override
    public void processReport() throws ReportProcessingException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new MemoryUsageMessage(System.identityHashCode(Thread.currentThread()) + ": Report processing time: Starting: "));
        }
        try {
            long startTime = System.currentTimeMillis();
            this.fireProcessingStarted(new ReportProgressEvent(this));
            if (!this.isPaginated()) {
                this.prepareReportProcessing();
            }
            long paginateTime = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)new MemoryUsageMessage(System.identityHashCode(Thread.currentThread()) + ": Report processing time: Pagination time: " + (double)(paginateTime - startTime) / 1000.0));
            }
            if (this.getLogicalPageCount() == 0) {
                throw new EmptyReportException("Report did not generate any content.");
            }
            PageState state = this.getLogicalPageState(0);
            while (state != null) {
                state = this.processPage(state, true);
            }
            long endTime = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)new MemoryUsageMessage(System.identityHashCode(Thread.currentThread()) + ": Report processing time: " + (double)(endTime - startTime) / 1000.0));
            }
        }
        catch (EmptyReportException re) {
            throw re;
        }
        catch (ReportProcessingException re) {
            logger.error((Object)(System.identityHashCode(Thread.currentThread()) + ": Report processing failed."), (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            logger.error((Object)(System.identityHashCode(Thread.currentThread()) + ": Report processing failed."), (Throwable)e);
            throw new ReportProcessingException("Failed to process the report", e);
        }
        this.fireProcessingFinished(new ReportProgressEvent(this, this.getPhysicalPageCount()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(System.identityHashCode(Thread.currentThread()) + ": Report processing finished."));
        }
    }

    public int getLogicalPageCount() {
        if (this.logicalMapping == null) {
            return -1;
        }
        return this.logicalMapping.size();
    }

    public int getPhysicalPageCount() {
        if (this.physicalMapping == null) {
            return -1;
        }
        return this.physicalMapping.size();
    }

    private boolean isPagebreaksSupported() {
        return this.pagebreaksSupported;
    }
}

