/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import org.pentaho.reporting.engine.classic.core.DetailsFooter;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.NoDataBand;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultOutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.GroupOutputHandler;

public class RelationalGroupOutputHandler
implements GroupOutputHandler {
    @Override
    public void groupStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        int gidx = event.getState().getCurrentGroupIndex();
        RelationalGroup group = (RelationalGroup)event.getReport().getGroup(gidx);
        GroupHeader b = group.getHeader();
        GroupBody groupBody = group.getBody();
        outputFunction.updateFooterArea(event);
        Renderer renderer = outputFunction.getRenderer();
        renderer.startGroup(group, event.getState().getPredictedStateCount());
        renderer.startSection(Renderer.SectionType.NORMALFLOW);
        outputFunction.print(outputFunction.getRuntime(), b);
        outputFunction.addSubReportMarkers(renderer.endSection());
        renderer.startGroupBody(groupBody, event.getState().getPredictedStateCount());
    }

    @Override
    public void itemsStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        NoDataBand noDataBand;
        int numberOfRows = event.getState().getNumberOfRows();
        Renderer renderer = outputFunction.getRenderer();
        outputFunction.updateFooterArea(event);
        DetailsHeader detailsHeader = event.getReport().getDetailsHeader();
        if (detailsHeader != null) {
            renderer.startSection(Renderer.SectionType.NORMALFLOW);
            outputFunction.print(outputFunction.getRuntime(), detailsHeader);
            outputFunction.addSubReportMarkers(renderer.endSection());
        }
        if (numberOfRows == 0 && (noDataBand = event.getReport().getNoDataBand()) != null) {
            renderer.startSection(Renderer.SectionType.NORMALFLOW);
            outputFunction.print(outputFunction.getRuntime(), noDataBand);
            outputFunction.addSubReportMarkers(renderer.endSection());
        }
    }

    @Override
    public void itemsAdvanced(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        Renderer renderer = outputFunction.getRenderer();
        outputFunction.updateFooterArea(event);
        ItemBand itemBand = event.getReport().getItemBand();
        if (itemBand != null) {
            renderer.startSection(Renderer.SectionType.NORMALFLOW);
            outputFunction.print(outputFunction.getRuntime(), itemBand);
            outputFunction.addSubReportMarkers(renderer.endSection());
        }
    }

    @Override
    public void itemsFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        Renderer renderer = outputFunction.getRenderer();
        outputFunction.updateFooterArea(event);
        DetailsFooter detailsFooter = event.getReport().getDetailsFooter();
        if (detailsFooter != null) {
            renderer.startSection(Renderer.SectionType.NORMALFLOW);
            outputFunction.print(outputFunction.getRuntime(), detailsFooter);
            outputFunction.addSubReportMarkers(renderer.endSection());
        }
    }

    @Override
    public void groupBodyFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        Renderer renderer = outputFunction.getRenderer();
        outputFunction.updateFooterArea(event);
        renderer.endGroupBody();
    }

    @Override
    public void groupFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        int gidx = event.getState().getCurrentGroupIndex();
        RelationalGroup g = (RelationalGroup)event.getReport().getGroup(gidx);
        GroupFooter b = g.getFooter();
        Renderer renderer = outputFunction.getRenderer();
        outputFunction.updateFooterArea(event);
        renderer.startSection(Renderer.SectionType.NORMALFLOW);
        outputFunction.print(outputFunction.getRuntime(), b);
        outputFunction.addSubReportMarkers(renderer.endSection());
        renderer.endGroup();
    }

    @Override
    public void summaryRowStart(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
    }

    @Override
    public void summaryRowEnd(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
    }

    @Override
    public void summaryRow(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
    }
}

