/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output.crosstab;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabDetailMode;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroupBody;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class RenderedCrosstabLayout
implements Cloneable {
    private boolean crosstabTableOpen;
    private boolean crosstabRowOpen;
    private boolean processingCrosstabHeader;
    private boolean crosstabHeaderOpen;
    private boolean detailsRendered;
    private boolean generateMeasureHeaders;
    private boolean generateColumnTitleHeaders;
    private boolean summaryRowPrintable;
    private int summaryRowGroupIndex;
    private String summaryRowField;
    private CrosstabSpecification crosstabSpecification;
    private int columnGroups;
    private int rowGroups;
    private int otherGroups;
    private String[] sortedKeys;
    private int crosstabGroupIndex;
    private InstanceID[] columnHeaderSubflows;
    private InstanceID[] rowHeaders;
    private InstanceID[] columnHeaders;
    private InstanceID[] columnTitleHeaders;
    private int firstRowGroupIndex = -1;
    private int firstColGroupIndex = -1;
    private CrosstabDetailMode detailMode;

    public int getFirstRowGroupIndex() {
        return this.firstRowGroupIndex;
    }

    public void setFirstRowGroupIndex(int firstRowGroupIndex) {
        this.firstRowGroupIndex = firstRowGroupIndex;
    }

    public boolean isGenerateMeasureHeaders() {
        return this.generateMeasureHeaders;
    }

    public boolean isGenerateColumnTitleHeaders() {
        return this.generateColumnTitleHeaders;
    }

    public boolean isDetailsRendered() {
        return this.detailsRendered;
    }

    public void setDetailsRendered(boolean detailsRendered) {
        this.detailsRendered = detailsRendered;
    }

    public boolean isCrosstabRowOpen() {
        return this.crosstabRowOpen;
    }

    public void setCrosstabRowOpen(boolean crosstabRowOpen) {
        this.crosstabRowOpen = crosstabRowOpen;
    }

    public boolean isCrosstabTableOpen() {
        return this.crosstabTableOpen;
    }

    public boolean isCrosstabHeaderOpen() {
        return this.crosstabHeaderOpen;
    }

    public void setCrosstabHeaderOpen(boolean crosstabHeaderOpen) {
        this.crosstabHeaderOpen = crosstabHeaderOpen;
    }

    public void setCrosstabTableOpen(boolean crosstabTableOpen) {
        this.crosstabTableOpen = crosstabTableOpen;
    }

    public boolean isProcessingCrosstabHeader() {
        return this.processingCrosstabHeader;
    }

    public void setProcessingCrosstabHeader(boolean processingCrosstabHeader) {
        this.processingCrosstabHeader = processingCrosstabHeader;
    }

    public CrosstabSpecification getCrosstabSpecification() {
        return this.crosstabSpecification;
    }

    public int getColumnGroups() {
        return this.columnGroups;
    }

    public int getRowGroups() {
        return this.rowGroups;
    }

    public int getOtherGroups() {
        return this.otherGroups;
    }

    public String[] getSortedKeys() {
        return this.sortedKeys;
    }

    public int getCrosstabGroupIndex() {
        return this.crosstabGroupIndex;
    }

    public Object clone() {
        try {
            RenderedCrosstabLayout layout = (RenderedCrosstabLayout)super.clone();
            if (this.columnHeaderSubflows != null) {
                layout.columnHeaderSubflows = (InstanceID[])this.columnHeaderSubflows.clone();
            }
            if (this.rowHeaders != null) {
                layout.rowHeaders = (InstanceID[])this.rowHeaders.clone();
            }
            if (this.columnHeaders != null) {
                layout.columnHeaders = (InstanceID[])this.columnHeaders.clone();
            }
            if (this.columnTitleHeaders != null) {
                layout.columnTitleHeaders = (InstanceID[])this.columnTitleHeaders.clone();
            }
            return layout;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException(cne);
        }
    }

    public RenderedCrosstabLayout derive() {
        return (RenderedCrosstabLayout)this.clone();
    }

    public void initialize(CrosstabSpecification crosstabSpecification, CrosstabGroup group, int crosstabGroupIndex) {
        this.crosstabSpecification = crosstabSpecification;
        this.crosstabGroupIndex = crosstabGroupIndex;
        this.computeGroupCounts(group);
        CrosstabDetailMode detailMode = group.getDetailsMode();
        if (detailMode == null) {
            detailMode = CrosstabDetailMode.last;
        }
        this.detailMode = detailMode;
        this.generateMeasureHeaders = !Boolean.FALSE.equals(group.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "print-detail-header"));
        this.generateColumnTitleHeaders = !Boolean.FALSE.equals(group.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "print-column-title-header"));
    }

    private void computeGroupCounts(CrosstabGroup crosstabGroup) {
        ArrayList<String> list = new ArrayList<String>();
        GroupBody body = crosstabGroup.getBody();
        while (body != null) {
            Group otherGroup;
            GroupBody cogb;
            if (body instanceof CrosstabOtherGroupBody) {
                ++this.otherGroups;
                cogb = (CrosstabOtherGroupBody)body;
                otherGroup = ((CrosstabOtherGroupBody)cogb).getGroup();
                list.add(((CrosstabOtherGroup)otherGroup).getField());
                body = otherGroup.getBody();
                continue;
            }
            if (body instanceof CrosstabRowGroupBody) {
                ++this.rowGroups;
                cogb = (CrosstabRowGroupBody)body;
                otherGroup = ((CrosstabRowGroupBody)cogb).getGroup();
                list.add(((CrosstabRowGroup)otherGroup).getField());
                body = otherGroup.getBody();
                continue;
            }
            if (!(body instanceof CrosstabColumnGroupBody)) break;
            ++this.columnGroups;
            cogb = (CrosstabColumnGroupBody)body;
            otherGroup = ((CrosstabColumnGroupBody)cogb).getGroup();
            list.add(((CrosstabColumnGroup)otherGroup).getField());
            body = otherGroup.getBody();
        }
        this.rowHeaders = new InstanceID[this.rowGroups];
        this.columnHeaders = new InstanceID[this.columnGroups];
        this.columnTitleHeaders = new InstanceID[this.columnGroups];
        this.sortedKeys = list.toArray(new String[list.size()]);
    }

    public void setColumnHeaderRowIds(InstanceID[] columnHeaders) {
        if (columnHeaders == null) {
            throw new NullPointerException();
        }
        if (columnHeaders.length < 1) {
            throw new IllegalStateException();
        }
        this.columnHeaderSubflows = columnHeaders;
    }

    public InstanceID[] getColumnHeaderSubFlows() {
        return this.columnHeaderSubflows;
    }

    public InstanceID getRowTitleHeaderId() {
        if (this.columnHeaderSubflows == null) {
            throw new IllegalStateException();
        }
        return this.columnHeaderSubflows[this.columnHeaderSubflows.length - 1];
    }

    public InstanceID getColumnTitleHeaderSubflowId(int gidx) {
        if (!this.generateColumnTitleHeaders) {
            throw new InvalidReportStateException();
        }
        int offset = gidx - this.crosstabGroupIndex - this.otherGroups - this.rowGroups - 1;
        return this.columnHeaderSubflows[offset * 2];
    }

    public InstanceID getColumnHeaderSubflowId(int gidx) {
        int offset = gidx - this.crosstabGroupIndex - this.otherGroups - this.rowGroups - 1;
        if (this.generateColumnTitleHeaders) {
            return this.columnHeaderSubflows[offset * 2 + 1];
        }
        return this.columnHeaderSubflows[offset];
    }

    public InstanceID getMeasureHeaderSubflowId() {
        if (!this.generateMeasureHeaders) {
            throw new InvalidReportStateException();
        }
        return this.columnHeaderSubflows[this.columnHeaderSubflows.length - 1];
    }

    public void setRowHeader(int index, InstanceID instanceId) {
        this.rowHeaders[index] = instanceId;
    }

    public InstanceID getRowHeader(int index) {
        return this.rowHeaders[index];
    }

    public void setColumnHeaderCellId(int index, InstanceID instanceId) {
        this.columnHeaders[index] = instanceId;
    }

    public InstanceID getColumnHeaderCellId(int index) {
        return this.columnHeaders[index];
    }

    public void setColumnTitleHeaderCellId(int index, InstanceID instanceId) {
        this.columnTitleHeaders[index] = instanceId;
    }

    public InstanceID getColumnTitleHeaderCellId(int index) {
        return this.columnTitleHeaders[index];
    }

    public int getFirstColGroupIndex() {
        return this.firstColGroupIndex;
    }

    public void setFirstColGroupIndex(int firstColGroupIndex) {
        this.firstColGroupIndex = firstColGroupIndex;
    }

    public CrosstabDetailMode getDetailMode() {
        return this.detailMode;
    }

    public void startSummaryRowProcessing(boolean summaryRowPrintable, int summaryRowGroupIndex, String summaryRowField) {
        this.summaryRowPrintable = summaryRowPrintable;
        this.summaryRowGroupIndex = summaryRowGroupIndex;
        this.summaryRowField = summaryRowField;
    }

    public void endSummaryRowProcessing() {
        this.summaryRowPrintable = false;
        this.summaryRowGroupIndex = -1;
        this.summaryRowField = null;
    }

    public String getSummaryRowField() {
        return this.summaryRowField;
    }

    public int getSummaryRowGroupIndex() {
        return this.summaryRowGroupIndex;
    }

    public boolean isSummaryRowPrintable() {
        return this.summaryRowPrintable;
    }
}

