/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.TableRowHeightCalculation;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public abstract class AbstractMajorAxisLayoutStep
extends IterateVisualProcessStep {
    protected static final long MAX_AUTO = StrictGeomUtility.MAX_AUTO;
    private boolean cacheClean;
    private TableRowHeightCalculation tableRowHeightStep;

    protected AbstractMajorAxisLayoutStep(boolean secondPass) {
        this.tableRowHeightStep = new TableRowHeightCalculation(secondPass);
    }

    protected TableRowHeightCalculation getTableRowHeightStep() {
        return this.tableRowHeightStep;
    }

    public void compute(LogicalPageBox pageBox) {
        this.tableRowHeightStep.reset();
        this.cacheClean = true;
        this.startProcessing(pageBox);
    }

    public void continueComputation(RenderBox pageBox) {
        this.tableRowHeightStep.reset();
        this.cacheClean = true;
        this.startProcessing(pageBox);
    }

    protected boolean checkCacheValid(RenderNode node) {
        RenderNode.CacheState cacheState = node.getCacheState();
        if (cacheState == RenderNode.CacheState.DEEP_DIRTY) {
            this.cacheClean = false;
        }
        return this.cacheClean && node.isCacheValid();
    }

    protected void performStartTable(RenderBox box) {
        int nodeType = box.getNodeType();
        if (nodeType == 266242) {
            this.tableRowHeightStep.startTableBox((TableRenderBox)box);
        }
    }

    protected void performFinishTable(RenderBox box) {
        int nodeType = box.getNodeType();
        if (nodeType == 266242) {
            this.tableRowHeightStep.finishTable((TableRenderBox)box);
        }
    }
}

