/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnGroupNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;

public final class ApplyCachedValuesStep
extends IterateStructuralProcessStep {
    private boolean cacheClean;

    public void compute(RenderBox box) {
        this.cacheClean = true;
        this.startProcessing(box);
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    @Override
    public boolean startCanvasBox(CanvasRenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        this.processFinishNode(node);
    }

    @Override
    protected void processRenderableContent(RenderableReplacedContentBox box) {
        this.processBox(box);
        box.setOverflowAreaWidth(box.getCachedWidth());
        box.setOverflowAreaHeight(box.getCachedHeight());
        this.processFinishBox(box);
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected boolean startRowBox(RenderBox box) {
        return this.processBox(box);
    }

    private boolean processBox(RenderBox box) {
        if (this.cacheClean) {
            RenderNode.CacheState state = box.getCacheState();
            if (state == RenderNode.CACHE_CLEAN) {
                return false;
            }
            if (state == RenderNode.CACHE_DEEP_DIRTY) {
                this.cacheClean = false;
            }
        }
        box.apply();
        return true;
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected boolean startOtherBox(RenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected void processTableColumn(TableColumnNode box) {
        this.processBox(box);
        this.processFinishBox(box);
    }

    @Override
    protected boolean startTableBox(TableRenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected boolean startTableCellBox(TableCellRenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected boolean startTableColumnGroupBox(TableColumnGroupNode box) {
        return this.processBox(box);
    }

    @Override
    protected boolean startTableRowBox(TableRowRenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected boolean startAutoBox(RenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected void finishAutoBox(RenderBox box) {
        this.processFinishBox(box);
    }

    @Override
    public void finishCanvasBox(CanvasRenderBox box) {
        this.processFinishBox(box);
    }

    @Override
    protected void finishBlockBox(BlockRenderBox box) {
        this.processFinishBox(box);
    }

    @Override
    protected void finishInlineBox(InlineRenderBox box) {
        this.processFinishBox(box);
    }

    @Override
    protected void finishRowBox(RenderBox box) {
        this.processFinishBox(box);
    }

    @Override
    protected void finishOtherBox(RenderBox box) {
        this.processFinishBox(box);
    }

    @Override
    protected void finishTableBox(TableRenderBox box) {
        this.processFinishBox(box);
    }

    @Override
    protected void finishTableCellBox(TableCellRenderBox box) {
        this.processFinishBox(box);
    }

    @Override
    protected void finishTableColumnGroupBox(TableColumnGroupNode box) {
        this.processFinishBox(box);
    }

    @Override
    protected void finishTableRowBox(TableRowRenderBox box) {
        this.processFinishBox(box);
    }

    @Override
    protected void finishTableSectionBox(TableSectionRenderBox box) {
        this.processFinishBox(box);
    }

    private void processFinishBox(RenderBox box) {
        this.processFinishNode(box);
        box.setStaticBoxPropertiesAge(box.getChangeTracker());
    }

    private void processFinishNode(RenderNode box) {
        box.apply();
    }
}

