/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphPoolBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnGroupNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.TableColumnModel;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.AbstractMinorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.MinorAxisLayoutStepUtil;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.TextAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.EndSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineNodeSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.ReplacedContentSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.SequenceList;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.SpacerSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.StartSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.TextSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisNodeContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisNodeContextPool;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisParagraphBreakState;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisTableContext;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;

public final class CanvasMinorAxisLayoutStep
extends AbstractMinorAxisLayoutStep {
    private static final Log logger = LogFactory.getLog(CanvasMinorAxisLayoutStep.class);
    private MinorAxisParagraphBreakState lineBreakState;
    private MinorAxisNodeContext nodeContext;
    private MinorAxisNodeContextPool nodeContextPool = new MinorAxisNodeContextPool();

    public CanvasMinorAxisLayoutStep() {
        this.lineBreakState = new MinorAxisParagraphBreakState();
    }

    @Override
    public void compute(LogicalPageBox root) {
        this.getLineBreakState().clear();
        super.compute(root);
    }

    protected boolean startParagraphBox(RenderBox box) {
        if (box.getNodeType() == 274) {
            ParagraphRenderBox paragraphBox = (ParagraphRenderBox)box;
            if (paragraphBox.isLineBoxUnchanged()) {
                this.nodeContext.updateX2(paragraphBox.getCachedMaxChildX2());
                return false;
            }
            paragraphBox.clearLayout();
            this.getLineBreakState().init(paragraphBox);
        }
        return true;
    }

    protected void finishParagraphBox(RenderBox box) {
        MinorAxisParagraphBreakState lineBreakState = this.getLineBreakState();
        if (lineBreakState.isInsideParagraph() && box.getNodeType() == 274) {
            ParagraphRenderBox paragraph = (ParagraphRenderBox)box;
            paragraph.updateMinorLayoutAge();
            paragraph.setCachedMaxChildX2(this.nodeContext.getMaxChildX2());
            lineBreakState.deinit();
        }
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        MinorAxisNodeContext nodeContext = this.getNodeContext();
        MinorAxisParagraphBreakState breakState = this.getLineBreakState();
        if (box.isComplexParagraph()) {
            RenderBox lineboxContainer = box.getLineboxContainer();
            for (RenderNode node = lineboxContainer.getFirstChild(); node != null; node = node.getNext()) {
                if (node.getNodeType() != 322) {
                    throw new IllegalStateException("Expected ParagraphPoolBox elements.");
                }
                ParagraphPoolBox inlineRenderBox = (ParagraphPoolBox)node;
                if (!this.startLine(inlineRenderBox)) continue;
                this.processBoxChilds(inlineRenderBox);
                this.finishLine(inlineRenderBox, nodeContext, breakState);
            }
        } else {
            ParagraphPoolBox node = box.getPool();
            if (node.getFirstChild() == null) {
                return;
            }
            if (this.startLine(node)) {
                this.processBoxChilds(node);
                this.finishLine(node, nodeContext, breakState);
            }
        }
    }

    private boolean startLine(RenderBox inlineRenderBox) {
        MinorAxisParagraphBreakState breakState = this.getLineBreakState();
        if (!breakState.isInsideParagraph()) {
            return false;
        }
        if (breakState.isSuspended()) {
            return false;
        }
        breakState.clear();
        breakState.add(StartSequenceElement.INSTANCE, inlineRenderBox);
        return true;
    }

    private void finishLine(RenderBox inlineRenderBox, MinorAxisNodeContext nodeContext, MinorAxisParagraphBreakState breakState) {
        if (!breakState.isInsideParagraph() || breakState.isSuspended()) {
            throw new IllegalStateException("No active breakstate, finish-line cannot continue.");
        }
        PageGrid pageGrid = this.getPageGrid();
        OutputProcessorMetaData metaData = this.getMetaData();
        breakState.add(EndSequenceElement.INSTANCE, inlineRenderBox);
        ParagraphRenderBox paragraph = breakState.getParagraph();
        ElementAlignment textAlignment = paragraph.getTextAlignment();
        long textIndent = paragraph.getTextIndent();
        long firstLineIndent = paragraph.getFirstLineIndent();
        TextAlignmentProcessor processor = this.create(textAlignment);
        SequenceList sequence = breakState.getSequence();
        boolean overflowX = paragraph.getStaticBoxLayoutProperties().isOverflowX();
        long lineEnd = overflowX ? nodeContext.getX1() + OVERFLOW_DUMMY_WIDTH : nodeContext.getX2();
        long lineStart = Math.min(lineEnd, nodeContext.getX1() + firstLineIndent);
        if (lineEnd - lineStart <= 0L) {
            long minimumChunkWidth = paragraph.getPool().getMinimumChunkWidth();
            processor.initialize(metaData, sequence, lineStart, lineStart + minimumChunkWidth, pageGrid, overflowX);
            nodeContext.updateX2(lineStart + minimumChunkWidth);
            logger.warn((Object)("Auto-Corrected zero-width first-line on paragraph - " + paragraph.getName()));
        } else {
            processor.initialize(metaData, sequence, lineStart, lineEnd, pageGrid, overflowX);
            if (!overflowX) {
                nodeContext.updateX2(lineEnd);
            }
        }
        while (processor.hasNext()) {
            RenderBox linebox = processor.next();
            if (linebox.getLayoutNodeType() != 322) {
                throw new IllegalStateException("Line must not be null");
            }
            paragraph.addGeneratedChild(linebox);
            if (!processor.hasNext()) continue;
            lineStart = Math.min(lineEnd, nodeContext.getX1() + textIndent);
            if (lineEnd - lineStart <= 0L) {
                long minimumChunkWidth = paragraph.getPool().getMinimumChunkWidth();
                processor.updateLineSize(lineStart, lineStart + minimumChunkWidth);
                nodeContext.updateX2(lineStart + minimumChunkWidth);
                logger.warn((Object)("Auto-Corrected zero-width text-line on paragraph continuation - " + paragraph.getName()));
                continue;
            }
            processor.updateLineSize(lineStart, lineEnd);
            if (overflowX) continue;
            nodeContext.updateX2(lineEnd);
        }
        processor.deinitialize();
    }

    @Override
    protected MinorAxisNodeContext getNodeContext() {
        return this.nodeContext;
    }

    protected MinorAxisParagraphBreakState getLineBreakState() {
        return this.lineBreakState;
    }

    @Override
    protected boolean startBlockLevelBox(RenderBox box) {
        if (this.lineBreakState.isInsideParagraph()) {
            throw new InvalidReportStateException("A block-level element inside a paragraph is not allowed.");
        }
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, true);
        if (this.checkCacheValid(box)) {
            return false;
        }
        this.startTableContext(box);
        long x = this.nodeContext.getParentX1();
        long left = box.getInsetsLeft();
        long right = box.getInsetsRight();
        long width = MinorAxisLayoutStepUtil.resolveNodeWidthOnStart(box, this.nodeContext, x);
        assert (width >= 0L);
        this.nodeContext.setArea(x, left, right, width);
        return this.startParagraphBox(box);
    }

    @Override
    protected void processBlockLevelNode(RenderNode node) {
        assert (node instanceof FinishedRenderNode);
        node.setCachedX(this.nodeContext.getX1());
        node.setCachedWidth(this.nodeContext.getContentAreaWidth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishBlockLevelBox(RenderBox box) {
        try {
            if (this.checkCacheValid(box)) {
                this.nodeContext.updateParentX2(box.getCachedX2());
                return;
            }
            box.setCachedX(this.nodeContext.getX());
            box.setContentAreaX1(this.nodeContext.getX1());
            box.setContentAreaX2(this.nodeContext.getX2());
            if (!this.finishTableContext(box)) {
                box.setCachedWidth(MinorAxisLayoutStepUtil.resolveNodeWidthOnFinish(box, this.nodeContext, this.isStrictLegacyMode()));
            }
            this.nodeContext.updateParentX2(box.getCachedX2());
            this.finishParagraphBox(box);
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    private long computeCanvasPosition(RenderNode node) {
        long contentAreaX1 = this.nodeContext.getParentX1();
        long bcw = this.nodeContext.getBlockContextWidth();
        double posX = node.getNodeLayoutProperties().getPosX();
        long position = RenderLength.resolveLength(bcw, posX);
        return contentAreaX1 + position;
    }

    @Override
    protected boolean startCanvasLevelBox(RenderBox box) {
        if (this.lineBreakState.isInsideParagraph()) {
            throw new IllegalStateException("This cannot be.");
        }
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, false);
        if (this.checkCacheValid(box)) {
            return false;
        }
        this.startTableContext(box);
        long x = this.computeCanvasPosition(box);
        long left = box.getInsetsLeft();
        long right = box.getInsetsRight();
        long width = this.isStrictLegacyMode() && !box.useMinimumChunkWidth() ? MinorAxisLayoutStepUtil.resolveNodeWidthOnStartForCanvasLegacy(box, this.nodeContext, x) : MinorAxisLayoutStepUtil.resolveNodeWidthOnStart(box, this.nodeContext, x);
        assert (width >= 0L);
        this.nodeContext.setArea(x, left, right, width);
        return this.startParagraphBox(box);
    }

    @Override
    protected void processCanvasLevelNode(RenderNode node) {
        assert (node instanceof FinishedRenderNode);
        node.setCachedX(this.computeCanvasPosition(node));
        node.setCachedWidth(node.getMaximumBoxWidth());
        this.nodeContext.updateParentX2(node.getCachedX2());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishCanvasLevelBox(RenderBox box) {
        try {
            if (this.checkCacheValid(box)) {
                this.nodeContext.updateParentX2(box.getCachedX2());
                return;
            }
            box.setCachedX(this.nodeContext.getX());
            box.setContentAreaX1(this.nodeContext.getX1());
            box.setContentAreaX2(this.nodeContext.getX2());
            if (!this.finishTableContext(box)) {
                box.setCachedWidth(MinorAxisLayoutStepUtil.resolveNodeWidthOnFinish(box, this.nodeContext, this.isStrictLegacyMode()));
            }
            this.nodeContext.updateParentX2(box.getCachedX2());
            this.finishParagraphBox(box);
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    private long computeRowPosition(RenderNode node) {
        RenderBox parent = node.getParent();
        if (parent == null) {
            return 0L;
        }
        RenderNode prev = node.getPrev();
        if (prev != null) {
            return prev.getCachedX() + prev.getCachedWidth();
        }
        return this.nodeContext.getParentX1();
    }

    @Override
    protected boolean startRowLevelBox(RenderBox box) {
        if (this.lineBreakState.isInsideParagraph()) {
            throw new IllegalStateException("This cannot be.");
        }
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, false);
        if (this.checkCacheValid(box)) {
            return false;
        }
        this.startTableContext(box);
        long x = this.computeRowPosition(box);
        long left = box.getInsetsLeft();
        long right = box.getInsetsRight();
        long width = MinorAxisLayoutStepUtil.resolveNodeWidthOnStart(box, this.nodeContext, x);
        assert (width >= 0L);
        this.nodeContext.setArea(x, left, right, width);
        return this.startParagraphBox(box);
    }

    @Override
    protected void processRowLevelNode(RenderNode node) {
        assert (node instanceof FinishedRenderNode);
        node.setCachedX(this.computeRowPosition(node));
        node.setCachedWidth(node.getMaximumBoxWidth());
        this.nodeContext.updateParentX2(node.getCachedX2());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishRowLevelBox(RenderBox box) {
        try {
            if (this.checkCacheValid(box)) {
                this.nodeContext.updateParentX2(box.getCachedX2());
                return;
            }
            box.setCachedX(this.nodeContext.getX());
            box.setContentAreaX1(this.nodeContext.getX1());
            box.setContentAreaX2(this.nodeContext.getX2());
            if (!this.finishTableContext(box)) {
                long cachedWidth = MinorAxisLayoutStepUtil.resolveNodeWidthOnFinish(box, this.nodeContext, this.isStrictLegacyMode());
                box.setCachedWidth(cachedWidth);
            }
            this.nodeContext.updateParentX2(box.getCachedX2());
            this.finishParagraphBox(box);
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    @Override
    protected boolean startInlineLevelBox(RenderBox box) {
        if (!this.lineBreakState.isInsideParagraph()) {
            throw new InvalidReportStateException("A inline-level box outside of a paragraph box is not allowed.");
        }
        int nodeType = box.getLayoutNodeType();
        if (nodeType == 258) {
            this.lineBreakState.add(ReplacedContentSequenceElement.INSTANCE, box);
            return false;
        }
        this.lineBreakState.add(StartSequenceElement.INSTANCE, box);
        return true;
    }

    @Override
    protected void processInlineLevelNode(RenderNode node) {
        if (!this.lineBreakState.isInsideParagraph()) {
            throw new InvalidReportStateException("A inline-level box outside of a paragraph box is not allowed.");
        }
        int nodeType = node.getNodeType();
        if (nodeType == 129) {
            FinishedRenderNode finNode = (FinishedRenderNode)node;
            node.setCachedWidth(finNode.getLayoutedWidth());
            return;
        }
        if (nodeType == 17) {
            this.lineBreakState.add(TextSequenceElement.INSTANCE, node);
        } else if (nodeType == 65) {
            StyleSheet styleSheet = node.getStyleSheet();
            if (WhitespaceCollapse.PRESERVE.equals(styleSheet.getStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE)) && !styleSheet.getBooleanStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT)) {
                this.lineBreakState.add(SpacerSequenceElement.INSTANCE, node);
            } else if (this.lineBreakState.isContainsContent()) {
                this.lineBreakState.add(SpacerSequenceElement.INSTANCE, node);
            }
        } else {
            this.lineBreakState.add(InlineNodeSequenceElement.INSTANCE, node);
        }
    }

    @Override
    protected void finishInlineLevelBox(RenderBox box) {
        if (!this.lineBreakState.isInsideParagraph()) {
            throw new InvalidReportStateException("A inline-level box outside of a paragraph box is not allowed.");
        }
        int nodeType = box.getLayoutNodeType();
        if (nodeType == 258) {
            return;
        }
        this.lineBreakState.add(EndSequenceElement.INSTANCE, box);
    }

    @Override
    protected boolean startTableLevelBox(RenderBox box) {
        if (this.lineBreakState.isInsideParagraph()) {
            throw new IllegalStateException("This cannot be.");
        }
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, true);
        if (this.checkCacheValid(box)) {
            return false;
        }
        if (box.getNodeType() == 327682) {
            this.startTableColGroup((TableColumnGroupNode)box);
        } else if (box.getNodeType() == 393218) {
            this.startTableCol((TableColumnNode)box);
        } else {
            this.startTableSectionOrRow(box);
        }
        return true;
    }

    private void startTableSectionOrRow(RenderBox box) {
        MinorAxisTableContext tableContext = this.getTableContext();
        long x = this.nodeContext.getParentX1();
        long width = tableContext.isStructureValidated() ? tableContext.getTable().getColumnModel().getCachedSize() : MinorAxisLayoutStepUtil.resolveNodeWidthOnStart(box, this.nodeContext, x);
        this.nodeContext.setArea(x, 0L, 0L, width);
    }

    @Override
    protected void processTableLevelNode(RenderNode node) {
        assert (node instanceof FinishedRenderNode);
        node.setCachedX(this.nodeContext.getX1());
        node.setCachedWidth(this.nodeContext.getContentAreaWidth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishTableLevelBox(RenderBox box) {
        try {
            if (this.checkCacheValid(box)) {
                this.nodeContext.updateParentX2(box.getCachedX2());
                return;
            }
            if (box.getNodeType() == 327682) {
                this.finishTableColGroup((TableColumnGroupNode)box);
            } else if (box.getNodeType() == 393218) {
                this.finishTableCol((TableColumnNode)box);
            } else {
                box.setCachedX(this.nodeContext.getX());
                box.setContentAreaX1(this.nodeContext.getX1());
                box.setContentAreaX2(this.nodeContext.getX2());
                box.setCachedWidth(this.resolveTableWidthOnFinish(box));
                this.nodeContext.updateParentX2(box.getCachedX2());
            }
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    @Override
    protected boolean startTableSectionLevelBox(RenderBox box) {
        if (this.lineBreakState.isInsideParagraph()) {
            throw new IllegalStateException("This cannot be.");
        }
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, true);
        this.startTableSectionOrRow(box);
        return true;
    }

    @Override
    protected void processTableSectionLevelNode(RenderNode node) {
        assert (node instanceof FinishedRenderNode);
        node.setCachedX(this.nodeContext.getX1());
        node.setCachedWidth(this.nodeContext.getContentAreaWidth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishTableSectionLevelBox(RenderBox box) {
        try {
            box.setCachedX(this.nodeContext.getX());
            box.setContentAreaX1(this.nodeContext.getX1());
            box.setContentAreaX2(this.nodeContext.getX2());
            box.setCachedWidth(this.resolveTableWidthOnFinish(box));
            this.nodeContext.updateParentX2(box.getCachedX2());
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    private long resolveTableWidthOnFinish(RenderBox box) {
        MinorAxisTableContext tableContext = this.getTableContext();
        if (tableContext.isStructureValidated()) {
            return tableContext.getTable().getColumnModel().getCachedSize();
        }
        return MinorAxisLayoutStepUtil.resolveNodeWidthOnFinish(box, this.nodeContext, this.isStrictLegacyMode());
    }

    @Override
    protected boolean startTableRowLevelBox(RenderBox box) {
        if (this.lineBreakState.isInsideParagraph()) {
            throw new IllegalStateException("This cannot be.");
        }
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, false);
        if (box.getNodeType() != 294914) {
            this.startTableSectionOrRow(box);
            return true;
        }
        MinorAxisTableContext tableContext = this.getTableContext();
        TableCellRenderBox tableCellRenderBox = (TableCellRenderBox)box;
        int columnIndex = tableCellRenderBox.getColumnIndex();
        TableColumnModel columnModel = tableContext.getColumnModel();
        long startOfRowX = this.nodeContext.getParentX1();
        long x = startOfRowX + columnModel.getCellPosition(columnIndex);
        long insetsLeft = Math.max(box.getInsetsLeft(), columnModel.getBorderSpacing() / 2L);
        long insetsRight = Math.max(box.getInsetsRight(), columnModel.getBorderSpacing() / 2L);
        long width = this.computeCellWidth(tableCellRenderBox);
        this.nodeContext.setArea(x, insetsLeft, insetsRight, width);
        return true;
    }

    @Override
    protected void processTableRowLevelNode(RenderNode node) {
        assert (node instanceof FinishedRenderNode);
        node.setCachedX(this.nodeContext.getX1());
        node.setCachedWidth(this.nodeContext.getContentAreaWidth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishTableRowLevelBox(RenderBox box) {
        try {
            box.setCachedX(this.nodeContext.getX());
            box.setContentAreaX1(this.nodeContext.getX1());
            box.setContentAreaX2(this.nodeContext.getX2());
            if (box.getNodeType() != 294914) {
                box.setCachedWidth(this.resolveTableWidthOnFinish(box));
                this.nodeContext.updateParentX2(box.getCachedX2());
            } else {
                box.setCachedWidth(MinorAxisLayoutStepUtil.resolveNodeWidthOnFinish(box, this.nodeContext, this.isStrictLegacyMode()));
                TableCellRenderBox cell = (TableCellRenderBox)box;
                MinorAxisTableContext tableContext = this.getTableContext();
                TableRenderBox table = tableContext.getTable();
                if (!tableContext.isStructureValidated()) {
                    table.getColumnModel().updateCellSize(cell.getColumnIndex(), cell.getColSpan(), box.getCachedWidth() - box.getInsets());
                }
                this.nodeContext.updateParentX2(box.getCachedX2());
            }
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    @Override
    protected boolean startTableCellLevelBox(RenderBox box) {
        return this.startBlockLevelBox(box);
    }

    @Override
    protected void processTableCellLevelNode(RenderNode node) {
        this.processBlockLevelNode(node);
    }

    @Override
    protected void finishTableCellLevelBox(RenderBox box) {
        this.finishBlockLevelBox(box);
    }

    @Override
    protected boolean startTableColGroupLevelBox(RenderBox box) {
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, false);
        if (this.checkCacheValid(box)) {
            return false;
        }
        if (box.getNodeType() == 393218) {
            this.startTableCol((TableColumnNode)box);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishTableColGroupLevelBox(RenderBox box) {
        try {
            if (this.checkCacheValid(box)) {
                return;
            }
            if (box.getNodeType() == 393218) {
                this.finishTableCol((TableColumnNode)box);
            }
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    private void startTableCol(TableColumnNode box) {
    }

    private void finishTableCol(TableColumnNode box) {
    }

    private void startTableColGroup(TableColumnGroupNode box) {
    }

    private void finishTableColGroup(TableColumnGroupNode box) {
    }
}

