/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnGroupNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public final class CleanFlowBoxesStep
extends IterateStructuralProcessStep {
    private ReportStateKey lastSeenStateKey;
    private BoxContext boxContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute(LogicalPageBox pageBox) {
        this.boxContext = new BoxContext(null, true);
        try {
            if (this.startBlockBox(pageBox)) {
                this.processBoxChilds(pageBox);
            }
            this.finishBlockBox(pageBox);
        }
        finally {
            this.boxContext = null;
        }
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
    }

    @Override
    protected boolean startRowBox(RenderBox box) {
        this.boxContext = new BoxContext(this.boxContext, box.isFinishedTable() && box.isCommited());
        ReportStateKey stateKey = box.getStateKey();
        if (stateKey != null) {
            this.lastSeenStateKey = stateKey;
        }
        return true;
    }

    @Override
    protected void finishRowBox(RenderBox box) {
        box.setDeepFinished(this.boxContext.isFinished());
        this.boxContext = this.boxContext.pop();
    }

    @Override
    protected boolean startCanvasBox(CanvasRenderBox box) {
        this.boxContext = new BoxContext(this.boxContext, box.isFinishedTable() && box.isCommited());
        ReportStateKey stateKey = box.getStateKey();
        if (stateKey != null) {
            this.lastSeenStateKey = stateKey;
        }
        return true;
    }

    @Override
    protected void finishCanvasBox(CanvasRenderBox box) {
        box.setDeepFinished(this.boxContext.isFinished());
        this.boxContext = this.boxContext.pop();
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox box) {
        return this.startBlockStyleBox(box);
    }

    private boolean startBlockStyleBox(RenderBox box) {
        this.boxContext = new BoxContext(this.boxContext, box.isFinishedTable() && box.isCommited());
        ReportStateKey stateKey = box.getStateKey();
        if (stateKey != null) {
            this.lastSeenStateKey = stateKey;
        }
        return true;
    }

    @Override
    protected void finishBlockBox(BlockRenderBox box) {
        this.finishBlockStyleBox(box);
    }

    private void finishBlockStyleBox(RenderBox box) {
        RenderNode next;
        boolean finished = this.boxContext.isFinished();
        box.setDeepFinished(finished);
        this.boxContext = this.boxContext.pop();
        RenderNode first = box.getFirstChild();
        if (first == null) {
            return;
        }
        if (!first.isDeepFinishedTable()) {
            return;
        }
        RenderNode last = first;
        while ((next = last.getNext()) != null && next.isDeepFinishedTable()) {
            last = next;
        }
        if (last == first && first.getNodeType() == 129) {
            return;
        }
        long nodeY = first.getY();
        long width = box.getContentAreaX2() - box.getContentAreaX1();
        long lastY2 = last.getY() + last.getOverflowAreaHeight();
        long height = lastY2 - nodeY;
        long marginsTop = first.getEffectiveMarginTop();
        long marginsBottom = last.getEffectiveMarginBottom();
        boolean breakAfter = last.isBreakAfter();
        FinishedRenderNode replacement = new FinishedRenderNode(box.getContentAreaX1(), nodeY, width, height, marginsTop, marginsBottom, breakAfter, false, this.lastSeenStateKey);
        RenderNode removeNode = first;
        while (removeNode != last) {
            RenderNode next2 = removeNode.getNext();
            if (removeNode.isOpen()) {
                throw new IllegalStateException("A node is still open. We should not have come that far.");
            }
            box.remove(removeNode);
            removeNode = next2;
        }
        if (last.isOpen()) {
            throw new IllegalStateException("The last node is still open. We should not have come that far.");
        }
        box.replaceChild(last, replacement);
        if (replacement.getParent() != box) {
            throw new IllegalStateException("The replacement did not work.");
        }
    }

    @Override
    protected boolean startTableColumnGroupBox(TableColumnGroupNode box) {
        return false;
    }

    @Override
    protected boolean startTableRowBox(TableRowRenderBox box) {
        this.boxContext = new BoxContext(this.boxContext, false);
        return true;
    }

    @Override
    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        if (box.getDisplayRole() == TableSectionRenderBox.Role.BODY) {
            return this.startBlockStyleBox(box);
        }
        return false;
    }

    @Override
    protected void finishTableSectionBox(TableSectionRenderBox box) {
        if (box.getDisplayRole() == TableSectionRenderBox.Role.BODY) {
            this.finishBlockStyleBox(box);
        }
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        ReportStateKey stateKey;
        if (node.getNodeType() == 129 && (stateKey = node.getStateKey()) != null) {
            this.lastSeenStateKey = stateKey;
        }
    }

    @Override
    protected boolean startTableCellBox(TableCellRenderBox box) {
        return this.startBlockStyleBox(box);
    }

    @Override
    protected void finishTableCellBox(TableCellRenderBox box) {
        this.finishBlockStyleBox(box);
    }

    @Override
    protected boolean startAutoBox(RenderBox box) {
        int layoutNodeType = box.getLayoutNodeType();
        int filteredType = layoutNodeType & 0xFF0FE;
        if (filteredType == 18) {
            return this.startBlockStyleBox(box);
        }
        return false;
    }

    @Override
    protected void finishAutoBox(RenderBox box) {
        int layoutNodeType = box.getLayoutNodeType();
        int filteredType = layoutNodeType & 0xFF0FE;
        if (filteredType == 18) {
            this.finishBlockStyleBox(box);
        }
    }

    private static class BoxContext {
        private BoxContext parent;
        private boolean finished;

        private BoxContext(BoxContext parent, boolean finished) {
            this.parent = parent;
            this.finished = finished;
        }

        public void markUnfinished() {
            this.finished = false;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public BoxContext pop() {
            if (this.parent != null && !this.finished) {
                this.parent.markUnfinished();
            }
            return this.parent;
        }
    }
}

