/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositionList;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBoxNonAutoIterator;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnGroupNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRowModel;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public final class CleanPaginatedBoxesStep
extends IterateStructuralProcessStep {
    private long pageOffset;
    private long shiftOffset;
    private InstanceID shiftNode;
    private PageBreakPositionList allVerticalBreaks;

    public long compute(LogicalPageBox pageBox) {
        this.shiftOffset = 0L;
        this.pageOffset = pageBox.getPageOffset();
        this.allVerticalBreaks = pageBox.getAllVerticalBreaks();
        if (this.startBlockBox(pageBox)) {
            this.processBoxChilds(pageBox);
        }
        this.finishBlockBox(pageBox);
        return this.shiftOffset;
    }

    public InstanceID getShiftNode() {
        return this.shiftNode;
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
    }

    @Override
    public boolean startCanvasBox(CanvasRenderBox box) {
        return false;
    }

    @Override
    protected boolean startRowBox(RenderBox box) {
        return true;
    }

    @Override
    protected boolean startTableColumnGroupBox(TableColumnGroupNode box) {
        return false;
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox box) {
        return this.startBlockStyleBox(box);
    }

    @Override
    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        if (box.getDisplayRole() == TableSectionRenderBox.Role.BODY) {
            return this.startCleanTableRowBoxesFromSection(box);
        }
        return false;
    }

    @Override
    protected boolean startTableCellBox(TableCellRenderBox box) {
        return this.startBlockBox(box);
    }

    private Boolean filterNonRemovableStates(RenderBox box) {
        if (!box.isFinishedPaginate()) {
            return Boolean.TRUE;
        }
        RenderNode firstNode = box.getFirstChild();
        if (firstNode == null) {
            return Boolean.FALSE;
        }
        long nodeY = firstNode.getY();
        if (nodeY > this.pageOffset) {
            return Boolean.FALSE;
        }
        if (firstNode.isOpen()) {
            return Boolean.TRUE;
        }
        return null;
    }

    private boolean startCleanTableRowBoxesFromSection(TableSectionRenderBox box) {
        RenderNode rowNode;
        if (!box.isFinishedPaginate()) {
            return true;
        }
        Boolean filterResult = this.filterNonRemovableStates(box);
        if (filterResult != null) {
            return filterResult;
        }
        TableRowModel rowModel = box.getRowModel();
        RenderBoxNonAutoIterator rows = new RenderBoxNonAutoIterator(box);
        RenderNode lastNode = null;
        while (rows.hasNext() && (rowNode = rows.next()).isFinishedPaginate() && !rowNode.isOpen()) {
            if (rowNode.getNodeType() != 278530) continue;
            TableRowRenderBox rowRenderBox = (TableRowRenderBox)rowNode;
            long height = rowModel.getValidatedRowSpanSize(rowRenderBox.getRowIndex());
            if (rowNode.getY() + height > this.pageOffset) break;
            lastNode = rowNode;
        }
        if (lastNode != null) {
            RenderBox parent = lastNode.getParent();
            RenderNode firstChild = parent.getFirstChild();
            this.removeFinishedNodes(parent, firstChild, lastNode, lastNode.isOrphanLeaf());
        }
        return true;
    }

    private boolean startBlockStyleBox(RenderBox box) {
        boolean safeForRemove;
        int nodeType = box.getLayoutNodeType();
        if (nodeType == 274) {
            return false;
        }
        if (!box.isFinishedPaginate()) {
            return true;
        }
        boolean bl = safeForRemove = box.getParentWidowContexts() == 0 && box.getY() + box.getOverflowAreaHeight() <= this.pageOffset;
        if (safeForRemove || box.getRestrictFinishedClearOut() == RenderBox.RestrictFinishClearOut.UNRESTRICTED) {
            RenderNode firstNode;
            RenderNode lastToRemove = null;
            for (RenderNode currentNode = firstNode = box.getFirstChild(); currentNode != null && !currentNode.isOpen() && currentNode.getY() + currentNode.getOverflowAreaHeight() <= this.pageOffset; currentNode = currentNode.getNext()) {
                lastToRemove = currentNode;
            }
            if (lastToRemove != null) {
                this.removeFinishedNodes(box, firstNode, lastToRemove, false);
            }
        } else {
            for (RenderNode currentNode = box.getFirstChild(); currentNode != null && !currentNode.isOpen() && currentNode.getY() + currentNode.getOverflowAreaHeight() <= this.pageOffset; currentNode = currentNode.getNext()) {
                RenderNode nodeForRemoval = currentNode;
                if (!this.isSafeForRemoval(nodeForRemoval)) continue;
                this.removeFinishedNodes(box, nodeForRemoval, nodeForRemoval, true);
            }
        }
        return true;
    }

    private boolean isSafeForRemoval(RenderNode node) {
        RenderBox box;
        RenderNode child;
        if (node.isOrphanLeaf()) {
            return true;
        }
        if (node.getRestrictFinishedClearOut() == RenderBox.RestrictFinishClearOut.UNRESTRICTED) {
            return true;
        }
        if ((node.getNodeType() & 2) == 2 && (child = (box = (RenderBox)node).getFirstChild()) != null && child == box.getLastChild()) {
            if (child.isOrphanLeaf()) {
                return true;
            }
            if (child.getRestrictFinishedClearOut() == RenderBox.RestrictFinishClearOut.UNRESTRICTED) {
                return true;
            }
        }
        return false;
    }

    private void removeFinishedNodes(RenderBox box, RenderNode firstNode, RenderNode last, boolean leaf) {
        long startOfBox;
        if (last.isOpen()) {
            throw new IllegalStateException("The last node is still open. We should not have come that far.");
        }
        if (last == firstNode && last.getNodeType() == 129) {
            return;
        }
        long width = box.getContentAreaX2() - box.getContentAreaX1();
        long lastY2 = last.getNext() == null ? last.getY() + last.getHeight() : last.getNext().getY();
        RenderNode prev = firstNode.getPrev();
        if (prev == null) {
            StaticBoxLayoutProperties sblp = box.getStaticBoxLayoutProperties();
            long insetsTop = sblp.getBorderTop() + box.getBoxDefinition().getPaddingTop();
            startOfBox = box.getY() + insetsTop;
        } else {
            startOfBox = prev.getY() + prev.getHeight();
        }
        long height = lastY2 - startOfBox;
        if (startOfBox + height > this.pageOffset) {
            throw new IllegalStateException("This finished node will intrude into the visible area.");
        }
        long marginsTop = firstNode.getEffectiveMarginTop();
        long marginsBottom = last.getEffectiveMarginBottom();
        boolean breakAfter = this.isBreakAfter(last);
        RenderNode removeNode = firstNode;
        while (removeNode != last) {
            RenderNode next = removeNode.getNext();
            if (removeNode.isOpen()) {
                throw new IllegalStateException("A node is still open. We should not have come that far.");
            }
            box.remove(removeNode);
            removeNode = next;
        }
        FinishedRenderNode replacement = new FinishedRenderNode(box.getContentAreaX1(), startOfBox, width, height, marginsTop, marginsBottom, breakAfter, leaf);
        box.replaceChild(last, replacement);
        if (replacement.getParent() != box) {
            throw new IllegalStateException("The replacement did not work.");
        }
        long cachedY2 = last.getNext() == null ? last.getCachedY() + last.getCachedHeight() : last.getNext().getCachedY();
        long newShift = lastY2 - cachedY2;
        if (newShift > this.shiftOffset) {
            this.shiftOffset = newShift;
            this.shiftNode = box.getInstanceId();
        }
    }

    private boolean isBreakAfter(RenderNode node) {
        RenderBox box;
        RenderNode lastChild;
        if (node.isBreakAfter()) {
            return true;
        }
        if ((node.getLayoutNodeType() & 0x12) == 18 && (lastChild = (box = (RenderBox)node).getLastChild()) != null) {
            return this.isBreakAfter(lastChild);
        }
        return false;
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        return false;
    }

    @Override
    protected boolean startAutoBox(RenderBox box) {
        if ((box.getLayoutNodeType() & 0x12) == 18) {
            return this.startBlockStyleBox(box);
        }
        return true;
    }
}

