/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateSimpleStructureProcessStep;

public class CountBoxesStep
extends IterateSimpleStructureProcessStep {
    private static final Log logger = LogFactory.getLog(CountBoxesStep.class);
    private int totalCount;
    private int finishedBoxes;
    private int autoBoxes;
    private boolean enabled = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.layout.process.EnableCountBoxesStep", "false"));
    private int maxBoxSize;

    public int countChildren(RenderBox box) {
        this.totalCount = 0;
        this.finishedBoxes = 0;
        this.autoBoxes = 0;
        if (box instanceof LogicalPageBox) {
            this.totalCount = 1;
            this.processBoxChilds(box);
        } else {
            this.startProcessing(box);
        }
        return this.totalCount;
    }

    public void process(LogicalPageBox box) {
        if (!this.enabled) {
            return;
        }
        this.totalCount = 0;
        this.finishedBoxes = 0;
        this.autoBoxes = 0;
        this.startProcessing(box);
        logger.debug((Object)MessageFormat.format("CountBoxes: Total={0}; finished={1}; auto={2} - maxWeight={5} - Finished-Ratio: {3} AutoRatio: {4}", this.totalCount, this.finishedBoxes, this.autoBoxes, (double)this.finishedBoxes / (double)this.totalCount * 100.0, (double)this.autoBoxes / (double)this.totalCount * 100.0, this.maxBoxSize));
    }

    protected void count(RenderNode node) {
        ++this.totalCount;
        if (node.getNodeType() == 129) {
            ++this.finishedBoxes;
        }
        if (node.getElementType() instanceof AutoLayoutBoxType) {
            ++this.autoBoxes;
        }
        this.maxBoxSize = Math.max(this.maxBoxSize, node.getChildCount());
    }

    @Override
    protected boolean startBox(RenderBox box) {
        this.count(box);
        return true;
    }

    @Override
    protected void processBoxChilds(RenderBox box) {
        if (box.getNodeType() == 274) {
            ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)box;
            this.processBoxChilds(paragraphRenderBox.getPool());
        } else {
            super.processBoxChilds(box);
        }
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        this.count(node);
    }
}

