/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.util.BoxShifter;

public final class FillFlowPagesStep
extends IterateVisualProcessStep {
    private CellInfo cellInfo;
    private long contentEnd;
    private long contentStart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicalPageBox compute(LogicalPageBox pagebox, long pageStart, long pageEnd) {
        this.contentStart = pagebox.getHeaderArea().getHeight();
        this.contentEnd = pageEnd - pageStart + this.contentStart;
        LogicalPageBox derived = pagebox.derive(true);
        BoxShifter.shiftBoxUnchecked(derived, -pageStart + this.contentStart);
        try {
            this.cellInfo = null;
            this.processBoxChilds(derived);
        }
        finally {
            this.cellInfo = null;
        }
        BlockRenderBox repeatFooterArea = derived.getRepeatFooterArea();
        long repeatFooterShift = this.contentEnd;
        BoxShifter.shiftBoxUnchecked(repeatFooterArea, repeatFooterShift);
        BlockRenderBox footerArea = derived.getFooterArea();
        long footerShift = this.contentEnd + repeatFooterArea.getHeight();
        BoxShifter.shiftBoxUnchecked(footerArea, footerShift);
        derived.setPageOffset(0L);
        derived.setPageEnd(this.contentEnd + footerArea.getHeight() + repeatFooterArea.getHeight());
        return derived;
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    @Override
    protected boolean startBlockLevelBox(RenderBox box) {
        return this.processBox(box);
    }

    private boolean isFiltered(long y, long height) {
        if (y == this.contentStart && height == 0L) {
            return false;
        }
        if (y + height <= this.contentStart) {
            return true;
        }
        return y >= this.contentEnd;
    }

    @Override
    protected boolean startRowLevelBox(RenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected boolean startCanvasLevelBox(RenderBox box) {
        return this.processBox(box);
    }

    private boolean processBox(RenderBox box) {
        RenderNode node = box.getFirstChild();
        while (node != null) {
            if (node.isIgnorableForRendering()) {
                node = node.getNext();
                continue;
            }
            if (this.isFiltered(node.getY(), node.getOverflowAreaHeight())) {
                RenderNode next = node.getNext();
                box.remove(node);
                node = next;
                continue;
            }
            node = node.getNext();
        }
        return true;
    }

    @Override
    protected boolean startTableLevelBox(RenderBox box) {
        TableSectionRenderBox tsr;
        if (box.getNodeType() == 270338 && (tsr = (TableSectionRenderBox)box).getDisplayRole() == TableSectionRenderBox.Role.BODY) {
            this.cellInfo = new CellInfo(this.cellInfo);
            return true;
        }
        return false;
    }

    @Override
    protected void finishTableLevelBox(RenderBox box) {
        TableSectionRenderBox tsr;
        if (box.getNodeType() == 270338 && (tsr = (TableSectionRenderBox)box).getDisplayRole() == TableSectionRenderBox.Role.BODY) {
            for (RenderBox child : this.cellInfo.renderBoxes) {
                child.getParent().remove(child);
            }
            this.cellInfo.renderBoxes.clear();
            this.cellInfo = this.cellInfo.parent;
        }
    }

    @Override
    protected boolean startTableSectionLevelBox(RenderBox box) {
        if (box.getNodeType() == 278530) {
            this.cellInfo.y = Long.MAX_VALUE;
            this.cellInfo.y2 = Long.MIN_VALUE;
        }
        return true;
    }

    @Override
    protected void finishTableSectionLevelBox(RenderBox box) {
        if (this.cellInfo.y == Long.MAX_VALUE) {
            return;
        }
        if (this.isFiltered(this.cellInfo.y, this.cellInfo.y2 - this.cellInfo.y)) {
            this.cellInfo.renderBoxes.add(box);
        }
    }

    @Override
    protected boolean startTableCellLevelBox(RenderBox box) {
        this.cellInfo.y = Math.min(box.getY(), this.cellInfo.y);
        this.cellInfo.y2 = Math.max(box.getY() + box.getOverflowAreaHeight(), this.cellInfo.y2);
        return this.processBox(box);
    }

    private class CellInfo {
        private CellInfo parent;
        private long y;
        private long y2;
        private ArrayList<RenderBox> renderBoxes = new ArrayList();

        public CellInfo(CellInfo cellInfo) {
            this.parent = cellInfo;
        }
    }
}

