/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.FlowPageBreakPositionList;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositionList;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositions;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.FindOldestProcessKeyStep;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.PaginationStepLib;
import org.pentaho.reporting.engine.classic.core.layout.process.util.BoxShifter;
import org.pentaho.reporting.engine.classic.core.layout.process.util.FlowPaginationTableState;
import org.pentaho.reporting.engine.classic.core.layout.process.util.InitialPaginationShiftState;
import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationResult;
import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationShiftState;
import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationShiftStatePool;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public final class FlowPaginationStep
extends IterateVisualProcessStep {
    private static final Log logger = LogFactory.getLog(FlowPaginationStep.class);
    private boolean breakPending;
    private FindOldestProcessKeyStep findOldestProcessKeyStep = new FindOldestProcessKeyStep();
    private FlowPageBreakPositionList basePageBreakList = new FlowPageBreakPositionList();
    private ReportStateKey visualState;
    private FlowPaginationTableState paginationTableState;
    private PaginationShiftState shiftState;
    private PaginationShiftStatePool shiftStatePool = new PaginationShiftStatePool();
    private long pageOffsetKey;
    private boolean unresolvedWidowReferenceEncountered;
    private long recordedPageBreakPosition;
    private boolean recordedPageBreakPositionIsForced;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaginationResult performPagebreak(LogicalPageBox pageBox) {
        PaginationStepLib.assertProgress(pageBox);
        this.unresolvedWidowReferenceEncountered = false;
        this.visualState = null;
        this.pageOffsetKey = pageBox.getPageOffset();
        this.shiftState = new InitialPaginationShiftState();
        this.breakPending = false;
        this.recordedPageBreakPosition = 0L;
        this.recordedPageBreakPositionIsForced = false;
        try {
            boolean nextPageContainsContent;
            boolean pagebreakEncountered;
            PageBreakPositionList allPreviousBreak = pageBox.getAllVerticalBreaks();
            this.basePageBreakList.copyFrom(allPreviousBreak);
            this.paginationTableState = new FlowPaginationTableState(pageBox.getPageOffset(), this.basePageBreakList);
            if (this.startBlockLevelBox(pageBox)) {
                this.processBoxChilds(pageBox);
            }
            this.finishBlockLevelBox(pageBox);
            PaginationStepLib.assertProgress(pageBox);
            this.basePageBreakList.copyFrom(allPreviousBreak);
            boolean bl = pagebreakEncountered = this.recordedPageBreakPosition != 0L && (this.recordedPageBreakPositionIsForced || this.recordedPageBreakPosition != pageBox.getHeight());
            if (!pagebreakEncountered) {
                nextPageContainsContent = false;
            } else {
                this.basePageBreakList.addMajorBreak(this.recordedPageBreakPosition, 0L);
                nextPageContainsContent = this.recordedPageBreakPositionIsForced ? false : pageBox.getHeight() > this.recordedPageBreakPosition;
            }
            PaginationResult paginationResult = new PaginationResult(this.basePageBreakList, pagebreakEncountered, nextPageContainsContent, this.visualState);
            return paginationResult;
        }
        finally {
            this.paginationTableState = null;
            this.visualState = null;
            this.shiftState = null;
        }
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    @Override
    protected boolean startBlockLevelBox(RenderBox box) {
        boolean retval = this.handleStartBlockLevelBox(box);
        this.installTableContext(box);
        return retval;
    }

    private boolean handleStartBlockLevelBox(RenderBox box) {
        this.shiftState = this.shiftStatePool.create(box, this.shiftState);
        long shift = this.shiftState.getShiftForNextChild();
        if (box.isWidowBox()) {
            this.unresolvedWidowReferenceEncountered = true;
        }
        if (this.unresolvedWidowReferenceEncountered) {
            BoxShifter.shiftBox(box, shift);
            return false;
        }
        PaginationStepLib.assertBlockPosition(box, shift);
        if (!this.shiftState.isManualBreakSuspended()) {
            if (this.handleManualBreakOnBox(box, this.shiftState, this.breakPending)) {
                this.breakPending = false;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("pending page-break or manual break: " + box));
                }
                return true;
            }
            this.breakPending = false;
        }
        return this.handleAutomaticPagebreak(box, this.shiftState);
    }

    @Override
    protected void processBlockLevelNode(RenderNode node) {
        long shift = this.shiftState.getShiftForNextChild();
        node.setY(node.getY() + shift);
        if (!this.breakPending && node.isBreakAfter()) {
            boolean bl = this.breakPending = !this.paginationTableState.isOnPageStart(node.getY());
            if (this.breakPending && logger.isDebugEnabled()) {
                logger.debug((Object)("BreakPending True for Node:isBreakAfter: " + node));
            }
        }
    }

    @Override
    protected void finishBlockLevelBox(RenderBox box) {
        this.uninstallTableContext(box);
        if (!this.breakPending && box.isBreakAfter()) {
            boolean bl = this.breakPending = !this.paginationTableState.isOnPageStart(box.getY() + box.getHeight());
            if (this.breakPending && logger.isDebugEnabled()) {
                logger.debug((Object)("BreakPending True for Box:isBreakAfter: " + box));
            }
        }
        this.shiftState = this.shiftState.pop();
    }

    @Override
    protected boolean startCanvasLevelBox(RenderBox box) {
        this.installTableContext(box);
        this.shiftState = this.shiftStatePool.create(box, this.shiftState);
        this.shiftState.suspendManualBreaks();
        box.setY(box.getY() + this.shiftState.getShiftForNextChild());
        return true;
    }

    @Override
    protected void finishCanvasLevelBox(RenderBox box) {
        this.shiftState = this.shiftState.pop();
        this.uninstallTableContext(box);
    }

    @Override
    protected boolean startRowLevelBox(RenderBox box) {
        this.installTableContext(box);
        this.shiftState = this.shiftStatePool.create(box, this.shiftState);
        this.shiftState.suspendManualBreaks();
        box.setY(box.getY() + this.shiftState.getShiftForNextChild());
        return true;
    }

    @Override
    protected void finishRowLevelBox(RenderBox box) {
        this.shiftState = this.shiftState.pop();
        this.uninstallTableContext(box);
    }

    @Override
    protected boolean startTableLevelBox(RenderBox box) {
        this.shiftState = this.shiftStatePool.create(box, this.shiftState);
        if (box.getNodeType() == 270338) {
            TableSectionRenderBox sectionRenderBox = (TableSectionRenderBox)box;
            switch (sectionRenderBox.getDisplayRole()) {
                case HEADER: {
                    this.paginationTableState = new FlowPaginationTableState(this.paginationTableState);
                    this.paginationTableState.suspendVisualStateCollection(true);
                    this.startTableHeaderSection(box, sectionRenderBox);
                    return false;
                }
                case FOOTER: {
                    this.paginationTableState = new FlowPaginationTableState(this.paginationTableState);
                    this.paginationTableState.suspendVisualStateCollection(true);
                    long contextShift = this.shiftState.getShiftForNextChild();
                    BoxShifter.shiftBox(box, contextShift);
                    return false;
                }
                case BODY: {
                    return this.startBlockLevelBox(box);
                }
            }
            throw new IllegalArgumentException();
        }
        return true;
    }

    private void startTableHeaderSection(RenderBox box, TableSectionRenderBox sectionRenderBox) {
        long headerShift;
        long contextShift = this.shiftState.getShiftForNextChild();
        long pageOffset = this.paginationTableState.getPageOffset();
        long delta = pageOffset - (sectionRenderBox.getY() + contextShift);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PageOffset: " + delta));
        }
        if (delta <= 0L) {
            BoxShifter.shiftBox(box, contextShift);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HEADER NOT SHIFTED; DELTA = " + delta + " -> " + contextShift));
            }
            sectionRenderBox.setHeaderShift(this.pageOffsetKey, 0L);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("HEADER SHIFTED; DELTA = " + delta + " -> " + contextShift));
        }
        if ((headerShift = sectionRenderBox.getHeaderShift(this.pageOffsetKey)) == 0L) {
            long previousPageOffset = this.paginationTableState.getBreakPositions().findPageStartPositionForPageEndPosition(pageOffset);
            headerShift = sectionRenderBox.getHeaderShift(previousPageOffset) + box.getHeight();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HeaderShift: " + headerShift + " <=> " + pageOffset + " ; prevOffset=" + previousPageOffset));
            }
            sectionRenderBox.setHeaderShift(this.pageOffsetKey, headerShift);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Existing HeaderShift: " + headerShift + " <=> " + pageOffset));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Table-Height before extension: " + box.getParent().getHeight()));
        }
        BoxShifter.shiftBox(box, delta);
        this.updateStateKeyDeep(box);
        BoxShifter.extendHeight(box.getParent(), box, headerShift);
        this.shiftState.increaseShift(headerShift);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Table-Height after extension: " + box.getParent().getHeight()));
        }
    }

    @Override
    protected void finishTableLevelBox(RenderBox box) {
        if (box.getNodeType() == 270338) {
            TableSectionRenderBox sectionRenderBox = (TableSectionRenderBox)box;
            switch (sectionRenderBox.getDisplayRole()) {
                case HEADER: {
                    this.shiftState = this.shiftState.pop();
                    this.paginationTableState = this.paginationTableState.pop();
                    this.paginationTableState.defineArtificialPageStart(box.getHeight() + this.paginationTableState.getPageOffset());
                    break;
                }
                case FOOTER: {
                    this.shiftState = this.shiftState.pop();
                    this.paginationTableState = this.paginationTableState.pop();
                    break;
                }
                case BODY: {
                    this.finishBlockLevelBox(box);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return;
        }
        this.finishBlockLevelBox(box);
    }

    @Override
    protected boolean startTableSectionLevelBox(RenderBox box) {
        if (box.getNodeType() == 278530 && box.isOpen()) {
            this.paginationTableState = new FlowPaginationTableState(this.paginationTableState);
            this.paginationTableState.suspendVisualStateCollection(false);
        }
        return this.startBlockLevelBox(box);
    }

    @Override
    protected void finishTableSectionLevelBox(RenderBox box) {
        if (box.getNodeType() == 278530 && box.isOpen()) {
            this.paginationTableState = this.paginationTableState.pop();
        }
        this.finishBlockLevelBox(box);
    }

    @Override
    protected boolean startTableRowLevelBox(RenderBox box) {
        return this.startRowLevelBox(box);
    }

    @Override
    protected void finishTableRowLevelBox(RenderBox box) {
        this.finishRowLevelBox(box);
    }

    @Override
    protected boolean startTableCellLevelBox(RenderBox box) {
        this.installTableContext(box);
        return this.startBlockLevelBox(box);
    }

    @Override
    protected void finishTableCellLevelBox(RenderBox box) {
        this.finishBlockLevelBox(box);
        this.uninstallTableContext(box);
    }

    @Override
    protected boolean startInlineLevelBox(RenderBox box) {
        BoxShifter.shiftBox(box, this.shiftState.getShiftForNextChild());
        return false;
    }

    @Override
    protected void processInlineLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void finishInlineLevelBox(RenderBox box) {
    }

    @Override
    protected boolean startTableColLevelBox(RenderBox box) {
        return false;
    }

    @Override
    protected boolean startTableColGroupLevelBox(RenderBox box) {
        return false;
    }

    @Override
    protected void processCanvasLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processRowLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processOtherLevelChild(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processTableLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processTableRowLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processTableSectionLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processTableCellLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processTableColLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    private void updateStateKey(RenderBox box) {
        if (this.paginationTableState.isVisualStateCollectionSuspended()) {
            return;
        }
        if (box.getNodeType() == 266242) {
            return;
        }
        long y = box.getY();
        if (this.recordedPageBreakPosition != 0L && y >= this.recordedPageBreakPosition) {
            return;
        }
        ReportStateKey stateKey = box.getStateKey();
        if (stateKey != null && !stateKey.isInlineSubReportState()) {
            this.visualState = stateKey;
        }
    }

    private void updateStateKeyDeep(RenderBox box) {
        if (this.paginationTableState.isVisualStateCollectionSuspended()) {
            return;
        }
        long y = box.getY();
        if (this.recordedPageBreakPosition != 0L && y >= this.recordedPageBreakPosition) {
            return;
        }
        ReportStateKey reportStateKey = this.findOldestProcessKeyStep.find(box);
        if (reportStateKey != null && !reportStateKey.isInlineSubReportState()) {
            this.visualState = reportStateKey;
        }
    }

    private boolean handleAutomaticPagebreak(RenderBox box, PaginationShiftState boxContext) {
        long shift = boxContext.getShiftForNextChild();
        PageBreakPositions breakUtility = this.paginationTableState.getBreakPositions();
        long boxHeightAndWidowArea = Math.max(box.getHeight(), PaginationStepLib.getWidowConstraint(box, this.shiftState, this.paginationTableState));
        if (!breakUtility.isCrossingPagebreak(box.getY(), boxHeightAndWidowArea, shift)) {
            RenderBox.BreakIndicator breakIndicator = box.getManualBreakIndicator();
            if (breakIndicator == RenderBox.BreakIndicator.INDIRECT_MANUAL_BREAK) {
                long boxY = box.getY();
                box.setY(boxY + shift);
                this.updateStateKey(box);
                return true;
            }
            BoxShifter.shiftBox(box, shift);
            this.updateStateKeyDeep(box);
            return false;
        }
        long boxY = box.getY();
        long boxYShifted = boxY + shift;
        long nextMinorBreak = breakUtility.findNextBreakPosition(boxYShifted);
        long spaceAvailable = nextMinorBreak - boxYShifted;
        if (spaceAvailable == 0L) {
            box.setY(boxYShifted);
            this.updateStateKey(box);
            if (boxYShifted < nextMinorBreak) {
                box.markPinned(nextMinorBreak);
            }
            return true;
        }
        long spaceConsumed = PaginationStepLib.computeNonBreakableBoxHeight(box, boxContext, this.paginationTableState);
        if (spaceAvailable < spaceConsumed) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Automatic pagebreak, after orphan-opt-out: " + box));
                logger.debug((Object)("Automatic pagebreak                      : " + this.visualState));
            }
            long nextShift = nextMinorBreak - boxY;
            long shiftDelta = nextShift - shift;
            box.setY(boxY + nextShift);
            BoxShifter.extendHeight(box.getParent(), box, shiftDelta);
            boxContext.setShift(nextShift);
            this.updateStateKey(box);
            if (box.getY() < nextMinorBreak) {
                box.markPinned(nextMinorBreak);
            }
            return true;
        }
        box.setY(boxYShifted);
        this.updateStateKey(box);
        return true;
    }

    private boolean handleManualBreakOnBox(RenderBox box, PaginationShiftState boxContext, boolean breakPending) {
        RenderBox.BreakIndicator breakIndicator = box.getManualBreakIndicator();
        if (breakIndicator != RenderBox.BreakIndicator.DIRECT_MANUAL_BREAK && !breakPending) {
            return false;
        }
        PageBreakPositions breakUtility = this.paginationTableState.getBreakPositions();
        long shift = boxContext.getShiftForNextChild();
        long boxY = box.getY();
        long shiftedBoxY = boxY + shift;
        long nextMajorBreak = breakUtility.findNextMajorBreakPosition(shiftedBoxY);
        if (nextMajorBreak < shiftedBoxY) {
            box.setY(shiftedBoxY);
        } else if (!this.paginationTableState.isTableProcessing() || shiftedBoxY > nextMajorBreak) {
            long nextShift = nextMajorBreak - boxY;
            long shiftDelta = nextShift - shift;
            box.setY(boxY + nextShift);
            BoxShifter.extendHeight(box.getParent(), box, shiftDelta);
            boxContext.setShift(nextShift);
        } else {
            box.setY(shiftedBoxY);
        }
        long pageEnd = this.paginationTableState.getPageOffset();
        if (box.getY() <= pageEnd) {
            this.updateStateKey(box);
            box.markPinned(pageEnd);
        } else if (this.recordedPageBreakPosition == 0L) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Breaking on box " + box));
            }
            this.recordedPageBreakPosition = box.getY();
        }
        if (this.recordedPageBreakPosition == box.getY() && box.getNodeType() == 530) {
            this.recordedPageBreakPositionIsForced = true;
        }
        return true;
    }

    protected void installTableContext(RenderBox box) {
        if (box.getNodeType() != 266242) {
            return;
        }
        this.paginationTableState = new FlowPaginationTableState(this.paginationTableState);
    }

    protected void uninstallTableContext(RenderBox box) {
        if (box.getNodeType() != 266242) {
            return;
        }
        this.paginationTableState = this.paginationTableState.pop();
    }
}

