/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.TextCache;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.text.DefaultRenderableTextFactory;
import org.pentaho.reporting.engine.classic.core.layout.text.RenderableTextFactory;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.manual.Utf16LE;

public final class RevalidateTextEllipseProcessStep
extends IterateStructuralProcessStep {
    private long contentAreaX1;
    private long contentAreaX2;
    private TextCache textCache;
    private RenderableTextFactory textFactory;
    private CodePointBuffer buffer;
    private String ellipseOverride;
    private int[] bufferArray = new int[500];

    public RevalidateTextEllipseProcessStep(OutputProcessorMetaData metaData) {
        this.textCache = new TextCache(500);
        this.textFactory = new DefaultRenderableTextFactory(metaData);
    }

    public String getEllipseOverride() {
        return this.ellipseOverride;
    }

    public void setEllipseOverride(String ellipseOverride) {
        this.ellipseOverride = ellipseOverride;
    }

    public void compute(RenderBox box, long contentAreaX1, long contentAreaX2) {
        this.contentAreaX1 = contentAreaX1;
        this.contentAreaX2 = contentAreaX2;
        this.startProcessing(box);
    }

    public long getContentAreaX1() {
        return this.contentAreaX1;
    }

    public long getContentAreaX2() {
        return this.contentAreaX2;
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        if (box.getTextEllipseBox() != null) {
            return false;
        }
        StaticBoxLayoutProperties sblp = box.getStaticBoxLayoutProperties();
        BoxDefinition bdef = box.getBoxDefinition();
        long boxContentX2 = box.getX() + box.getWidth() - bdef.getPaddingRight() - sblp.getBorderRight();
        if (boxContentX2 > this.getContentAreaX2()) {
            RenderBox textEllipseBox = this.processTextEllipse(box, this.getContentAreaX2());
            box.setTextEllipseBox(textEllipseBox);
        }
        return true;
    }

    private RenderBox processTextEllipse(RenderBox box, long x2) {
        StyleSheet style = box.getStyleSheet();
        String reslit = (String)style.getStyleProperty(TextStyleKeys.RESERVED_LITERAL, this.ellipseOverride);
        if (reslit == null || "".equals(reslit)) {
            return null;
        }
        RenderBox textEllipse = (RenderBox)box.derive(false);
        ReportAttributeMap map = box.getAttributes();
        TextCache.Result result = this.textCache.get(style.getId(), style.getChangeTracker(), map.getChangeTracker(), reslit);
        if (result != null) {
            textEllipse.addGeneratedChilds(result.getText());
            textEllipse.addGeneratedChilds(result.getFinish());
            this.performTextEllipseLayout(textEllipse, x2);
            return textEllipse;
        }
        if (this.buffer != null) {
            this.buffer.setCursor(0);
        }
        this.buffer = Utf16LE.getInstance().decodeString(reslit, this.buffer);
        this.bufferArray = this.buffer.getBuffer(this.bufferArray);
        this.textFactory.startText();
        RenderNode[] renderNodes = this.textFactory.createText(this.bufferArray, 0, this.buffer.getLength(), style, box.getElementType(), box.getInstanceId(), map);
        RenderNode[] finishNodes = this.textFactory.finishText();
        textEllipse.addGeneratedChilds(renderNodes);
        textEllipse.addGeneratedChilds(finishNodes);
        this.textCache.store(style.getId(), style.getChangeTracker(), map.getChangeTracker(), reslit, style, map, renderNodes, finishNodes);
        this.performTextEllipseLayout(textEllipse, x2);
        return textEllipse;
    }

    private void performTextEllipseLayout(RenderBox box, long x2) {
        if (box == null) {
            return;
        }
        long x = x2;
        RenderNode node = box.getLastChild();
        while (node != null) {
            long nodeWidth = node.getMaximumBoxWidth();
            node.setX(x - nodeWidth);
            node.setWidth(node.getMaximumBoxWidth());
            node.setY(box.getY());
            node.setHeight(box.getHeight());
            node = node.getNext();
            x -= nodeWidth;
        }
        box.setX(x);
        box.setWidth(x2 - x);
        box.setContentAreaX1(x);
        box.setContentAreaX2(x2 - x);
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.startProcessing(box.getEffectiveLineboxContainer());
    }
}

