/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateSimpleStructureProcessStep;

public final class RollbackStep
extends IterateSimpleStructureProcessStep {
    private static final Log logger = LogFactory.getLog(RollbackStep.class);

    public void compute(LogicalPageBox pageBox) {
        if (!pageBox.isAppliedSeen()) {
            throw new IllegalStateException("How can I not see the root of the layout-tree?");
        }
        this.startProcessing(pageBox);
        pageBox.rollbackSaveInformation();
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    @Override
    protected boolean startBox(RenderBox parent) {
        boolean needDeepDive = false;
        RenderNode child = parent.getFirstChild();
        while (child != null) {
            int type = child.getNodeType();
            if (type == 129) {
                child = child.getNext();
                continue;
            }
            if ((type & 2) != 2) {
                throw new IllegalStateException("Assertation error: A rollback-process encountered a render-node it should not have encountered.");
            }
            RenderBox box = (RenderBox)child;
            if (!box.isAppliedSeen()) {
                RenderNode next = child.getNext();
                parent.remove(box);
                parent.resetCacheState(true);
                child = next;
                continue;
            }
            if (!box.isCommited()) {
                needDeepDive = true;
            }
            child = child.getNext();
        }
        return needDeepDive;
    }

    @Override
    protected void finishBox(RenderBox box) {
        if (!box.isCommited()) {
            box.rollback(true);
        }
    }
}

