/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;

public class ValidateModelStep
extends IterateStructuralProcessStep {
    private static final Log logger = LogFactory.getLog(ValidateModelStep.class);
    private boolean result;
    private TableValidationInfo validationInfo;

    public boolean isLayoutable(LogicalPageBox root) {
        this.validationInfo = null;
        this.result = true;
        this.processBoxChilds(root);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validation result: " + this.result));
        }
        return this.result;
    }

    @Override
    protected boolean startCanvasBox(CanvasRenderBox box) {
        if (!this.result) {
            return false;
        }
        if (box.isValidateModelCacheValid()) {
            this.result = box.isValidateModelResult();
            return false;
        }
        if (box.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Canvas: Box is open: " + box));
            }
            this.result = false;
            return false;
        }
        return box.getAppliedContentRefCount() != 0 || box.getTableRefCount() != 0;
    }

    @Override
    protected void finishCanvasBox(CanvasRenderBox box) {
        box.setValidateModelResult(this.result);
    }

    protected boolean validateBlockOrAutoBox(RenderBox box) {
        if (!this.result) {
            return false;
        }
        if (box.isValidateModelCacheValid()) {
            this.result = box.isValidateModelResult();
            return false;
        }
        if (box.isOpen()) {
            if (box.getNext() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Block: Box is open with next element pending : " + box));
                }
                this.result = false;
                return false;
            }
            if (box.getStaticBoxLayoutProperties().isPlaceholderBox()) {
                if (box.getFirstChild() == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Block: Open Box is placeholder : " + box));
                    }
                    this.result = false;
                    return false;
                }
            } else if (box.getNodeType() == 274) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Block: Paragraph is open: " + box));
                }
                this.result = false;
                return false;
            }
        } else if (box.getAppliedContentRefCount() == 0 && box.getTableRefCount() == 0) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox box) {
        return this.validateBlockOrAutoBox(box);
    }

    @Override
    protected void finishBlockBox(BlockRenderBox box) {
        box.setValidateModelResult(this.result);
    }

    @Override
    protected boolean startAutoBox(RenderBox box) {
        if ((box.getLayoutNodeType() & 0x12) == 18) {
            return this.validateBlockOrAutoBox(box);
        }
        if ((box.getLayoutNodeType() & 0x41002) == 266242 || (box.getLayoutNodeType() & 0x42002) == 270338) {
            return true;
        }
        return this.validateInlineRowOrTableCellBox(box);
    }

    @Override
    protected void finishAutoBox(RenderBox box) {
        box.setValidateModelResult(this.result);
    }

    private boolean validateInlineRowOrTableCellBox(RenderBox box) {
        if (!this.result) {
            return false;
        }
        if (box.isValidateModelCacheValid()) {
            this.result = box.isValidateModelResult();
            return false;
        }
        if (box.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Inline: Box is open : " + box));
            }
            this.result = false;
            return false;
        }
        return box.getAppliedContentRefCount() != 0 || box.getTableRefCount() != 0;
    }

    @Override
    protected boolean startTableCellBox(TableCellRenderBox box) {
        return this.validateInlineRowOrTableCellBox(box);
    }

    @Override
    protected void finishTableCellBox(TableCellRenderBox box) {
        box.setValidateModelResult(this.result);
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        return this.validateInlineRowOrTableCellBox(box);
    }

    @Override
    protected void finishInlineBox(InlineRenderBox box) {
        box.setValidateModelResult(this.result);
    }

    @Override
    protected boolean startRowBox(RenderBox box) {
        return this.validateInlineRowOrTableCellBox(box);
    }

    @Override
    protected void finishRowBox(RenderBox box) {
        box.setValidateModelResult(this.result);
    }

    @Override
    protected boolean startTableBox(TableRenderBox table) {
        this.validationInfo = new TableValidationInfo(this.validationInfo);
        if (!this.result) {
            return false;
        }
        if (table.isValidateModelCacheValid()) {
            this.result = table.isValidateModelResult();
            return true;
        }
        if (table.isOpen()) {
            if (table.isAutoLayout()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Table: Open Table and AutoLayout: " + table));
                }
                this.result = false;
                return false;
            }
            if (!table.getColumnModel().isIncrementalModeSupported()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Table: Open Table and incremental mode not supported: " + table));
                }
                this.result = false;
                return false;
            }
        }
        this.validationInfo.setNeedCheck(true);
        return true;
    }

    @Override
    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        if (box.getDisplayRole() == TableSectionRenderBox.Role.BODY) {
            this.validationInfo.setInMainBody(true);
        }
        this.validationInfo.setSeenBody(true);
        return true;
    }

    @Override
    protected void finishTableSectionBox(TableSectionRenderBox box) {
        this.validationInfo.setInMainBody(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishTableBox(TableRenderBox table) {
        try {
            if (table.isValidateModelCacheValid()) {
                return;
            }
            table.setValidateModelResult(this.result);
            if (!this.validationInfo.isNeedCheck()) {
                return;
            }
            if (this.validationInfo.isSeenBody() && this.validationInfo.isSeenRow()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Table-Box: " + this.validationInfo));
            }
            this.result = false;
        }
        finally {
            this.validationInfo = this.validationInfo.pop();
        }
    }

    @Override
    protected boolean startTableRowBox(TableRowRenderBox row) {
        if (row.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Table-Row: Box is open.");
            }
            this.result = false;
            return false;
        }
        this.validationInfo.addSeenRow();
        return true;
    }

    @Override
    protected boolean startOtherBox(RenderBox box) {
        return this.result;
    }

    protected boolean isResult() {
        return this.result;
    }

    protected void setResult(boolean result) {
        this.result = result;
    }

    private static class TableValidationInfo {
        private boolean needCheck;
        private boolean seenBody;
        private int seenRow;
        private boolean inMainBody;
        private TableValidationInfo parent;

        private TableValidationInfo(TableValidationInfo parent) {
            this.parent = parent;
        }

        public TableValidationInfo pop() {
            return this.parent;
        }

        public boolean isInMainBody() {
            return this.inMainBody;
        }

        public void setInMainBody(boolean inMainBody) {
            this.inMainBody = inMainBody;
        }

        public boolean isNeedCheck() {
            return this.needCheck;
        }

        public void setNeedCheck(boolean needCheck) {
            this.needCheck = needCheck;
        }

        public boolean isSeenBody() {
            return this.seenBody;
        }

        public void setSeenBody(boolean seenBody) {
            this.seenBody = seenBody;
        }

        public boolean isSeenRow() {
            return this.seenRow > 0;
        }

        public void addSeenRow() {
            ++this.seenRow;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TableValidationInfo");
            sb.append("{needCheck=").append(this.needCheck);
            sb.append(", seenBody=").append(this.seenBody);
            sb.append(", seenRow=").append(this.seenRow);
            sb.append(", inMainBody=").append(this.inMainBody);
            sb.append(", parent=").append(this.parent);
            sb.append('}');
            return sb.toString();
        }
    }
}

