/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.linebreak;

import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.linebreak.FullLinebreaker;
import org.pentaho.reporting.engine.classic.core.layout.process.linebreak.ParagraphLinebreaker;

public final class SimpleLinebreaker
implements ParagraphLinebreaker {
    private static final int MTH_START_BLOCK = 0;
    private static final int MTH_FINISH_BLOCK = 1;
    private static final int MTH_START_INLINE = 2;
    private static final int MTH_FINISH_INLINE = 3;
    private static final int MTH_ADD_NODE = 4;
    private int[] methods;
    private Object[] parameters;
    private int counter;
    private ParagraphRenderBox paragraphRenderBox;
    private Object suspendItem;
    private boolean breakRequested;

    public SimpleLinebreaker(ParagraphRenderBox paragraphRenderBox) {
        this.paragraphRenderBox = paragraphRenderBox;
        int poolSize = Math.max(20, paragraphRenderBox.getPoolSize());
        this.methods = new int[poolSize];
        this.parameters = new Object[poolSize];
    }

    public void dispose() {
        this.counter = 0;
        this.paragraphRenderBox = null;
        this.suspendItem = null;
        this.breakRequested = false;
    }

    public void recycle(ParagraphRenderBox box) {
        this.counter = 0;
        this.paragraphRenderBox = box;
        this.suspendItem = null;
        this.breakRequested = false;
        int poolSize = this.paragraphRenderBox.getPoolSize();
        if (poolSize > this.methods.length) {
            this.methods = new int[poolSize];
            this.parameters = new Object[poolSize];
        }
    }

    private void add(int method, Object parameter) {
        if (this.methods.length == this.counter) {
            int nextSize = Math.max(30, this.methods.length * 2);
            int[] newMethods = new int[nextSize];
            System.arraycopy(this.methods, 0, newMethods, 0, this.methods.length);
            Object[] newParameters = new Object[nextSize];
            System.arraycopy(this.parameters, 0, newParameters, 0, this.parameters.length);
            this.methods = newMethods;
            this.parameters = newParameters;
        }
        this.methods[this.counter] = method;
        this.parameters[this.counter] = parameter;
        ++this.counter;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public FullLinebreaker startComplexLayout() {
        FullLinebreaker fullBreaker = new FullLinebreaker(this.paragraphRenderBox);
        block7: for (int i = 0; i < this.counter; ++i) {
            int method = this.methods[i];
            Object parameter = this.parameters[i];
            switch (method) {
                case 0: {
                    fullBreaker.startBlockBox((RenderBox)parameter);
                    continue block7;
                }
                case 1: {
                    fullBreaker.finishBlockBox((RenderBox)parameter);
                    continue block7;
                }
                case 2: {
                    fullBreaker.startInlineBox((InlineRenderBox)parameter);
                    continue block7;
                }
                case 3: {
                    fullBreaker.finishInlineBox((InlineRenderBox)parameter);
                    continue block7;
                }
                case 4: {
                    fullBreaker.addNode((RenderNode)parameter);
                    continue block7;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this.paragraphRenderBox.setPoolSize(this.counter);
        return fullBreaker;
    }

    @Override
    public void startBlockBox(RenderBox child) {
        if (this.suspendItem != null) {
            this.suspendItem = child.getInstanceId();
        }
        this.add(0, child);
    }

    @Override
    public void finishBlockBox(RenderBox box) {
        if (this.suspendItem == box.getInstanceId()) {
            this.suspendItem = null;
        }
        this.add(1, box);
    }

    @Override
    public ParagraphLinebreaker startParagraphBox(ParagraphRenderBox box) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void finishParagraphBox(ParagraphRenderBox box) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSuspended() {
        return this.suspendItem != null;
    }

    @Override
    public void finish() {
        this.paragraphRenderBox.setPoolSize(this.counter);
        this.paragraphRenderBox.setLineBoxAge(this.paragraphRenderBox.getPool().getChangeTracker());
        this.counter = 0;
        Arrays.fill(this.parameters, null);
    }

    @Override
    public void startInlineBox(InlineRenderBox box) {
        this.add(2, box);
    }

    @Override
    public void finishInlineBox(InlineRenderBox box) {
        this.add(3, box);
    }

    @Override
    public boolean isBreakRequested() {
        return this.breakRequested;
    }

    @Override
    public void addNode(RenderNode node) {
        this.add(4, node);
    }

    @Override
    public void setBreakRequested(boolean breakRequested) {
        this.breakRequested = breakRequested;
    }
}

