/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationShiftState;

public class BlockLevelPaginationShiftState
implements PaginationShiftState {
    private PaginationShiftState parent;
    private long shift;
    private long initialShift;
    private boolean breakSuspended;

    public BlockLevelPaginationShiftState(PaginationShiftState parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.shift = this.initialShift = parent.getShiftForNextChild();
        this.breakSuspended = parent.isManualBreakSuspendedForChilds();
    }

    @Override
    public void suspendManualBreaks() {
        this.breakSuspended = true;
    }

    @Override
    public boolean isManualBreakSuspended() {
        return this.parent.isManualBreakSuspendedForChilds();
    }

    @Override
    public boolean isManualBreakSuspendedForChilds() {
        return this.breakSuspended;
    }

    @Override
    public void updateShiftFromChild(long absoluteValue) {
        this.setShift(absoluteValue);
    }

    @Override
    public void increaseShift(long value) {
        if (value < 0L) {
            throw new IllegalStateException();
        }
        this.shift += value;
    }

    @Override
    public long getShiftForNextChild() {
        return this.shift;
    }

    @Override
    public void setShift(long value) {
        if (value < this.shift) {
            throw new IllegalStateException("Cannot shift backwards");
        }
        this.shift = value;
    }

    @Override
    public PaginationShiftState pop() {
        this.parent.updateShiftFromChild(this.shift);
        return this.parent;
    }
}

