/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationShiftState;

public class RowLevelPaginationShiftState
implements PaginationShiftState {
    private PaginationShiftState parent;
    private long shift;
    private long shiftForChilds;

    public RowLevelPaginationShiftState(PaginationShiftState parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.shift = this.shiftForChilds = parent.getShiftForNextChild();
    }

    @Override
    public void suspendManualBreaks() {
    }

    @Override
    public boolean isManualBreakSuspended() {
        return this.parent.isManualBreakSuspendedForChilds();
    }

    @Override
    public boolean isManualBreakSuspendedForChilds() {
        return true;
    }

    @Override
    public void updateShiftFromChild(long absoluteValue) {
        this.shift = Math.max(this.shift, absoluteValue);
    }

    @Override
    public long getShiftForNextChild() {
        return this.shiftForChilds;
    }

    @Override
    public PaginationShiftState pop() {
        this.parent.updateShiftFromChild(this.shift);
        return this.parent;
    }

    @Override
    public void increaseShift(long value) {
        this.shiftForChilds = Math.max(this.shiftForChilds, this.shiftForChilds + value);
        this.shift = Math.max(this.shift, this.shiftForChilds);
    }

    @Override
    public void setShift(long value) {
        this.shiftForChilds = Math.max(this.shiftForChilds, value);
        this.shift = Math.max(this.shift, this.shiftForChilds);
    }
}

