/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.metadata.AbstractMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.SharedBeanInfo;

public class DefaultReportPreProcessorMetaData
extends AbstractMetaData
implements ReportPreProcessorMetaData {
    private Class expressionType;
    private HashMap<String, ReportPreProcessorPropertyMetaData> properties;
    private transient SharedBeanInfo beanInfo;
    private boolean autoProcessor;
    private boolean executeInDesignMode;

    public DefaultReportPreProcessorMetaData(String bundleLocation, boolean expert, boolean preferred, boolean hidden, boolean deprecated, Class expressionType, HashMap<String, ReportPreProcessorPropertyMetaData> attributes, SharedBeanInfo beanInfo, boolean autoProcessor, boolean executeInDesignMode, boolean experimental, int compatibilityLevel) {
        super(expressionType.getName(), bundleLocation, "", expert, preferred, hidden, deprecated, experimental, compatibilityLevel);
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (beanInfo == null) {
            throw new NullPointerException();
        }
        this.executeInDesignMode = executeInDesignMode;
        this.autoProcessor = autoProcessor;
        this.expressionType = expressionType;
        this.properties = (HashMap)attributes.clone();
        this.beanInfo = beanInfo;
    }

    @Override
    public boolean isExecuteInDesignMode() {
        return this.executeInDesignMode;
    }

    @Override
    protected String computePrefix(String keyPrefix, String name) {
        return "";
    }

    @Override
    public Class getPreProcessorType() {
        return this.expressionType;
    }

    @Override
    public ReportPreProcessorPropertyMetaData getPropertyDescription(String name) {
        return this.properties.get(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public ReportPreProcessorPropertyMetaData[] getPropertyDescriptions() {
        return this.properties.values().toArray(new ReportPreProcessorPropertyMetaData[this.properties.size()]);
    }

    @Override
    public BeanInfo getBeanDescriptor() throws IntrospectionException {
        return this.beanInfo.getBeanInfo();
    }

    @Override
    public boolean isAutoProcessor() {
        return this.autoProcessor;
    }

    @Override
    public ReportPreProcessor create() throws InstantiationException {
        try {
            return (ReportPreProcessor)this.expressionType.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Unable to instantiate " + this.expressionType + ": IllegalAccessException caught");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.beanInfo.getBeanClass());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Class c = (Class)in.readObject();
        this.beanInfo = new SharedBeanInfo(c);
    }
}

