/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ReportProcessTask;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultReportProcessTaskMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ReportProcessTaskMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AbstractMetaDataReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ExpressionReadHandler;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportProcessTaskReadHandler
extends AbstractMetaDataReadHandler {
    private String bundleName;
    private Class expressionClass;
    private String[] aliases;
    private String configurationPrefix;
    private ArrayList<StringReadHandler> aliasReadHandlers = new ArrayList();

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.bundleName = attrs.getValue(this.getUri(), "bundle-name");
        this.configurationPrefix = attrs.getValue(this.getUri(), "configuration-prefix");
        String valueTypeText = attrs.getValue(this.getUri(), "class");
        if (valueTypeText == null) {
            throw new ParseException("Attribute 'class' is undefined", this.getLocator());
        }
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(ExpressionReadHandler.class);
            this.expressionClass = Class.forName(valueTypeText, false, loader);
            if (!ReportProcessTask.class.isAssignableFrom(this.expressionClass)) {
                throw new ParseException("Attribute 'class' is not valid", this.getLocator());
            }
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParseException("Attribute 'class' is not valid", e, this.getLocator());
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("alias".equals(tagName)) {
            StringReadHandler rh = new StringReadHandler();
            this.aliasReadHandlers.add(rh);
            return rh;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        this.aliases = new String[this.aliasReadHandlers.size()];
        for (int i = 0; i < this.aliasReadHandlers.size(); ++i) {
            StringReadHandler readHandler = this.aliasReadHandlers.get(i);
            this.aliases[i] = readHandler.getResult();
        }
    }

    public ReportProcessTaskMetaData getObject() throws SAXException {
        return new DefaultReportProcessTaskMetaData(this.getName(), this.bundleName, this.isExpert(), this.isPreferred(), this.isHidden(), this.isDeprecated(), this.isExperimental(), this.getCompatibilityLevel(), this.expressionClass, this.configurationPrefix, this.aliases);
    }
}

