/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.DefaultReportEnvironment;
import org.pentaho.reporting.engine.classic.core.DefaultResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.cache.CachingDataFactory;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DesignTimeDataFactoryContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ButtonParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.DefaultParameterComponentFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterComponentFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterUpdateContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.parameters.CompoundDataRow;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterValidator;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationMessage;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationResult;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentMetaData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ParameterReportControllerPane
extends JPanel {
    private boolean isUpdating;
    public static final Color ERROR_COLOR = new Color(251, 191, 191, 255);
    private MasterReport report;
    private ReportParameterValues reportParameterValues;
    private ReportParameterValidator validator;
    private ArrayList<ChangeListener> changeListeners;
    private ArrayList<ChangeListener> internalChangeListeners;
    private JCheckBox autoUpdateCheckbox;
    private JButton updateButton;
    private ParameterCarrierPanel carrierPanel;
    private InternalParameterContext parameterContext;
    private HashMap<String, JLabel> errorLabels;
    private JLabel globalErrorMessage;
    private ParameterComponentFactory parameterEditorFactory;
    private boolean inUpdate;
    private ParameterUpdateContext updateContext;
    private Messages messages = new Messages(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages", ObjectUtilities.getClassLoader(ParameterReportControllerPane.class));
    private ArrayList<ParameterComponent> parameterComponents;

    public ParameterReportControllerPane() {
        this.changeListeners = new ArrayList();
        this.internalChangeListeners = new ArrayList();
        this.parameterComponents = new ArrayList();
        this.carrierPanel = new ParameterCarrierPanel();
        this.parameterContext = new InternalParameterContext();
        this.errorLabels = new HashMap();
        this.globalErrorMessage = new JLabel();
        this.autoUpdateCheckbox = new JCheckBox(this.messages.getString("ParameterReportControllerPane.AutoUpdate"));
        this.updateButton = new JButton(new UpdateAction());
        this.setLayout(new GridBagLayout());
        this.parameterEditorFactory = new DefaultParameterComponentFactory();
        this.updateContext = new InternalParameterUpdateHandler();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        this.add((Component)this.globalErrorMessage, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        JScrollPane scrollPane = new JScrollPane(this.carrierPanel);
        scrollPane.getViewport().setBackground(this.carrierPanel.getBackground());
        this.add((Component)scrollPane, gbc);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new GridLayout(1, 1));
        buttonPane.add(this.updateButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.gridx = 1;
        gbc.anchor = 13;
        this.add((Component)buttonPane, gbc);
        JPanel cbPane = new JPanel();
        cbPane.setLayout(new GridLayout(1, 1));
        cbPane.add(this.autoUpdateCheckbox);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.anchor = 17;
        this.add((Component)cbPane, gbc);
    }

    public MasterReport getReport() {
        return this.report;
    }

    public void setReport(MasterReport report) throws ReportProcessingException {
        this.report = report;
        if (!this.isUpdating) {
            this.reinit();
        }
    }

    public void hideControls() {
        this.autoUpdateCheckbox.setVisible(false);
        this.updateButton.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinit() throws ReportProcessingException {
        boolean autoSubmitDefault;
        boolean showAutoSubmitCheckbox;
        this.internalChangeListeners.clear();
        this.carrierPanel.removeAll();
        this.errorLabels.clear();
        this.globalErrorMessage.setText(null);
        this.parameterComponents.clear();
        if (this.report == null) {
            this.reportParameterValues = null;
            this.parameterContext.update((MasterReport)null);
            this.validator = null;
            this.autoUpdateCheckbox.setSelected(false);
            return;
        }
        Object autoUpdate = this.report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "auto-submit-parameter");
        if (autoUpdate == null) {
            showAutoSubmitCheckbox = true;
            autoSubmitDefault = !Boolean.FALSE.equals(this.report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "auto-submit-default"));
        } else {
            showAutoSubmitCheckbox = false;
            autoSubmitDefault = Boolean.TRUE.equals(autoUpdate);
        }
        this.autoUpdateCheckbox.setVisible(showAutoSubmitCheckbox);
        this.autoUpdateCheckbox.setSelected(autoSubmitDefault);
        ReportParameterDefinition parameterDefinition = this.report.getParameterDefinition();
        if (parameterDefinition == null) {
            this.reportParameterValues = null;
            this.parameterContext.update((MasterReport)null);
            this.validator = null;
            return;
        }
        try {
            ReportParameterDefinition parameters = this.report.getParameterDefinition();
            DefaultParameterContext parameterContext = new DefaultParameterContext(this.report);
            try {
                ReportParameterValidator reportParameterValidator = parameters.getValidator();
                ValidationResult validationResult = reportParameterValidator.validate(new ValidationResult(), parameters, parameterContext);
                this.reportParameterValues = validationResult.getParameterValues();
            }
            finally {
                parameterContext.close();
            }
        }
        catch (ReportDataFactoryException e) {
            e.printStackTrace();
            this.reportParameterValues = new ReportParameterValues(this.report.getParameterValues());
        }
        this.parameterComponents = new ArrayList();
        this.parameterContext.update(this.report);
        this.parameterContext.update(this.reportParameterValues);
        this.validator = parameterDefinition.getValidator();
        ParameterDefinitionEntry[] entries = parameterDefinition.getParameterDefinitions();
        for (int i = 0; i < entries.length; ++i) {
            ParameterDefinitionEntry entry = entries[i];
            if ("true".equals(entry.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "hidden", this.parameterContext))) continue;
            ParameterComponent parameterComponent = this.parameterEditorFactory.create(entry, this.parameterContext, this.updateContext);
            this.addToPanel(entry, 1 + i * 2, parameterComponent.getUIComponent());
            this.parameterComponents.add(parameterComponent);
        }
        this.validateParameter();
    }

    private void addToPanel(ParameterDefinitionEntry entry, int gridY, JComponent editor) {
        JLabel label = new JLabel(this.computeLabel(entry));
        JLabel errorLabel = new JLabel();
        this.errorLabels.put(entry.getName(), errorLabel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = gridY;
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.carrierPanel.add((Component)label, gbc);
        if (entry.isMandatory()) {
            gbc = new GridBagConstraints();
            gbc.gridy = gridY;
            gbc.gridx = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(5, 0, 0, 0);
            JLabel mandatoryLabel = new JLabel("*");
            mandatoryLabel.setToolTipText(this.messages.getString("ParameterReportControllerPane.MandatoryParameter"));
            this.carrierPanel.add((Component)mandatoryLabel, gbc);
        }
        gbc = new GridBagConstraints();
        gbc.gridy = gridY;
        gbc.gridx = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        if (editor instanceof ButtonParameterComponent) {
            gbc.fill = 2;
        }
        gbc.ipadx = 100;
        gbc.insets = new Insets(5, 0, 0, 0);
        this.carrierPanel.add((Component)editor, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = gridY + 1;
        gbc.gridx = 1;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 0, 0);
        this.carrierPanel.add((Component)errorLabel, gbc);
    }

    private String computeLabel(ParameterDefinitionEntry entry) {
        String swingLabel = entry.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/swing", "label", this.parameterContext);
        if (swingLabel != null) {
            return swingLabel;
        }
        String coreLabel = entry.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "label", this.parameterContext);
        if (coreLabel != null) {
            return coreLabel;
        }
        return entry.getName();
    }

    public ReportParameterValues getReportParameterValues() {
        return this.reportParameterValues;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            throw new NullPointerException();
        }
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            throw new NullPointerException();
        }
        this.changeListeners.remove(changeListener);
    }

    protected void addInternalChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            throw new NullPointerException();
        }
        this.internalChangeListeners.add(changeListener);
    }

    protected void removeInternalChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            throw new NullPointerException();
        }
        this.internalChangeListeners.remove(changeListener);
    }

    protected void performUpdate() {
        this.isUpdating = true;
        try {
            this.report.getParameterValues().clear();
            this.report.getParameterValues().putAll(this.reportParameterValues);
            this.setReport(this.report);
            ChangeEvent event = new ChangeEvent(this);
            for (int i = 0; i < this.changeListeners.size(); ++i) {
                ChangeListener listener = this.changeListeners.get(i);
                listener.stateChanged(event);
            }
        }
        catch (ReportProcessingException e) {
            ExceptionDialog.showExceptionDialog(this, this.messages.getString("ParameterReportControllerPane.Error"), this.messages.getString("ParameterReportControllerPane.ErrorWhileConfiguringParameterUI", (Object)e.getMessage()), e);
        }
        this.isUpdating = false;
    }

    protected void updateParameterValue(String name, Object value, boolean autoUpdate) {
        this.reportParameterValues.put(name, value);
        this.parameterContext.update(this.reportParameterValues);
        if (this.inUpdate || !autoUpdate) {
            return;
        }
        if (!this.validateParameter()) {
            return;
        }
        if (this.autoUpdateCheckbox.isSelected()) {
            this.performUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateParameter() {
        this.globalErrorMessage.setText(null);
        for (Map.Entry<String, JLabel> stringJLabelEntry : this.errorLabels.entrySet()) {
            JLabel o = stringJLabelEntry.getValue();
            o.setText(null);
        }
        boolean retval = true;
        if (this.validator != null) {
            try {
                ValidationResult validationResult = this.validator.validate(new ValidationResult(), this.report.getParameterDefinition(), this.parameterContext);
                ValidationMessage[] messages = validationResult.getErrors();
                this.globalErrorMessage.setText(this.formatMessages(messages));
                String[] propertyNames = validationResult.getProperties();
                for (int i = 0; i < propertyNames.length; ++i) {
                    String propertyName = propertyNames[i];
                    JLabel o = this.errorLabels.get(propertyName);
                    ValidationMessage[] validationMessages = validationResult.getErrors(propertyName);
                    String message = this.formatMessages(validationMessages);
                    if (o == null) {
                        String s = this.globalErrorMessage.getText();
                        if (StringUtils.isEmpty((String)s)) {
                            this.globalErrorMessage.setText(propertyName + ": " + message);
                            continue;
                        }
                        this.globalErrorMessage.setText(s + "\n" + propertyName + ": " + message);
                        continue;
                    }
                    o.setText(message);
                }
                ReportParameterValues parameterValues = validationResult.getParameterValues();
                for (String columnName : parameterValues.getColumnNames()) {
                    Object value = parameterValues.get(columnName);
                    if (value == null) continue;
                    this.reportParameterValues.put(columnName, value);
                }
                this.parameterContext.update(this.reportParameterValues);
                for (ParameterComponent component : this.parameterComponents) {
                    component.initialize();
                }
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog(this, this.messages.getString("ParameterReportControllerPane.Error"), this.messages.getString("ParameterReportControllerPane.ErrorWhileConfiguringParameterUI", (Object)e.getMessage()), e);
                retval = false;
            }
        }
        try {
            this.inUpdate = true;
            ChangeEvent event = new ChangeEvent(this);
            for (int i = 0; i < this.internalChangeListeners.size(); ++i) {
                ChangeListener changeListener = this.internalChangeListeners.get(i);
                changeListener.stateChanged(event);
            }
        }
        finally {
            this.inUpdate = false;
        }
        return retval;
    }

    private String formatMessages(ValidationMessage[] validationMessages) {
        StringBuilder message = new StringBuilder(1000);
        for (int j = 0; j < validationMessages.length; ++j) {
            if (j != 0) {
                message.append('\n');
            }
            ValidationMessage validationMessage = validationMessages[j];
            message.append(validationMessage.getMessage());
        }
        return message.toString();
    }

    public void setErrorMessage(String error) {
        this.globalErrorMessage.setText(error);
    }

    private static class ParameterCarrierPanel
    extends JPanel
    implements Scrollable {
        private ParameterCarrierPanel() {
            this.setLayout(new GridBagLayout());
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class InternalParameterUpdateHandler
    implements ParameterUpdateContext {
        private InternalParameterUpdateHandler() {
        }

        @Override
        public void setParameterValue(String name, Object value) {
            this.setParameterValue(name, value, true);
        }

        @Override
        public void setParameterValue(String name, Object value, boolean autoUpdate) {
            ParameterReportControllerPane.this.updateParameterValue(name, value, autoUpdate);
        }

        @Override
        public Object getParameterValue(String name) {
            return ParameterReportControllerPane.this.reportParameterValues.get(name);
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            ParameterReportControllerPane.this.addInternalChangeListener(changeListener);
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            ParameterReportControllerPane.this.removeInternalChangeListener(changeListener);
        }
    }

    private class UpdateAction
    extends AbstractAction {
        private UpdateAction() {
            this.putValue("Name", ParameterReportControllerPane.this.messages.getString("ParameterReportControllerPane.Update"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ParameterReportControllerPane.this.validateParameter();
            ParameterReportControllerPane.this.performUpdate();
        }
    }

    private static class InternalParameterContext
    implements ParameterContext {
        private DataRow parameterData;
        private DataFactory dataFactory;
        private ResourceBundleFactory resourceBundleFactory;
        private Configuration configuration;
        private ResourceKey contentBase;
        private ResourceManager resourceManager = new ResourceManager();
        private boolean closed;
        private DocumentMetaData documentMetaData;
        private ReportEnvironment reportEnvironment;

        private InternalParameterContext() {
            this.dataFactory = new TableDataFactory();
            this.resourceBundleFactory = new DefaultResourceBundleFactory();
            this.configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
            this.documentMetaData = new MemoryDocumentMetaData();
            this.reportEnvironment = new DefaultReportEnvironment(this.configuration);
            ReportEnvironmentDataRow envDataRow = new ReportEnvironmentDataRow(this.reportEnvironment);
            this.parameterData = new CompoundDataRow(envDataRow, new ParameterDataRow());
        }

        @Override
        public DocumentMetaData getDocumentMetaData() {
            return this.documentMetaData;
        }

        @Override
        public ReportEnvironment getReportEnvironment() {
            return this.reportEnvironment;
        }

        @Override
        public ResourceKey getContentBase() {
            return this.contentBase;
        }

        @Override
        public DataRow getParameterData() {
            return this.parameterData;
        }

        @Override
        public DataFactory getDataFactory() {
            return this.dataFactory;
        }

        @Override
        public ResourceBundleFactory getResourceBundleFactory() {
            return this.resourceBundleFactory;
        }

        @Override
        public void close() throws ReportDataFactoryException {
            this.closed = true;
            this.dataFactory.close();
        }

        @Override
        public Configuration getConfiguration() {
            return this.configuration;
        }

        @Override
        public ResourceManager getResourceManager() {
            return this.resourceManager;
        }

        public void update(MasterReport report) throws ReportProcessingException {
            if (!this.closed) {
                this.close();
            }
            if (report == null) {
                this.resourceManager = new ResourceManager();
                this.dataFactory = new TableDataFactory();
                this.resourceBundleFactory = new DefaultResourceBundleFactory();
                this.configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
                this.contentBase = null;
                this.documentMetaData = new MemoryDocumentMetaData();
                this.reportEnvironment = new DefaultReportEnvironment(this.configuration);
                ReportEnvironmentDataRow envDataRow = new ReportEnvironmentDataRow(this.reportEnvironment);
                this.parameterData = new CompoundDataRow(envDataRow, new ParameterDataRow());
            } else {
                this.resourceManager = report.getResourceManager();
                this.contentBase = report.getContentBase();
                Object dataCacheEnabledRaw = report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "data-cache");
                boolean dataCacheEnabled = !Boolean.FALSE.equals(dataCacheEnabledRaw);
                this.dataFactory = new CachingDataFactory(report.getDataFactory().derive(), dataCacheEnabled);
                this.resourceBundleFactory = MasterReport.computeAndInitResourceBundleFactory(report.getResourceBundleFactory(), report.getReportEnvironment());
                this.reportEnvironment = report.getReportEnvironment();
                this.configuration = report.getConfiguration();
                ReportEnvironmentDataRow envDataRow = new ReportEnvironmentDataRow(this.reportEnvironment);
                this.parameterData = new CompoundDataRow(envDataRow, new ParameterDataRow(report.getParameterValues()));
                this.dataFactory.initialize(new DesignTimeDataFactoryContext(report));
                this.documentMetaData = report.getBundle() != null ? report.getBundle().getMetaData() : new MemoryDocumentMetaData();
            }
        }

        public void update(ReportParameterValues properties) {
            ReportEnvironmentDataRow envDataRow = new ReportEnvironmentDataRow(this.reportEnvironment);
            this.parameterData = new CompoundDataRow(envDataRow, new ParameterDataRow(properties));
        }
    }
}

