/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.internal;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import javax.swing.ToolTipManager;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMapEntry;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.event.ReportActionEvent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.event.ReportActionListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.event.ReportMouseEvent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.event.ReportMouseListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.PageBackgroundDrawable;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.DrawablePanel;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PageDrawable;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class PreviewDrawablePanel
extends DrawablePanel {
    private ArrayList reportMouseListener;
    private transient ReportMouseListener[] cachedReportMouseListeners;
    private ArrayList reportActionListener;
    private transient ReportActionListener[] cachedReportActionListeners;

    public PreviewDrawablePanel() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        ReportMouseHandler reportMouseHandler = new ReportMouseHandler();
        this.addMouseListener(reportMouseHandler);
        this.addMouseMotionListener(reportMouseHandler);
        this.addMouseListener(new ReportActionHandler());
    }

    public void addReportMouseListener(ReportMouseListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.reportMouseListener == null) {
            this.reportMouseListener = new ArrayList();
        }
        this.reportMouseListener.add(listener);
        this.cachedReportMouseListeners = null;
    }

    public void removeReportMouseListener(ReportMouseListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.reportMouseListener == null) {
            return;
        }
        this.reportMouseListener.remove(listener);
        this.cachedReportMouseListeners = null;
    }

    public void addReportActionListener(ReportActionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.reportActionListener == null) {
            this.reportActionListener = new ArrayList();
        }
        this.reportActionListener.add(listener);
        this.cachedReportActionListeners = null;
    }

    public void removeReportActionListener(ReportActionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.reportActionListener == null) {
            return;
        }
        this.reportActionListener.remove(listener);
        this.cachedReportActionListeners = null;
    }

    protected void fireReportMouseClicked(MouseEvent event) {
        if (this.reportMouseListener == null) {
            return;
        }
        if (this.cachedReportMouseListeners == null) {
            this.cachedReportMouseListeners = this.reportMouseListener.toArray(new ReportMouseListener[this.reportMouseListener.size()]);
        }
        if (this.cachedReportMouseListeners.length == 0) {
            return;
        }
        RenderNode[] nodes = this.getNodesForScreenPoint(event.getX(), event.getY(), null, null);
        if (nodes == null) {
            return;
        }
        ReportMouseListener[] currentListeners = this.cachedReportMouseListeners;
        for (int n = 0; n < nodes.length; ++n) {
            RenderNode node = nodes[n];
            ReportMouseEvent reportEvent = new ReportMouseEvent(node, event);
            for (int i = 0; i < currentListeners.length; ++i) {
                ReportMouseListener listener = currentListeners[i];
                listener.reportMouseClicked(reportEvent);
            }
        }
    }

    protected void fireReportMouseMoved(MouseEvent event) {
        if (this.reportMouseListener == null) {
            return;
        }
        if (this.cachedReportMouseListeners == null) {
            this.cachedReportMouseListeners = this.reportMouseListener.toArray(new ReportMouseListener[this.reportMouseListener.size()]);
        }
        if (this.cachedReportMouseListeners.length == 0) {
            return;
        }
        RenderNode[] nodes = this.getNodesForScreenPoint(event.getX(), event.getY(), null, null);
        if (nodes == null) {
            return;
        }
        ReportMouseListener[] currentListeners = this.cachedReportMouseListeners;
        for (int n = 0; n < nodes.length; ++n) {
            RenderNode node = nodes[n];
            ReportMouseEvent reportEvent = new ReportMouseEvent(node, event);
            for (int i = 0; i < currentListeners.length; ++i) {
                ReportMouseListener listener = currentListeners[i];
                listener.reportMouseMoved(reportEvent);
            }
        }
    }

    protected void fireReportMouseDragged(MouseEvent event) {
        if (this.reportMouseListener == null) {
            return;
        }
        if (this.cachedReportMouseListeners == null) {
            this.cachedReportMouseListeners = this.reportMouseListener.toArray(new ReportMouseListener[this.reportMouseListener.size()]);
        }
        if (this.cachedReportMouseListeners.length == 0) {
            return;
        }
        RenderNode[] nodes = this.getNodesForScreenPoint(event.getX(), event.getY(), null, null);
        if (nodes == null) {
            return;
        }
        ReportMouseListener[] currentListeners = this.cachedReportMouseListeners;
        for (int n = 0; n < nodes.length; ++n) {
            RenderNode node = nodes[n];
            ReportMouseEvent reportEvent = new ReportMouseEvent(node, event);
            for (int i = 0; i < currentListeners.length; ++i) {
                ReportMouseListener listener = currentListeners[i];
                listener.reportMouseDragged(reportEvent);
            }
        }
    }

    protected void fireReportAction(MouseEvent event) {
        if (this.reportActionListener == null) {
            return;
        }
        if (this.cachedReportActionListeners == null) {
            this.cachedReportActionListeners = this.reportActionListener.toArray(new ReportActionListener[this.reportActionListener.size()]);
        }
        if (this.cachedReportMouseListeners.length == 0) {
            return;
        }
        RenderNode[] nodes = this.getNodesForScreenPoint(event.getX(), event.getY(), "http://reporting.pentaho.org/namespaces/engine/attributes/swing", "action");
        if (nodes == null) {
            return;
        }
        ReportActionListener[] currentListeners = this.cachedReportActionListeners;
        for (int n = 0; n < nodes.length; ++n) {
            RenderNode node = nodes[n];
            ReportActionEvent reportEvent = new ReportActionEvent(this, node);
            for (int i = 0; i < currentListeners.length; ++i) {
                ReportActionListener listener = currentListeners[i];
                listener.reportActionPerformed(reportEvent);
            }
        }
    }

    protected void fireReportMousePressed(MouseEvent event) {
        if (this.reportMouseListener == null) {
            return;
        }
        if (this.cachedReportMouseListeners == null) {
            this.cachedReportMouseListeners = this.reportMouseListener.toArray(new ReportMouseListener[this.reportMouseListener.size()]);
        }
        if (this.cachedReportMouseListeners.length == 0) {
            return;
        }
        RenderNode[] nodes = this.getNodesForScreenPoint(event.getX(), event.getY(), null, null);
        if (nodes == null) {
            return;
        }
        ReportMouseListener[] currentListeners = this.cachedReportMouseListeners;
        for (int n = 0; n < nodes.length; ++n) {
            RenderNode node = nodes[n];
            ReportMouseEvent reportEvent = new ReportMouseEvent(node, event);
            for (int i = 0; i < currentListeners.length; ++i) {
                ReportMouseListener listener = currentListeners[i];
                listener.reportMousePressed(reportEvent);
            }
        }
    }

    protected void fireReportMouseReleased(MouseEvent event) {
        if (this.reportMouseListener == null) {
            return;
        }
        RenderNode[] nodes = this.getNodesForScreenPoint(event.getX(), event.getY(), null, null);
        if (nodes == null) {
            return;
        }
        if (this.cachedReportMouseListeners == null) {
            this.cachedReportMouseListeners = this.reportMouseListener.toArray(new ReportMouseListener[this.reportMouseListener.size()]);
        }
        ReportMouseListener[] currentListeners = this.cachedReportMouseListeners;
        for (int n = 0; n < nodes.length; ++n) {
            RenderNode node = nodes[n];
            ReportMouseEvent reportEvent = new ReportMouseEvent(node, event);
            for (int i = 0; i < currentListeners.length; ++i) {
                ReportMouseListener listener = currentListeners[i];
                listener.reportMouseReleased(reportEvent);
            }
        }
    }

    private RenderNode[] getNodesForScreenPoint(int x, int y, String namespace, String attribute) {
        PageBackgroundDrawable backgroundDrawable = this.getBackgroundDrawable();
        if (backgroundDrawable == null) {
            return null;
        }
        PageDrawable pageDrawable = this.getPageDrawable();
        if (pageDrawable == null) {
            return null;
        }
        double zoom = backgroundDrawable.getZoom();
        RenderNode[] nodes = pageDrawable.getNodesAt((double)x / zoom, (double)y / zoom, namespace, attribute);
        if (nodes.length == 0) {
            return null;
        }
        return nodes;
    }

    public PageBackgroundDrawable getBackgroundDrawable() {
        DrawableWrapper wrapper = this.getDrawable();
        if (wrapper == null) {
            return null;
        }
        Object backend = wrapper.getBackend();
        if (!(backend instanceof PageBackgroundDrawable)) {
            return null;
        }
        return (PageBackgroundDrawable)backend;
    }

    public PageDrawable getPageDrawable() {
        PageBackgroundDrawable backgroundDrawable = this.getBackgroundDrawable();
        if (backgroundDrawable == null) {
            return null;
        }
        PageDrawable physicalPageDrawable = backgroundDrawable.getBackend();
        if (physicalPageDrawable == null) {
            return null;
        }
        return physicalPageDrawable;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        float y1;
        PageBackgroundDrawable backgroundDrawable = this.getBackgroundDrawable();
        if (backgroundDrawable == null) {
            return null;
        }
        PageDrawable physicalPageDrawable = this.getPageDrawable();
        if (physicalPageDrawable == null) {
            return null;
        }
        float zoom = (float)backgroundDrawable.getZoom();
        float x1 = (float)event.getX() / zoom;
        RenderNode[] nodes = physicalPageDrawable.getNodesAt(x1, y1 = (float)event.getY() / zoom, null, null);
        if (nodes.length == 0) {
            return null;
        }
        for (int i = nodes.length - 1; i >= 0; --i) {
            ImageMap imageMap;
            RenderNode node = nodes[i];
            ReportAttributeMap attributes = node.getAttributes();
            Object swingTooltip = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/swing", "tooltip");
            if (swingTooltip != null) {
                return String.valueOf(swingTooltip);
            }
            Object htmlTooltip = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "title");
            if (htmlTooltip != null) {
                return String.valueOf(htmlTooltip);
            }
            Object styleTooltip = node.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_TITLE);
            if (styleTooltip != null) {
                return String.valueOf(styleTooltip);
            }
            Object hrefTarget = node.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_TARGET);
            if (hrefTarget != null) {
                return String.valueOf(hrefTarget);
            }
            if (!(node instanceof RenderableReplacedContentBox) || (imageMap = RenderUtility.extractImageMap((RenderableReplacedContentBox)node)) == null) continue;
            PageFormat pf = physicalPageDrawable.getPageFormat();
            float imageMapX = (float)((double)x1 - pf.getImageableX() - StrictGeomUtility.toExternalValue(node.getX()));
            float imageMapY = (float)((double)y1 - pf.getImageableY() - StrictGeomUtility.toExternalValue(node.getY()));
            ImageMapEntry[] imageMapEntries = imageMap.getEntriesForPoint(imageMapX, imageMapY);
            for (int j = 0; j < imageMapEntries.length; ++j) {
                ImageMapEntry imageMapEntry = imageMapEntries[j];
                String imageMapTooltip = imageMapEntry.getAttribute("http://www.w3.org/1999/xhtml", "title");
                if (imageMapTooltip != null) {
                    return String.valueOf(imageMapTooltip);
                }
                String imageMapTarget = imageMapEntry.getAttribute("http://www.w3.org/1999/xhtml", "href");
                if (imageMapTarget == null) continue;
                return String.valueOf(imageMapTarget);
            }
        }
        return null;
    }

    private class ReportActionHandler
    implements MouseListener {
        private ReportActionHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PreviewDrawablePanel.this.fireReportAction(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class ReportMouseHandler
    implements MouseListener,
    MouseMotionListener {
        private ReportMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PreviewDrawablePanel.this.fireReportMouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PreviewDrawablePanel.this.fireReportMousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            PreviewDrawablePanel.this.fireReportMouseReleased(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            PreviewDrawablePanel.this.fireReportMouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            PreviewDrawablePanel.this.fireReportMouseMoved(e);
        }
    }
}

