/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.AbstractSequence;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.PerformanceTestSequenceDescription;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDescription;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;

public class PerformanceTestSequence
extends AbstractSequence {
    @Override
    public SequenceDescription getSequenceDescription() {
        return new PerformanceTestSequenceDescription();
    }

    @Override
    public TableModel produce(DataRow parameters, DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        int limit = this.getTypedParameter("limit", Integer.class, 100);
        long seed = this.getTypedParameter("seed", Long.class, System.currentTimeMillis());
        TypedTableModel model = new TypedTableModel();
        model.addColumn("rowcount", Integer.class);
        model.addColumn("integer", Integer.class);
        model.addColumn("double", Double.class);
        model.addColumn("text", String.class);
        model.addColumn("text2", String.class);
        model.addColumn("date", Date.class);
        Random random = new Random();
        random.setSeed(seed);
        GregorianCalendar baseDate = new GregorianCalendar(2000, 1, 1);
        ((Calendar)baseDate).setTimeZone(TimeZone.getTimeZone("UTC"));
        long millis = baseDate.getTimeInMillis();
        for (int i = 0; i < limit; ++i) {
            model.addRow(i, (int)(random.nextDouble() * 2.147483647E9) - 0x3FFFFFFF, random.nextDouble() * 2.147483647E9, "Some Text with breaks " + i, "SomeTextWithoutBreaks" + i, new Date(millis + (long)(200.0 * Math.random() * 2.147483647E9)));
        }
        return model;
    }
}

