/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class JndiConnectionProvider
implements ConnectionProvider {
    private static InitialContext initialContext;
    private static final String JNDI_PREFIX_CONFIGURATION = "org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.jndi-prefix.";
    private static final Log logger;
    private String connectionPath;
    private String username;
    private String password;

    protected static synchronized InitialContext getInitialContext() throws NamingException {
        if (initialContext == null) {
            initialContext = new InitialContext();
        }
        return initialContext;
    }

    public JndiConnectionProvider() {
    }

    public JndiConnectionProvider(String connectionPath, String username, String password) {
        this.connectionPath = connectionPath;
        this.username = username;
        this.password = password;
    }

    public String getConnectionPath() {
        return this.connectionPath;
    }

    public void setConnectionPath(String connectionPath) {
        this.connectionPath = connectionPath;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Connection createConnection(String user, String password) throws SQLException {
        if (this.connectionPath == null) {
            throw new SQLException("JNDI DataSource is invalid; no connection path is defined.");
        }
        try {
            InitialContext ctx = JndiConnectionProvider.getInitialContext();
            DataSource ds = this.findDataSource(ctx, this.connectionPath);
            String realUser = !StringUtils.isEmpty((String)this.username) ? this.username : user;
            String realPassword = !StringUtils.isEmpty((String)password) ? this.password : password;
            if (StringUtils.isEmpty((String)realUser)) {
                Connection connection = ds.getConnection();
                if (connection == null) {
                    throw new SQLException("JNDI DataSource is invalid; it returned null without throwing a meaningful error.");
                }
                return connection;
            }
            Connection connection = ds.getConnection(realUser, realPassword);
            if (connection == null) {
                throw new SQLException("JNDI DataSource is invalid; it returned null without throwing a meaningful error.");
            }
            return connection;
        }
        catch (NamingException ne) {
            logger.warn((Object)"Failed to access the JDNI-System", (Throwable)ne);
            throw new SQLException("Failed to access the JNDI system");
        }
    }

    private DataSource findDataSource(Context initialContext, String connectionPath) throws SQLException {
        try {
            Object o = initialContext.lookup(connectionPath);
            if (o instanceof DataSource) {
                return (DataSource)o;
            }
        }
        catch (NamingException e) {
            logger.trace((Object)"Failed to lookup JNDI name", (Throwable)e);
        }
        Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
        Iterator keys = config.findPropertyKeys(JNDI_PREFIX_CONFIGURATION);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String prefix = config.getConfigProperty(key);
            try {
                Object o = initialContext.lookup(prefix + connectionPath);
                if (!(o instanceof DataSource)) continue;
                return (DataSource)o;
            }
            catch (NamingException e) {
                logger.trace((Object)"Failed to lookup JNDI name", (Throwable)e);
            }
        }
        throw new SQLException("Failed to access the JNDI system: Cannot find the requested datasource '" + connectionPath + "' anywhere in the JNDI system.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JndiConnectionProvider that = (JndiConnectionProvider)o;
        if (this.connectionPath != null ? !this.connectionPath.equals(that.connectionPath) : that.connectionPath != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    @Override
    public Object getConnectionHash() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getClass().getName());
        list.add(this.connectionPath);
        list.add(this.username);
        return list;
    }

    public int hashCode() {
        int result = this.connectionPath != null ? this.connectionPath.hashCode() : 0;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }

    static {
        logger = LogFactory.getLog(JndiConnectionProvider.class);
    }
}

