/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.util.PropertyLookupParser;

public class SQLParameterLookupParser
extends PropertyLookupParser {
    private ArrayList<String> fields;
    private boolean expandArray;

    public SQLParameterLookupParser(boolean expandArray) {
        this.expandArray = expandArray;
        this.fields = new ArrayList();
        this.setMarkerChar('$');
        this.setOpeningBraceChar('{');
        this.setClosingBraceChar('}');
    }

    @Override
    protected String lookupVariable(String name) {
        this.fields.add(name);
        return "?";
    }

    public String[] getFields() {
        return this.fields.toArray(new String[this.fields.size()]);
    }

    @Override
    protected void handleVariableLookup(StringBuilder result, DataRow parameters, String columnName) {
        if (parameters == null) {
            throw new NullPointerException("Parameters must never be null");
        }
        String s = this.lookupVariable(columnName);
        Object propertyValue = parameters.get(columnName);
        if (this.expandArray && propertyValue instanceof Object[]) {
            Object[] parameterValues = (Object[])propertyValue;
            for (int j = 0; j < parameterValues.length - 1; ++j) {
                result.append(s);
                result.append(',');
            }
            result.append(s);
        } else {
            result.append(s);
        }
    }

    public boolean isExpandArray() {
        return this.expandArray;
    }
}

