/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.survey;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.ContentType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.modules.misc.survey.SurveyScale;
import org.pentaho.reporting.engine.classic.core.modules.misc.survey.SurveyScaleShapeType;

public class SurveyScaleType
extends ContentType {
    public SurveyScaleType() {
        super("survey-scale");
    }

    @Override
    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        Object value = ElementTypeUtils.queryFieldOrValue(runtime, element);
        Number[] numbers = ElementTypeUtils.getData(value);
        if (numbers == null) {
            numbers = new Number[]{1, 2, 4};
        }
        int lowest = ElementTypeUtils.getIntAttribute(element, "http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "lowest", 1);
        int highest = ElementTypeUtils.getIntAttribute(element, "http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "highest", 5);
        Number rangeLowerBound = ElementTypeUtils.getNumberAttribute(element, "http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "range-lower-bound", null);
        Number rangeUpperBound = ElementTypeUtils.getNumberAttribute(element, "http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "range-upper-bound", null);
        SurveyScale drawable = new SurveyScale(lowest, highest, numbers);
        drawable.setRangeLowerBound(rangeLowerBound);
        drawable.setRangeUpperBound(rangeUpperBound);
        return drawable;
    }

    @Override
    public void configureDesignTimeDefaults(ReportElement element, Locale locale) {
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "lowest", 1);
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "highest", 5);
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        Object outlineStroke;
        Object defaultShape;
        Number upperMargin;
        Number lowerMargin;
        Object value = ElementTypeUtils.queryFieldOrValue(runtime, element);
        Number[] numbers = ElementTypeUtils.getData(value);
        if (numbers == null) {
            Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
            return this.filter(runtime, element, nullValue);
        }
        int lowest = ElementTypeUtils.getIntAttribute(element, "http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "lowest", 1);
        int highest = ElementTypeUtils.getIntAttribute(element, "http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "highest", 5);
        Number rangeLowerBound = ElementTypeUtils.getNumberAttribute(element, "http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "range-lower-bound", null);
        Number rangeUpperBound = ElementTypeUtils.getNumberAttribute(element, "http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "range-upper-bound", null);
        SurveyScale drawable = new SurveyScale(lowest, highest, numbers);
        drawable.setRangeLowerBound(rangeLowerBound);
        drawable.setRangeUpperBound(rangeUpperBound);
        drawable.setAutoConfigure(true);
        Object tickMarkPaint = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "tick-mark-paint");
        if (tickMarkPaint instanceof Color) {
            drawable.setRangePaint((Color)tickMarkPaint);
        }
        if ((lowerMargin = ElementTypeUtils.getNumberAttribute(element, "http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "lower-margin", null)) != null) {
            drawable.setLowerMargin(lowerMargin.doubleValue());
        }
        if ((upperMargin = ElementTypeUtils.getNumberAttribute(element, "http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "upper-margin", null)) != null) {
            drawable.setUpperMargin(upperMargin.doubleValue());
        }
        if ((defaultShape = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "default-shape")) instanceof SurveyScaleShapeType) {
            drawable.setDefaultShape((SurveyScaleShapeType)((Object)defaultShape));
        }
        if ((outlineStroke = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/survey-scale/1.0", "outline-stroke")) instanceof BasicStroke) {
            drawable.setOutlineStroke((BasicStroke)outlineStroke);
        }
        return drawable;
    }
}

