/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel;

import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class JoiningTableModel
extends AbstractTableModel {
    private String[] columnNames;
    private Class[] columnTypes;
    private ArrayList models = new ArrayList();
    private TableChangeHandler changeHandler = new TableChangeHandler();
    private int rowCount;
    public static final String TABLE_PREFIX_COLUMN = "TablePrefix";

    public synchronized void addTableModel(String prefix, TableModel model) {
        this.models.add(new TablePosition(model, prefix));
        model.addTableModelListener(this.changeHandler);
        this.updateStructure();
    }

    public synchronized void removeTableModel(TableModel model) {
        for (int i = 0; i < this.models.size(); ++i) {
            TablePosition position = (TablePosition)this.models.get(i);
            if (position.getTableModel() != model) continue;
            this.models.remove(model);
            model.removeTableModelListener(this.changeHandler);
            this.updateStructure();
            return;
        }
    }

    public synchronized int getTableModelCount() {
        return this.models.size();
    }

    public synchronized TableModel getTableModel(int pos) {
        TablePosition position = (TablePosition)this.models.get(pos);
        return position.getTableModel();
    }

    protected synchronized void updateStructure() {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList columnTypes = new ArrayList();
        columnNames.add(TABLE_PREFIX_COLUMN);
        columnTypes.add(String.class);
        int columnOffset = 1;
        int rowOffset = 0;
        for (int i = 0; i < this.models.size(); ++i) {
            TablePosition pos = (TablePosition)this.models.get(i);
            pos.updateOffsets(rowOffset, columnOffset);
            TableModel tableModel = pos.getTableModel();
            rowOffset += tableModel.getRowCount();
            columnOffset += tableModel.getColumnCount();
            for (int c = 0; c < tableModel.getColumnCount(); ++c) {
                columnNames.add(pos.getPrefix() + '.' + tableModel.getColumnName(c));
                columnTypes.add(tableModel.getColumnClass(c));
            }
        }
        this.columnNames = columnNames.toArray(new String[columnNames.size()]);
        this.columnTypes = columnTypes.toArray(new Class[columnTypes.size()]);
        this.rowCount = rowOffset;
        this.fireTableStructureChanged();
    }

    protected synchronized void updateRowCount() {
        int rowOffset = 0;
        int columnOffset = 1;
        for (int i = 0; i < this.models.size(); ++i) {
            TablePosition model = (TablePosition)this.models.get(i);
            model.updateOffsets(rowOffset, columnOffset);
            rowOffset += model.getTableModel().getRowCount();
            columnOffset += model.getTableModel().getColumnCount();
        }
        this.fireTableStructureChanged();
    }

    protected void updateData() {
        this.fireTableDataChanged();
    }

    public synchronized Class getColumnClass(int columnIndex) {
        return this.columnTypes[columnIndex];
    }

    @Override
    public synchronized String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public final boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public synchronized int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public synchronized int getRowCount() {
        return this.rowCount;
    }

    @Override
    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        TablePosition pos = this.getTableModelForRow(rowIndex);
        if (pos == null) {
            return null;
        }
        if (columnIndex == 0) {
            return pos.getPrefix();
        }
        int columnOffset = pos.getColumnOffset();
        if (columnIndex < columnOffset) {
            return null;
        }
        TableModel tableModel = pos.getTableModel();
        if (columnIndex >= columnOffset + tableModel.getColumnCount()) {
            return null;
        }
        return tableModel.getValueAt(rowIndex - pos.getTableOffset(), columnIndex - columnOffset);
    }

    private TablePosition getTableModelForRow(int row) {
        for (int i = 0; i < this.models.size(); ++i) {
            TablePosition pos = (TablePosition)this.models.get(i);
            int maxRow = pos.getTableOffset() + pos.getTableModel().getRowCount();
            if (row >= maxRow) continue;
            return pos;
        }
        return null;
    }

    private class TableChangeHandler
    implements TableModelListener {
        private TableChangeHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == -1) {
                JoiningTableModel.this.updateStructure();
            } else if (e.getType() == 1 || e.getType() == -1) {
                JoiningTableModel.this.updateRowCount();
            } else {
                JoiningTableModel.this.updateData();
            }
        }
    }

    private static class TablePosition {
        private TableModel tableModel;
        private String prefix;
        private int tableOffset;
        private int columnOffset;

        private TablePosition(TableModel tableModel, String prefix) {
            if (tableModel == null) {
                throw new NullPointerException("Model must not be null");
            }
            if (prefix == null) {
                throw new NullPointerException("Prefix must not be null.");
            }
            this.tableModel = tableModel;
            this.prefix = prefix;
        }

        public void updateOffsets(int tableOffset, int columnOffset) {
            this.tableOffset = tableOffset;
            this.columnOffset = columnOffset;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int getColumnOffset() {
            return this.columnOffset;
        }

        public TableModel getTableModel() {
            return this.tableModel;
        }

        public int getTableOffset() {
            return this.tableOffset;
        }
    }
}

