/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext;

import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.fonts.monospace.MonospaceFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class TextOutputProcessorMetaData
extends AbstractOutputProcessorMetaData {
    public static final OutputProcessorFeature.NumericOutputProcessorFeature CHAR_WIDTH = new OutputProcessorFeature.NumericOutputProcessorFeature("txt.character-width-pt");
    public static final OutputProcessorFeature.NumericOutputProcessorFeature CHAR_HEIGHT = new OutputProcessorFeature.NumericOutputProcessorFeature("txt.character-height-pt");

    public TextOutputProcessorMetaData(float lpi, float cpi) {
        super((FontStorage)new DefaultFontStorage((FontRegistry)new MonospaceFontRegistry(lpi, cpi)));
        this.setNumericFeatureValue(CHAR_WIDTH, 72.0 / (double)cpi);
        this.setNumericFeatureValue(CHAR_HEIGHT, 72.0 / (double)lpi);
    }

    @Override
    public void initialize(Configuration configuration) {
        super.initialize(configuration);
        this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        this.addFeature(OutputProcessorFeature.PAGEBREAKS);
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.AssumeOverflowX"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_X);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.AssumeOverflowY"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_Y);
        }
        this.removeFeature(OutputProcessorFeature.LEGACY_LINEHEIGHT_CALC);
    }

    @Override
    public boolean isFeatureSupported(OutputProcessorFeature.BooleanOutputProcessorFeature feature) {
        if (OutputProcessorFeature.LEGACY_LINEHEIGHT_CALC.equals(feature)) {
            return false;
        }
        return super.isFeatureSupported(feature);
    }

    @Override
    public String getExportDescriptor() {
        return "pageable/text";
    }
}

