/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.base;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.WatermarkAreaBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateSimpleStructureProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.util.ProcessUtility;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.BandMarker;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellMarker;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.ContentMarker;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.FinishedMarker;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.GenericObjectTable;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class TableContentProducer
extends IterateSimpleStructureProcessStep {
    private static final Log logger = LogFactory.getLog(TableContentProducer.class);
    private SheetLayout sheetLayout;
    private GenericObjectTable<CellMarker> contentBackend;
    private long maximumHeight;
    private long maximumWidth;
    private TableRectangle lookupRectangle;
    private long pageOffset;
    private long pageEndPosition;
    private String sheetName;
    private int finishedRows;
    private int filledRows;
    private int clearedRows;
    private long contentOffset;
    private long effectiveHeaderSize;
    private boolean unalignedPagebands;
    private boolean headerProcessed;
    private boolean ellipseAsBackground;
    private boolean shapesAsContent;
    private boolean processWatermark;
    private boolean verboseCellMarkers;
    private int verboseCellMarkersThreshold;
    private boolean debugReportLayout;
    private boolean reportCellConflicts;
    private boolean failOnCellConflicts;
    private int sectionDepth;
    private CellMarker.SectionType sectionType;
    private OutputProcessorMetaData metaData;

    public TableContentProducer(SheetLayout sheetLayout, OutputProcessorMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        if (sheetLayout == null) {
            throw new NullPointerException();
        }
        this.metaData = metaData;
        this.processWatermark = metaData.isFeatureSupported(OutputProcessorFeature.WATERMARK_SECTION);
        this.unalignedPagebands = metaData.isFeatureSupported(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        this.shapesAsContent = metaData.isFeatureSupported(AbstractTableOutputProcessor.SHAPES_CONTENT);
        this.ellipseAsBackground = metaData.isFeatureSupported(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE);
        this.updateSheetLayout(sheetLayout);
        Configuration config = metaData.getConfiguration();
        boolean designTime = metaData.isFeatureSupported(OutputProcessorFeature.DESIGNTIME);
        if (!designTime) {
            this.debugReportLayout = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.DebugReportLayout"));
            this.verboseCellMarkers = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.VerboseCellMarkers"));
            this.verboseCellMarkersThreshold = ParserUtil.parseInt((String)config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.VerboseCellMarkerThreshold"), (int)5000);
            this.reportCellConflicts = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.ReportCellConflicts"));
            this.failOnCellConflicts = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.FailOnCellConflicts"));
        }
    }

    public boolean isProcessWatermark() {
        return this.processWatermark;
    }

    public void setProcessWatermark(boolean processWatermark) {
        this.processWatermark = processWatermark;
    }

    protected void updateSheetLayout(SheetLayout sheetLayout) {
        if (sheetLayout == null) {
            throw new NullPointerException();
        }
        this.sheetLayout = sheetLayout;
        this.maximumHeight = sheetLayout.getMaxHeight();
        this.maximumWidth = sheetLayout.getMaxWidth();
        if (this.contentBackend == null) {
            this.contentBackend = new GenericObjectTable(Math.max(1, sheetLayout.getRowCount()), Math.max(1, sheetLayout.getColumnCount()));
        }
        this.contentBackend.ensureCapacity(sheetLayout.getRowCount(), sheetLayout.getColumnCount());
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public CellMarker.SectionType getSectionType() {
        return this.sectionType;
    }

    public void compute(LogicalPageBox logicalPage, boolean iterativeUpdate) {
        this.sheetName = null;
        if (!this.unalignedPagebands) {
            this.pageOffset = 0L;
            this.effectiveHeaderSize = 0L;
            this.pageEndPosition = logicalPage.getPageEnd();
            this.sectionType = CellMarker.SectionType.TYPE_INVALID;
            if (this.startBox(logicalPage)) {
                if (!this.headerProcessed) {
                    this.sectionType = CellMarker.SectionType.TYPE_HEADER;
                    if (this.isProcessWatermark()) {
                        this.startProcessing(logicalPage.getWatermarkArea());
                    }
                    BlockRenderBox headerArea = logicalPage.getHeaderArea();
                    this.startProcessing(headerArea);
                    this.headerProcessed = true;
                }
                this.sectionType = CellMarker.SectionType.TYPE_NORMALFLOW;
                this.processBoxChilds(logicalPage);
                if (!iterativeUpdate) {
                    this.sectionType = CellMarker.SectionType.TYPE_REPEAT_FOOTER;
                    BlockRenderBox repeatFooterBox = logicalPage.getRepeatFooterArea();
                    this.startProcessing(repeatFooterBox);
                    this.sectionType = CellMarker.SectionType.TYPE_FOOTER;
                    BlockRenderBox pageFooterBox = logicalPage.getFooterArea();
                    this.startProcessing(pageFooterBox);
                }
            }
            this.sectionType = CellMarker.SectionType.TYPE_INVALID;
            this.finishBox(logicalPage);
        } else {
            this.effectiveHeaderSize = 0L;
            this.pageOffset = logicalPage.getPageOffset();
            this.pageEndPosition = logicalPage.getPageEnd();
            this.sectionType = CellMarker.SectionType.TYPE_INVALID;
            if (this.startBox(logicalPage)) {
                if (!this.headerProcessed) {
                    this.sectionType = CellMarker.SectionType.TYPE_HEADER;
                    this.pageOffset = 0L;
                    this.contentOffset = 0L;
                    this.effectiveHeaderSize = 0L;
                    if (this.isProcessWatermark()) {
                        WatermarkAreaBox watermarkArea = logicalPage.getWatermarkArea();
                        this.pageEndPosition = watermarkArea.getHeight();
                        this.startProcessing(watermarkArea);
                    }
                    BlockRenderBox headerArea = logicalPage.getHeaderArea();
                    this.pageEndPosition = headerArea.getHeight();
                    this.startProcessing(headerArea);
                    this.contentOffset = headerArea.getHeight();
                    this.headerProcessed = true;
                }
                this.sectionType = CellMarker.SectionType.TYPE_NORMALFLOW;
                this.pageOffset = logicalPage.getPageOffset();
                this.pageEndPosition = logicalPage.getPageEnd();
                this.effectiveHeaderSize = this.contentOffset;
                this.processBoxChilds(logicalPage);
                if (!iterativeUpdate) {
                    this.pageOffset = 0L;
                    this.sectionType = CellMarker.SectionType.TYPE_REPEAT_FOOTER;
                    BlockRenderBox repeatFooterArea = logicalPage.getRepeatFooterArea();
                    long repeatFooterOffset = this.contentOffset + (logicalPage.getPageEnd() - logicalPage.getPageOffset());
                    long repeatFooterPageEnd = repeatFooterOffset + repeatFooterArea.getHeight();
                    this.effectiveHeaderSize = repeatFooterOffset;
                    this.pageEndPosition = repeatFooterPageEnd;
                    this.startProcessing(repeatFooterArea);
                    BlockRenderBox footerArea = logicalPage.getFooterArea();
                    this.sectionType = CellMarker.SectionType.TYPE_FOOTER;
                    long footerPageEnd = repeatFooterPageEnd + footerArea.getHeight();
                    this.effectiveHeaderSize = repeatFooterPageEnd;
                    this.pageEndPosition = footerPageEnd;
                    this.startProcessing(footerArea);
                }
            }
            this.sectionType = CellMarker.SectionType.TYPE_INVALID;
            this.finishBox(logicalPage);
        }
        if (iterativeUpdate) {
            this.updateFilledRows();
        } else {
            this.filledRows = this.getRowCount();
        }
        if (!iterativeUpdate) {
            this.headerProcessed = false;
        }
    }

    protected void computeDesigntimeConflicts(RenderBox box) {
        this.pageOffset = 0L;
        this.effectiveHeaderSize = 0L;
        this.contentOffset = 0L;
        this.pageEndPosition = box.getHeight();
        this.contentOffset = 0L;
        this.contentBackend.clear();
        this.startProcessing(box);
        this.filledRows = this.getRowCount();
    }

    public RenderBox getContent(int row, int column) {
        if (!(this.verboseCellMarkers && row <= this.verboseCellMarkersThreshold || row >= this.finishedRows)) {
            return null;
        }
        CellMarker marker = (CellMarker)this.contentBackend.getObject(row, column);
        if (marker == null) {
            return null;
        }
        return marker.getContent();
    }

    public RenderBox getBackground(int row, int column) {
        if (!(this.verboseCellMarkers && row <= this.verboseCellMarkersThreshold || row >= this.finishedRows)) {
            return null;
        }
        CellMarker marker = (CellMarker)this.contentBackend.getObject(row, column);
        if (marker instanceof BandMarker) {
            BandMarker bandMarker = (BandMarker)marker;
            return bandMarker.getBandBox();
        }
        return null;
    }

    public CellMarker.SectionType getSectionType(int row, int column) {
        if (!(this.verboseCellMarkers && row <= this.verboseCellMarkersThreshold || row >= this.finishedRows)) {
            return CellMarker.SectionType.TYPE_INVALID;
        }
        CellMarker marker = (CellMarker)this.contentBackend.getObject(row, column);
        if (marker == null) {
            return CellMarker.SectionType.TYPE_INVALID;
        }
        return marker.getSectionType();
    }

    public long getContentOffset(int row, int column) {
        if (!(this.verboseCellMarkers && row <= this.verboseCellMarkersThreshold || row >= this.finishedRows)) {
            return 0L;
        }
        CellMarker marker = (CellMarker)this.contentBackend.getObject(row, column);
        if (marker == null) {
            return 0L;
        }
        return marker.getContentOffset();
    }

    public int getRowCount() {
        return Math.max(this.contentBackend.getRowCount(), this.sheetLayout.getRowCount());
    }

    public int getColumnCount() {
        return Math.max(this.contentBackend.getColumnCount(), this.sheetLayout.getColumnCount());
    }

    @Override
    protected boolean startBox(RenderBox box) {
        boolean isContentBox;
        ++this.sectionDepth;
        if (this.isProcessed(box)) {
            return true;
        }
        long height = box.getHeight();
        if (height > 0L) {
            if (box.getY() + height <= this.pageOffset) {
                return false;
            }
            if (box.getY() >= this.pageEndPosition) {
                return false;
            }
        } else {
            if (box.getY() + height < this.pageOffset) {
                return false;
            }
            if (box.getY() > this.pageEndPosition) {
                return false;
            }
        }
        long y = box.getY() + this.effectiveHeaderSize - this.pageOffset;
        long y1 = Math.max(this.effectiveHeaderSize, y);
        long boxX = box.getX();
        long x1 = Math.max(0L, boxX);
        long y2 = Math.min(y + box.getHeight(), this.maximumHeight);
        long x2 = Math.min(boxX + box.getWidth(), this.maximumWidth);
        this.lookupRectangle = this.sheetLayout.getTableBounds(x1, y1, x2 - x1, y2 - y1, this.lookupRectangle);
        Boolean contentBoxHint = box.getContentBox();
        if (Boolean.TRUE.equals(contentBoxHint)) {
            isContentBox = contentBoxHint;
        } else if ((box.getNodeType() & 0x102) == 258 || box.getStaticBoxLayoutProperties().isPlaceholderBox()) {
            boolean bl = isContentBox = ProcessUtility.isContent(box, this.ellipseAsBackground, this.shapesAsContent) || this.metaData.isExtraContentElement(box.getStyleSheet(), box.getAttributes());
            if (isContentBox) {
                box.setContentBox(Boolean.TRUE);
            } else {
                box.setContentBox(Boolean.FALSE);
            }
            box.setContentAge(box.getChangeTracker());
        } else if (box.getFirstChild() == null) {
            isContentBox = false;
        } else if (contentBoxHint != null && box.getContentAge() == box.getChangeTracker()) {
            isContentBox = contentBoxHint;
        } else {
            boolean bl = isContentBox = ProcessUtility.isContent(box, this.ellipseAsBackground, this.shapesAsContent) || this.metaData.isExtraContentElement(box.getStyleSheet(), box.getAttributes());
            if (isContentBox) {
                box.setContentBox(Boolean.TRUE);
            } else {
                box.setContentBox(Boolean.FALSE);
            }
            box.setContentAge(box.getChangeTracker());
        }
        if (!isContentBox) {
            this.collectSheetStyleData(box);
            if (box.isCommited()) {
                box.setFinishedTable(true);
            }
            if (this.isProcessed(box)) {
                int rectX2 = this.lookupRectangle.getX2();
                int rectY2 = this.lookupRectangle.getY2();
                if (!box.isCommited()) {
                    throw new IllegalStateException();
                }
                this.contentBackend.ensureCapacity(rectY2, rectX2);
                BandMarker bandMarker = new BandMarker(box, this.sectionType, this.sectionDepth);
                for (int r = Math.max(this.lookupRectangle.getY1(), this.finishedRows); r < rectY2; ++r) {
                    for (int c = this.lookupRectangle.getX1(); c < rectX2; ++c) {
                        CellMarker o = (CellMarker)this.contentBackend.getObject(r, c);
                        if (!this.isReplaceableBackground(o, bandMarker)) continue;
                        this.contentBackend.setObject(r, c, (Object)bandMarker);
                    }
                }
            }
            return true;
        }
        if (!box.isCommited()) {
            return false;
        }
        this.collectSheetStyleData(box);
        if (!this.isCellSpaceOccupied(this.lookupRectangle)) {
            int rectX2 = this.lookupRectangle.getX2();
            int rectY2 = this.lookupRectangle.getY2();
            this.contentBackend.ensureCapacity(rectY2, rectX2);
            ContentMarker contentMarker = new ContentMarker(box, this.effectiveHeaderSize - this.pageOffset, this.sectionType);
            for (int r = this.lookupRectangle.getY1(); r < rectY2; ++r) {
                for (int c = this.lookupRectangle.getX1(); c < rectX2; ++c) {
                    this.contentBackend.setObject(r, c, (Object)contentMarker);
                }
            }
        } else {
            this.handleContentConflict(box);
            box.setFinishedTable(true);
        }
        return true;
    }

    protected boolean isProcessed(RenderBox box) {
        return box.isFinishedTable();
    }

    protected boolean isReplaceableBackground(CellMarker oldMarker, CellMarker newMarker) {
        if (oldMarker == null) {
            return true;
        }
        if (oldMarker.getSectionType() == CellMarker.SectionType.TYPE_INVALID) {
            return true;
        }
        if (oldMarker.getSectionType() != newMarker.getSectionType()) {
            return false;
        }
        return oldMarker.getSectionDepth() < newMarker.getSectionDepth();
    }

    protected TableRectangle getLookupRectangle() {
        return this.lookupRectangle;
    }

    protected boolean isFailOnCellConflicts() {
        return this.failOnCellConflicts;
    }

    protected void setFailOnCellConflicts(boolean failOnCellConflicts) {
        this.failOnCellConflicts = failOnCellConflicts;
    }

    protected void handleContentConflict(RenderBox box) {
        if (this.reportCellConflicts) {
            logger.debug((Object)("LayoutShift: Offending Content: " + box));
            logger.debug((Object)("LayoutShift: Offending Content: " + box.isFinishedTable()));
        }
        if (this.failOnCellConflicts) {
            throw new InvalidReportStateException("Cannot export content, discovered overlapping cells.");
        }
    }

    protected void collectSheetStyleData(RenderBox box) {
        String sheetName = (String)box.getStyleSheet().getStyleProperty(BandStyleKeys.COMPUTED_SHEETNAME);
        if (this.sheetName == null && sheetName != null) {
            this.sheetName = sheetName;
        }
    }

    private boolean isCellSpaceOccupied(TableRectangle rect) {
        int x2 = rect.getX2();
        int y2 = rect.getY2();
        for (int r = rect.getY1(); r < y2; ++r) {
            if (r < this.finishedRows) {
                logger.debug((Object)("Row (" + r + ") already finished"));
                return true;
            }
            for (int c = rect.getX1(); c < x2; ++c) {
                Object object = this.contentBackend.getObject(r, c);
                if (object == null || object instanceof BandMarker) continue;
                if (this.reportCellConflicts) {
                    logger.debug((Object)("Cell (" + c + ", " + r + ") already filled: Content in cell: " + object));
                }
                return true;
            }
        }
        return false;
    }

    public int getFinishedRows() {
        return this.finishedRows;
    }

    public void clearFinishedBoxes() {
        int rowCount = this.getFilledRows();
        int columnCount = this.getColumnCount();
        if (this.debugReportLayout) {
            logger.debug((Object)("Request: Clearing rows from " + this.finishedRows + " to " + rowCount));
        }
        boolean atleastOneRowHasContent = false;
        int lastRowCleared = this.clearedRows - 1;
        for (int row = this.finishedRows; row < rowCount; ++row) {
            boolean lastRowsUndefined = false;
            boolean rowHasContent = false;
            for (int column = 0; column < columnCount; ++column) {
                CellMarker o = (CellMarker)this.contentBackend.getObject(row, column);
                if (o == null) {
                    if (this.debugReportLayout) {
                        logger.debug((Object)("maybe Cannot clear row: Cell (" + column + ", " + row + ") is undefined."));
                    }
                    lastRowsUndefined = true;
                    continue;
                }
                if (lastRowsUndefined) {
                    if (this.debugReportLayout) {
                        logger.debug((Object)("Cannot clear row: Inner Cell (" + column + ", " + row + ") is undefined."));
                    }
                    return;
                }
                boolean b = o.isFinished();
                if (!b) {
                    if (this.debugReportLayout) {
                        logger.debug((Object)("Cannot clear row: Cell (" + column + ", " + row + ") is not finished: " + o));
                    }
                    return;
                }
                if (rowHasContent || o.getContent() == null) continue;
                rowHasContent = true;
            }
            if (!rowHasContent) continue;
            atleastOneRowHasContent = true;
            this.finishedRows = row + 1;
            this.clearedRows = row + 1;
            for (int clearRowNr = lastRowCleared + 1; clearRowNr < this.finishedRows; ++clearRowNr) {
                if (this.debugReportLayout) {
                    logger.debug((Object)("#Cleared row: " + clearRowNr + '.'));
                }
                if (this.verboseCellMarkers && this.filledRows < this.verboseCellMarkersThreshold) {
                    for (int column = 0; column < columnCount; ++column) {
                        Object o = this.contentBackend.getObject(clearRowNr, column);
                        FinishedMarker finishedMarker = new FinishedMarker(String.valueOf(o));
                        this.contentBackend.setObject(clearRowNr, column, (Object)finishedMarker);
                    }
                    continue;
                }
                this.contentBackend.clearRow(clearRowNr);
            }
            lastRowCleared = row;
        }
        if (this.debugReportLayout) {
            logger.debug((Object)("Need to clear  row: " + (lastRowCleared + 1) + " - " + this.filledRows));
        }
        this.finishedRows = this.filledRows;
        if (atleastOneRowHasContent) {
            int clearRowNr = lastRowCleared + 1;
            while (clearRowNr < this.finishedRows) {
                if (this.debugReportLayout) {
                    logger.debug((Object)("*Cleared row: " + clearRowNr + '.'));
                }
                if (this.verboseCellMarkers && this.filledRows < this.verboseCellMarkersThreshold) {
                    for (int column = 0; column < columnCount; ++column) {
                        Object o = this.contentBackend.getObject(clearRowNr, column);
                        FinishedMarker finishedMarker = new FinishedMarker(String.valueOf(o));
                        this.contentBackend.setObject(clearRowNr, column, (Object)finishedMarker);
                    }
                } else {
                    this.contentBackend.clearRow(clearRowNr);
                }
                this.clearedRows = clearRowNr++;
            }
        }
    }

    @Override
    protected void finishBox(RenderBox box) {
        --this.sectionDepth;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
    }

    public SheetLayout getSheetLayout() {
        return this.sheetLayout;
    }

    public int getFilledRows() {
        return this.filledRows;
    }

    private void updateFilledRows() {
        int rowCount = this.contentBackend.getRowCount();
        int columnCount = this.getColumnCount();
        this.filledRows = this.finishedRows;
        for (int row = this.finishedRows; row < rowCount; ++row) {
            boolean lastRowsUndefined = false;
            for (int column = 0; column < columnCount; ++column) {
                CellMarker o = (CellMarker)this.contentBackend.getObject(row, column);
                if (o == null) {
                    if (this.debugReportLayout) {
                        logger.debug((Object)("Row: Cell (" + column + ", " + row + ") is undefined."));
                    }
                    lastRowsUndefined = true;
                    continue;
                }
                if (lastRowsUndefined) {
                    if (this.debugReportLayout) {
                        logger.debug((Object)("Row: Inner Cell (" + column + ", " + row + ") is undefined."));
                    }
                    return;
                }
                if (o.isCommited()) continue;
                if (this.debugReportLayout) {
                    logger.debug((Object)("Row: Cell (" + column + ", " + row + ") is not commited."));
                }
                return;
            }
            if (this.debugReportLayout) {
                logger.debug((Object)("Processable Row: " + this.filledRows + "."));
            }
            this.filledRows = row + 1;
        }
        if (this.debugReportLayout) {
            logger.debug((Object)("Processable Rows: " + this.finishedRows + ' ' + this.filledRows + '.'));
        }
    }

    public long getContentRowCount() {
        return this.contentBackend.getRowCount();
    }

    @Override
    protected void processBoxChilds(RenderBox box) {
        if (box.getLayoutNodeType() == 274) {
            return;
        }
        super.processBoxChilds(box);
    }

    public void reset(SheetLayout layout) {
        this.updateSheetLayout(layout);
        this.contentBackend.clear();
        this.pageOffset = 0L;
        this.effectiveHeaderSize = 0L;
        this.contentOffset = 0L;
        this.pageEndPosition = 0L;
        this.contentOffset = 0L;
        this.filledRows = 0;
    }
}

