/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.base;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.WatermarkAreaBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateSimpleStructureProcessStep;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;

public class TableLayoutProducer
extends IterateSimpleStructureProcessStep {
    private SheetLayout layout;
    private long pageOffset;
    private boolean headerProcessed;
    private long contentOffset;
    private long effectiveHeaderSize;
    private long pageEndPosition;
    private boolean unalignedPagebands;
    private boolean strictLayout;
    private boolean ellipseAsRectangle;
    private boolean processWatermark;

    public TableLayoutProducer(OutputProcessorMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.processWatermark = metaData.isFeatureSupported(OutputProcessorFeature.WATERMARK_SECTION);
        this.unalignedPagebands = metaData.isFeatureSupported(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        this.strictLayout = metaData.isFeatureSupported(AbstractTableOutputProcessor.STRICT_LAYOUT);
        this.ellipseAsRectangle = metaData.isFeatureSupported(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE);
        this.layout = new SheetLayout(this.strictLayout, this.ellipseAsRectangle);
    }

    public boolean isProcessWatermark() {
        return this.processWatermark;
    }

    public void setProcessWatermark(boolean processWatermark) {
        this.processWatermark = processWatermark;
    }

    public SheetLayout getLayout() {
        return this.layout;
    }

    public void update(LogicalPageBox logicalPage, boolean iterativeUpdate) {
        if (!this.unalignedPagebands) {
            this.pageOffset = 0L;
            this.effectiveHeaderSize = 0L;
            this.pageEndPosition = logicalPage.getPageEnd();
            if (this.startBox(logicalPage)) {
                if (!this.headerProcessed) {
                    if (this.processWatermark) {
                        this.startProcessing(logicalPage.getWatermarkArea());
                    }
                    BlockRenderBox headerArea = logicalPage.getHeaderArea();
                    this.startProcessing(headerArea);
                    this.headerProcessed = true;
                }
                this.processBoxChilds(logicalPage);
                if (!iterativeUpdate) {
                    BlockRenderBox repeatFooterBox = logicalPage.getRepeatFooterArea();
                    this.startProcessing(repeatFooterBox);
                    BlockRenderBox pageFooterBox = logicalPage.getFooterArea();
                    this.startProcessing(pageFooterBox);
                }
            }
            this.finishBox(logicalPage);
        } else {
            this.effectiveHeaderSize = 0L;
            this.pageOffset = logicalPage.getPageOffset();
            this.pageEndPosition = logicalPage.getPageEnd();
            if (this.startBox(logicalPage)) {
                if (!this.headerProcessed) {
                    this.pageOffset = 0L;
                    this.contentOffset = 0L;
                    this.effectiveHeaderSize = 0L;
                    if (this.processWatermark) {
                        WatermarkAreaBox watermarkArea = logicalPage.getWatermarkArea();
                        this.pageEndPosition = watermarkArea.getHeight();
                        this.startProcessing(watermarkArea);
                    }
                    BlockRenderBox headerArea = logicalPage.getHeaderArea();
                    this.pageEndPosition = headerArea.getHeight();
                    this.startProcessing(headerArea);
                    this.contentOffset = headerArea.getHeight();
                    this.headerProcessed = true;
                }
                this.pageOffset = logicalPage.getPageOffset();
                this.pageEndPosition = logicalPage.getPageEnd();
                this.effectiveHeaderSize = this.contentOffset;
                this.processBoxChilds(logicalPage);
                if (!iterativeUpdate) {
                    this.pageOffset = 0L;
                    BlockRenderBox repeatFooterArea = logicalPage.getRepeatFooterArea();
                    long repeatFooterOffset = this.contentOffset + (logicalPage.getPageEnd() - logicalPage.getPageOffset());
                    long repeatFooterPageEnd = repeatFooterOffset + repeatFooterArea.getHeight();
                    this.effectiveHeaderSize = repeatFooterOffset;
                    this.pageEndPosition = repeatFooterPageEnd;
                    this.startProcessing(repeatFooterArea);
                    BlockRenderBox footerArea = logicalPage.getFooterArea();
                    long footerPageEnd = repeatFooterPageEnd + footerArea.getHeight();
                    this.effectiveHeaderSize = repeatFooterPageEnd;
                    this.pageEndPosition = footerPageEnd;
                    this.startProcessing(footerArea);
                }
            }
            this.finishBox(logicalPage);
        }
    }

    @Override
    protected boolean startBox(RenderBox box) {
        if (box.getLayoutNodeType() == 258) {
            this.processRenderableContent((RenderableReplacedContentBox)box);
            return false;
        }
        return this.startBoxInternal(box);
    }

    private boolean startBoxInternal(RenderBox box) {
        long height = box.getHeight();
        if (height > 0L) {
            if (box.getY() + height <= this.pageOffset) {
                return false;
            }
            if (box.getY() >= this.pageEndPosition) {
                return false;
            }
        } else {
            if (box.getY() + height < this.pageOffset) {
                return false;
            }
            if (box.getY() > this.pageEndPosition) {
                return false;
            }
        }
        if (!box.isOpen() && !box.isFinishedTable() && box.isCommited()) {
            if (this.layout.add(box, this.pageOffset, this.effectiveHeaderSize, this.pageEndPosition)) {
                return false;
            }
            box.setFinishedTable(true);
            return true;
        }
        return true;
    }

    protected void processRenderableContent(RenderableReplacedContentBox box) {
        if (!box.isOpen() && !box.isFinishedTable() && box.isCommited()) {
            this.startBoxInternal(box);
            this.layout.addRenderableContent(box, this.pageOffset, this.effectiveHeaderSize, this.pageEndPosition);
        }
    }

    @Override
    protected void processBoxChilds(RenderBox box) {
        if (box.getLayoutNodeType() == 274) {
            return;
        }
        super.processBoxChilds(box);
    }

    public void pageCompleted() {
        this.layout.pageCompleted();
        this.headerProcessed = false;
    }

    public void computeDesigntimeConflicts(RenderBox box) {
        this.clear();
        this.pageEndPosition = box.getHeight();
        this.startProcessing(box);
    }

    public void clear() {
        this.layout.clear();
        this.effectiveHeaderSize = 0L;
        this.pageOffset = 0L;
        this.pageEndPosition = 0L;
        this.contentOffset = 0L;
        this.headerProcessed = false;
    }
}

