/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html;

import java.awt.Color;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ClassicEngineInfo;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.LocalImageContainer;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.URLImageContainer;
import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderCorner;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackgroundProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellMarker;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FileSystemURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlContentGenerator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriteException;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.DefaultStyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.FilterStyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.GlobalStyleManager;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.InlineStyleManager;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleManager;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.util.HtmlColors;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.util.HtmlEncoderUtil;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.encoder.UnsupportedEncoderException;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.MemoryStringReader;
import org.pentaho.reporting.libraries.base.util.MemoryStringWriter;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public abstract class HtmlPrinter
implements HtmlContentGenerator {
    private static final Log logger = LogFactory.getLog(HtmlPrinter.class);
    private static final String GENERATOR = ClassicEngineInfo.getInstance().getName() + " version " + ClassicEngineInfo.getInstance().getVersion();
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private static final String[] XHTML_HEADER = new String[]{"<!DOCTYPE html", "     PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"", "     \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">"};
    private Configuration configuration;
    private XmlWriter xmlWriter;
    private boolean assumeZeroMargins;
    private boolean assumeZeroBorders;
    private boolean assumeZeroPaddings;
    private ContentLocation contentLocation;
    private NameGenerator contentNameGenerator;
    private ContentLocation dataLocation;
    private NameGenerator dataNameGenerator;
    private ResourceManager resourceManager;
    private HashMap<ResourceKey, String> knownResources;
    private HashMap<String, String> knownImages;
    private HashSet<String> validRawTypes;
    private URLRewriter urlRewriter;
    private ContentItem documentContentItem;
    private StyleManager styleManager;
    private boolean allowRawLinkTargets;
    private boolean copyExternalImages;
    private StyleBuilder styleBuilder;
    private static final StyleBuilder.CSSKeys[] EMPTY_CELL_ATTRNAMES = new StyleBuilder.CSSKeys[]{StyleBuilder.CSSKeys.FONT_SIZE};
    private static final String[] EMPTY_CELL_ATTRVALS = new String[]{"1pt"};
    private MemoryStringWriter bufferWriter;
    private BufferedWriter writer;
    private ContentItem styleFile;
    private String styleFileUrl;
    private HtmlTextExtractor textExtractor;
    private CellBackgroundProducer cellBackgroundProducer;
    private boolean safariLengthFix;
    private boolean useWhitespacePreWrap;
    private boolean enableRoundBorderCorner;

    protected HtmlPrinter(ResourceManager resourceManager) {
        if (resourceManager == null) {
            throw new NullPointerException("A resource-manager must be given.");
        }
        this.resourceManager = resourceManager;
        this.knownResources = new HashMap();
        this.knownImages = new HashMap();
        this.styleBuilder = new DefaultStyleBuilder();
        this.validRawTypes = new HashSet();
        this.validRawTypes.add("image/gif");
        this.validRawTypes.add("image/x-xbitmap");
        this.validRawTypes.add("image/gi_");
        this.validRawTypes.add("image/jpeg");
        this.validRawTypes.add("image/jpg");
        this.validRawTypes.add("image/jp_");
        this.validRawTypes.add("application/jpg");
        this.validRawTypes.add("application/x-jpg");
        this.validRawTypes.add("image/pjpeg");
        this.validRawTypes.add("image/pipeg");
        this.validRawTypes.add("image/vnd.swiftview-jpeg");
        this.validRawTypes.add("image/x-xbitmap");
        this.validRawTypes.add("image/png");
        this.validRawTypes.add("application/png");
        this.validRawTypes.add("application/x-png");
        this.assumeZeroMargins = true;
        this.assumeZeroBorders = true;
        this.assumeZeroPaddings = true;
        this.urlRewriter = new FileSystemURLRewriter();
        this.safariLengthFix = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.SafariLengthHack"));
        this.useWhitespacePreWrap = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.UseWhitespacePreWrap"));
        this.enableRoundBorderCorner = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.EnableRoundBorderCorner"));
    }

    protected boolean isAllowRawLinkTargets() {
        return this.allowRawLinkTargets;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected boolean isAssumeZeroMargins() {
        return this.assumeZeroMargins;
    }

    protected void setAssumeZeroMargins(boolean assumeZeroMargins) {
        this.assumeZeroMargins = assumeZeroMargins;
    }

    protected boolean isAssumeZeroBorders() {
        return this.assumeZeroBorders;
    }

    protected void setAssumeZeroBorders(boolean assumeZeroBorders) {
        this.assumeZeroBorders = assumeZeroBorders;
    }

    protected boolean isAssumeZeroPaddings() {
        return this.assumeZeroPaddings;
    }

    protected void setAssumeZeroPaddings(boolean assumeZeroPaddings) {
        this.assumeZeroPaddings = assumeZeroPaddings;
    }

    public ContentLocation getContentLocation() {
        return this.contentLocation;
    }

    public NameGenerator getContentNameGenerator() {
        return this.contentNameGenerator;
    }

    public ContentLocation getDataLocation() {
        return this.dataLocation;
    }

    public NameGenerator getDataNameGenerator() {
        return this.dataNameGenerator;
    }

    public void setDataWriter(ContentLocation dataLocation, NameGenerator dataNameGenerator) {
        this.dataNameGenerator = dataNameGenerator;
        this.dataLocation = dataLocation;
    }

    public void setContentWriter(ContentLocation contentLocation, NameGenerator contentNameGenerator) {
        this.contentNameGenerator = contentNameGenerator;
        this.contentLocation = contentLocation;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public URLRewriter getUrlRewriter() {
        return this.urlRewriter;
    }

    public void setUrlRewriter(URLRewriter urlRewriter) {
        if (urlRewriter == null) {
            throw new NullPointerException();
        }
        this.urlRewriter = urlRewriter;
    }

    public ContentItem getDocumentContentItem() {
        return this.documentContentItem;
    }

    protected void setDocumentContentItem(ContentItem documentContentItem) {
        this.documentContentItem = documentContentItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeRaw(ResourceKey source) throws IOException {
        block13: {
            URL url;
            String protocol;
            Object identifier;
            if (source == null) {
                throw new NullPointerException();
            }
            if (!this.copyExternalImages && (identifier = source.getIdentifier()) instanceof URL && ("http".equalsIgnoreCase(protocol = (url = (URL)identifier).getProtocol()) || "https".equalsIgnoreCase(protocol) || "ftp".equalsIgnoreCase(protocol))) {
                return url.toExternalForm();
            }
            if (this.dataLocation == null) {
                return null;
            }
            try {
                ContentItem item;
                ResourceData resourceData = this.resourceManager.load(source);
                String mimeType = this.queryMimeType(resourceData);
                if (!this.isValidImage(mimeType) || !(item = this.dataLocation.createItem(this.dataNameGenerator.generateName(this.extractFilename(resourceData), mimeType))).isWriteable()) break block13;
                item.setAttribute("org.jfree.repository", "content-type", (Object)mimeType);
                BufferedInputStream stream = new BufferedInputStream(resourceData.getResourceAsStream(this.resourceManager));
                try {
                    BufferedOutputStream outputStream = new BufferedOutputStream(item.getOutputStream());
                    try {
                        IOUtils.getInstance().copyStreams((InputStream)stream, (OutputStream)outputStream);
                    }
                    finally {
                        ((OutputStream)outputStream).close();
                    }
                }
                finally {
                    ((InputStream)stream).close();
                }
                return this.urlRewriter.rewrite((ContentEntity)this.documentContentItem, (ContentEntity)item);
            }
            catch (ResourceLoadingException e) {
            }
            catch (ContentIOException e) {
            }
            catch (URLRewriteException e) {
                logger.warn((Object)"Rewriting the URL failed.", (Throwable)e);
                throw new RuntimeException("Failed", e);
            }
        }
        return null;
    }

    protected boolean isSupportedImageFormat(ResourceKey key) {
        URL url = this.resourceManager.toURL(key);
        if (url == null) {
            return false;
        }
        String file = url.getFile();
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".jpg")) {
            return true;
        }
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".jpeg")) {
            return true;
        }
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".png")) {
            return true;
        }
        return StringUtils.endsWithIgnoreCase((String)file, (String)".gif");
    }

    private ImageData getImageData(ImageContainer image, String encoderType, float quality, boolean alpha) throws IOException, UnsupportedEncoderException {
        URLImageContainer urlImage;
        ResourceKey url = null;
        if (image instanceof URLImageContainer && (url = (urlImage = (URLImageContainer)image).getResourceKey()) != null && urlImage.isLoadable() && this.isSupportedImageFormat(url)) {
            try {
                ResourceData data = this.resourceManager.load(url);
                byte[] imageData = data.getResource(this.resourceManager);
                String mimeType = this.queryMimeType(imageData);
                URL maybeRealURL = this.resourceManager.toURL(url);
                if (maybeRealURL != null) {
                    String originalFileName = IOUtils.getInstance().getFileName(maybeRealURL);
                    return new ImageData(imageData, mimeType, originalFileName);
                }
                return new ImageData(imageData, mimeType, "picture");
            }
            catch (ResourceException re) {
                logger.debug((Object)"Failed to process image as raw-data, trying as processed data next", (Throwable)re);
            }
        }
        if (image instanceof LocalImageContainer) {
            LocalImageContainer li = (LocalImageContainer)image;
            Image awtImage = li.getImage();
            if (awtImage == null && url != null) {
                try {
                    Resource resource = this.resourceManager.createDirectly((Object)url, Image.class);
                    awtImage = (Image)resource.getResource();
                }
                catch (ResourceException e) {
                    // empty catch block
                }
            }
            if (awtImage != null) {
                URL maybeRealURL;
                byte[] imageData = RenderUtility.encodeImage(awtImage, encoderType, quality, alpha);
                String originalFileName = url != null ? ((maybeRealURL = this.resourceManager.toURL(url)) != null ? IOUtils.getInstance().getFileName(maybeRealURL) : "picture") : "picture";
                return new ImageData(imageData, encoderType, originalFileName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeImage(ImageContainer image, String encoderType, float quality, boolean alpha) throws ContentIOException, IOException {
        String cacheKey;
        if (image == null) {
            throw new NullPointerException();
        }
        if (this.dataLocation == null) {
            return null;
        }
        if (image instanceof URLImageContainer) {
            URLImageContainer uic = (URLImageContainer)image;
            cacheKey = uic.getSourceURLString();
            String retval = this.knownImages.get(cacheKey);
            if (retval != null) {
                return retval;
            }
            String sourceURLString = uic.getSourceURLString();
            if (!uic.isLoadable() && sourceURLString != null) {
                this.knownImages.put(cacheKey, sourceURLString);
                return sourceURLString;
            }
        } else {
            cacheKey = null;
        }
        try {
            ImageData data = this.getImageData(image, encoderType, quality, alpha);
            if (data == null) {
                return null;
            }
            String filename = IOUtils.getInstance().stripFileExtension(data.getOriginalFileName());
            ContentItem dataFile = this.dataLocation.createItem(this.dataNameGenerator.generateName(filename, data.getMimeType()));
            String contentURL = this.urlRewriter.rewrite((ContentEntity)this.documentContentItem, (ContentEntity)dataFile);
            BufferedOutputStream out = new BufferedOutputStream(dataFile.getOutputStream());
            try {
                ((OutputStream)out).write(data.getImageData());
                ((OutputStream)out).flush();
            }
            finally {
                ((OutputStream)out).close();
            }
            if (cacheKey != null) {
                this.knownImages.put(cacheKey, contentURL);
            }
            return contentURL;
        }
        catch (ContentCreationException cce) {
            logger.warn((Object)("Failed to create the content image: Reason given was: " + cce.getMessage()));
            return null;
        }
        catch (URLRewriteException re) {
            logger.warn((Object)("Failed to write the URL: Reason given was: " + re.getMessage()));
            return null;
        }
        catch (UnsupportedEncoderException e) {
            logger.warn((Object)("Failed to write the URL: Reason given was: " + e.getMessage()));
            return null;
        }
    }

    private String extractFilename(ResourceData resourceData) {
        String filename = (String)resourceData.getAttribute("filename");
        if (filename == null) {
            return "image";
        }
        String pureFileName = IOUtils.getInstance().getFileName(filename);
        return IOUtils.getInstance().stripFileExtension(pureFileName);
    }

    private String queryMimeType(ResourceData resourceData) throws ResourceLoadingException, IOException {
        Object contentType = resourceData.getAttribute("content-type");
        if (contentType instanceof String) {
            return (String)contentType;
        }
        byte[] data = new byte[12];
        resourceData.getResource(this.resourceManager, data, 0L, data.length);
        return this.queryMimeType(data);
    }

    private String queryMimeType(byte[] data) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        if (this.isGIF(stream)) {
            return "image/gif";
        }
        stream.reset();
        if (this.isJPEG(stream)) {
            return "image/jpeg";
        }
        stream.reset();
        if (this.isPNG(stream)) {
            return "image/png";
        }
        return null;
    }

    private boolean isPNG(ByteArrayInputStream data) {
        int[] PNF_FINGERPRINT = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
        for (int i = 0; i < PNF_FINGERPRINT.length; ++i) {
            if (PNF_FINGERPRINT[i] == data.read()) continue;
            return false;
        }
        return true;
    }

    private boolean isJPEG(InputStream data) throws IOException {
        int[] JPG_FINGERPRINT_1 = new int[]{255, 216, 255, 224};
        for (int i = 0; i < JPG_FINGERPRINT_1.length; ++i) {
            if (JPG_FINGERPRINT_1[i] == data.read()) continue;
            return false;
        }
        if (data.read() == -1) {
            return false;
        }
        if (data.read() == -1) {
            return false;
        }
        int[] JPG_FINGERPRINT_2 = new int[]{74, 70, 73, 70, 0};
        for (int i = 0; i < JPG_FINGERPRINT_2.length; ++i) {
            if (JPG_FINGERPRINT_2[i] == data.read()) continue;
            return false;
        }
        return true;
    }

    private boolean isGIF(InputStream data) throws IOException {
        int[] GIF_FINGERPRINT = new int[]{71, 73, 70, 56};
        for (int i = 0; i < GIF_FINGERPRINT.length; ++i) {
            if (GIF_FINGERPRINT[i] == data.read()) continue;
            return false;
        }
        return true;
    }

    private boolean isValidImage(String mimeType) {
        return this.validRawTypes.contains(mimeType);
    }

    private boolean isCreateBodyFragment() {
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.BodyFragment", "false"));
    }

    private boolean isEmptyCellsUseCSS() {
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.EmptyCellsUseCSS", "false"));
    }

    private boolean isUseTableLayoutFixed() {
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.UseTableLayoutFixed", "true"));
    }

    private boolean isTableRowBorderDefinition() {
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.TableRowBorderDefinition", "false"));
    }

    private boolean isProportionalColumnWidths() {
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.ProportionalColumnWidths", "false"));
    }

    private StyleBuilder createCellStyle(RenderBox content, CellBackground background, StyleBuilder.CSSKeys[] extraStyleKeys, String[] extraStyleValues) {
        if (content == null) {
            this.styleBuilder.clear();
        } else {
            this.styleBuilder = HtmlPrinter.produceTextStyle(this.styleBuilder, content, true, this.safariLengthFix, this.useWhitespacePreWrap, this.enableRoundBorderCorner, null);
        }
        if (extraStyleKeys != null && extraStyleValues != null && extraStyleKeys.length == extraStyleValues.length) {
            for (int i = 0; i < extraStyleKeys.length; ++i) {
                this.styleBuilder.append(extraStyleKeys[i], extraStyleValues[i], false);
            }
        }
        if (background != null) {
            Color colorValue = background.getBackgroundColor();
            if (colorValue != null) {
                this.styleBuilder.append(StyleBuilder.CSSKeys.BACKGROUND_COLOR, HtmlColors.getColorString(colorValue));
            }
            BorderEdge topEdge = background.getTop();
            BorderEdge leftEdge = background.getLeft();
            BorderEdge bottomEdge = background.getBottom();
            BorderEdge rightEdge = background.getRight();
            if (topEdge.equals(leftEdge) && topEdge.equals(rightEdge) && topEdge.equals(bottomEdge)) {
                if (!BorderEdge.EMPTY.equals(topEdge)) {
                    this.styleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER, this.styleBuilder.printEdgeAsCSS(topEdge));
                }
            } else {
                if (!BorderEdge.EMPTY.equals(topEdge)) {
                    this.styleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_TOP, this.styleBuilder.printEdgeAsCSS(topEdge));
                }
                if (!BorderEdge.EMPTY.equals(leftEdge)) {
                    this.styleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_LEFT, this.styleBuilder.printEdgeAsCSS(leftEdge));
                }
                if (!BorderEdge.EMPTY.equals(bottomEdge)) {
                    this.styleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_BOTTOM, this.styleBuilder.printEdgeAsCSS(bottomEdge));
                }
                if (!BorderEdge.EMPTY.equals(rightEdge)) {
                    this.styleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_RIGHT, this.styleBuilder.printEdgeAsCSS(rightEdge));
                }
            }
            if (this.enableRoundBorderCorner) {
                BorderCorner bottomRight;
                BorderCorner bottomLeft;
                BorderCorner topRight;
                BorderCorner topLeft = background.getTopLeft();
                if (!BorderCorner.EMPTY.equals(topLeft)) {
                    this.styleBuilder.append(StyleBuilder.CSSKeys.MOZ_BORDER_RADIUS_TOP_LEFT, this.styleBuilder.printCornerAsCSS(topLeft));
                    this.styleBuilder.append(StyleBuilder.CSSKeys.BORDER_TOP_LEFT_RADIUS, this.styleBuilder.printCornerAsCSS(topLeft));
                }
                if (!BorderCorner.EMPTY.equals(topRight = background.getTopRight())) {
                    this.styleBuilder.append(StyleBuilder.CSSKeys.MOZ_BORDER_RADIUS_TOP_RIGHT, this.styleBuilder.printCornerAsCSS(topRight));
                    this.styleBuilder.append(StyleBuilder.CSSKeys.BORDER_TOP_RIGHT_RADIUS, this.styleBuilder.printCornerAsCSS(topRight));
                }
                if (!BorderCorner.EMPTY.equals(bottomLeft = background.getBottomLeft())) {
                    this.styleBuilder.append(StyleBuilder.CSSKeys.MOZ_BORDER_RADIUS_BOTTOM_LEFT, this.styleBuilder.printCornerAsCSS(bottomLeft));
                    this.styleBuilder.append(StyleBuilder.CSSKeys.BORDER_BOTTOM_LEFT_RADIUS, this.styleBuilder.printCornerAsCSS(bottomLeft));
                }
                if (!BorderCorner.EMPTY.equals(bottomRight = background.getBottomRight())) {
                    this.styleBuilder.append(StyleBuilder.CSSKeys.MOZ_BORDER_RADIUS_BOTTOM_RIGHT, this.styleBuilder.printCornerAsCSS(bottomRight));
                    this.styleBuilder.append(StyleBuilder.CSSKeys.BORDER_BOTTOM_RIGHT_RADIUS, this.styleBuilder.printCornerAsCSS(bottomRight));
                }
            }
        }
        return this.styleBuilder;
    }

    private AttributeList createCellAttributes(int colSpan, int rowSpan, RenderBox content, CellBackground background, StyleBuilder styleBuilder) {
        ReportAttributeMap attrs;
        AttributeList attrList = new AttributeList();
        if (content != null) {
            if (rowSpan > 1) {
                attrList.setAttribute(XHTML_NAMESPACE, "rowspan", String.valueOf(rowSpan));
            }
            if (colSpan > 1) {
                attrList.setAttribute(XHTML_NAMESPACE, "colspan", String.valueOf(colSpan));
            }
            ElementAlignment verticalAlignment = content.getNodeLayoutProperties().getVerticalAlignment();
            attrList.setAttribute(XHTML_NAMESPACE, "valign", this.translateVerticalAlignment(verticalAlignment));
        }
        if (background != null && content != null) {
            attrs = new ReportAttributeMap(background.getAttributes());
            attrs.putAll(content.getAttributes());
            HtmlPrinter.applyHtmlAttributes(attrs, attrList);
        } else if (background != null) {
            attrs = background.getAttributes();
            HtmlPrinter.applyHtmlAttributes(attrs, attrList);
        } else if (content != null) {
            HtmlPrinter.applyHtmlAttributes(content.getAttributes(), attrList);
        }
        this.styleManager.updateStyle(styleBuilder, attrList);
        return attrList;
    }

    private String translateVerticalAlignment(ElementAlignment ea) {
        if (ElementAlignment.BOTTOM.equals(ea)) {
            return "bottom";
        }
        if (ElementAlignment.MIDDLE.equals(ea)) {
            return "middle";
        }
        return "top";
    }

    private AttributeList createRowAttributes(LogicalPageBox logicalPageBox, SheetLayout sheetLayout, int row, TableContentProducer tableContentProducer) {
        AttributeList attrList = new AttributeList();
        int rowHeight = (int)StrictGeomUtility.toExternalValue(sheetLayout.getRowHeight(row));
        if (this.isTableRowBorderDefinition()) {
            this.styleBuilder.clear();
            RowBackgroundStruct struct = this.getCommonBackground(logicalPageBox, sheetLayout, row, tableContentProducer);
            if (!struct.failed) {
                Color commonBackgroundColor = struct.color;
                BorderEdge top = struct.topEdge;
                BorderEdge bottom = struct.bottomEdge;
                if (commonBackgroundColor != null) {
                    this.styleBuilder.append(StyleBuilder.CSSKeys.BACKGROUND_COLOR, HtmlColors.getColorString(commonBackgroundColor));
                }
                if (!BorderEdge.EMPTY.equals(top)) {
                    this.styleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_TOP, this.styleBuilder.printEdgeAsCSS(top));
                }
                if (!BorderEdge.EMPTY.equals(bottom)) {
                    this.styleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_BOTTOM, this.styleBuilder.printEdgeAsCSS(bottom));
                }
            }
            this.styleBuilder.append(StyleBuilder.CSSKeys.HEIGHT, this.styleBuilder.getPointConverter().format(this.fixLengthForSafari(rowHeight)), "pt");
            this.styleManager.updateStyle(this.styleBuilder, attrList);
        } else {
            attrList.setAttribute(XHTML_NAMESPACE, "style", "height: " + this.styleBuilder.getPointConverter().format(this.fixLengthForSafari(rowHeight)) + "pt");
        }
        return attrList;
    }

    private RowBackgroundStruct getCommonBackground(LogicalPageBox logicalPageBox, SheetLayout sheetLayout, int row, TableContentProducer tableContentProducer) {
        RowBackgroundStruct bg = new RowBackgroundStruct();
        bg.topEdge = BorderEdge.EMPTY;
        bg.bottomEdge = BorderEdge.EMPTY;
        int columnCount = sheetLayout.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            CellBackground backgroundAt;
            CellMarker.SectionType sectionType = tableContentProducer.getSectionType(row, col);
            RenderBox content = tableContentProducer.getContent(row, col);
            if (content == null) {
                RenderBox background = tableContentProducer.getBackground(row, col);
                backgroundAt = background != null ? this.cellBackgroundProducer.getBackgroundForBox(logicalPageBox, sheetLayout, col, row, 1, 1, false, sectionType, background) : this.cellBackgroundProducer.getBackgroundAt(logicalPageBox, sheetLayout, col, row, false, sectionType);
            } else {
                long contentOffset = tableContentProducer.getContentOffset(row, col);
                int colSpan = sheetLayout.getColSpan(col, content.getX() + content.getWidth());
                int rowSpan = sheetLayout.getRowSpan(row, content.getY() + content.getHeight() + contentOffset);
                backgroundAt = this.cellBackgroundProducer.getBackgroundForBox(logicalPageBox, sheetLayout, col, row, colSpan, rowSpan, false, sectionType, content);
            }
            if (backgroundAt == null) {
                bg.failed = true;
                bg.color = null;
                bg.topEdge = BorderEdge.EMPTY;
                bg.bottomEdge = BorderEdge.EMPTY;
                return bg;
            }
            boolean fail = false;
            if (col == 0) {
                bg.color = backgroundAt.getBackgroundColor();
                bg.topEdge = backgroundAt.getTop();
                bg.bottomEdge = backgroundAt.getBottom();
            } else {
                if (!ObjectUtilities.equal((Object)bg.color, (Object)backgroundAt.getBackgroundColor())) {
                    fail = true;
                }
                if (!ObjectUtilities.equal((Object)bg.topEdge, (Object)backgroundAt.getTop())) {
                    fail = true;
                }
                if (!ObjectUtilities.equal((Object)bg.bottomEdge, (Object)backgroundAt.getBottom())) {
                    fail = true;
                }
            }
            if (!BorderCorner.EMPTY.equals(backgroundAt.getBottomLeft())) {
                fail = true;
            }
            if (!BorderCorner.EMPTY.equals(backgroundAt.getBottomRight())) {
                fail = true;
            }
            if (!BorderCorner.EMPTY.equals(backgroundAt.getTopLeft())) {
                fail = true;
            }
            if (!BorderCorner.EMPTY.equals(backgroundAt.getTopRight())) {
                fail = true;
            }
            if (!fail) continue;
            bg.failed = true;
            bg.color = null;
            bg.topEdge = BorderEdge.EMPTY;
            bg.bottomEdge = BorderEdge.EMPTY;
            break;
        }
        return bg;
    }

    private AttributeList createSheetNameAttributes() {
        AttributeList tableAttrList = new AttributeList();
        String additionalStyleClass = this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.SheetNameClass");
        if (additionalStyleClass != null) {
            tableAttrList.setAttribute(XHTML_NAMESPACE, "class", additionalStyleClass);
        }
        return tableAttrList;
    }

    private AttributeList createTableAttributes(SheetLayout sheetLayout, LogicalPageBox logicalPageBox) {
        int noc = sheetLayout.getColumnCount();
        this.styleBuilder.clear();
        if (noc > 0 && !this.isProportionalColumnWidths()) {
            int width = (int)StrictGeomUtility.toExternalValue(sheetLayout.getCellWidth(0, noc));
            this.styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, width + "pt");
        } else {
            this.styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, "100%");
        }
        if (this.isTableRowBorderDefinition()) {
            this.styleBuilder.append(StyleBuilder.CSSKeys.BORDER_COLLAPSE, "collapse");
        }
        if (this.isEmptyCellsUseCSS()) {
            this.styleBuilder.append(StyleBuilder.CSSKeys.EMPTY_CELLS, "show");
        }
        if (this.isUseTableLayoutFixed()) {
            this.styleBuilder.append(StyleBuilder.CSSKeys.TABLE_LAYOUT, "fixed");
        }
        String additionalStyleClass = this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.StyleClass");
        AttributeList tableAttrList = new AttributeList();
        if (additionalStyleClass != null) {
            tableAttrList.setAttribute(XHTML_NAMESPACE, "class", additionalStyleClass);
        }
        tableAttrList.setAttribute(XHTML_NAMESPACE, "cellspacing", "0");
        tableAttrList.setAttribute(XHTML_NAMESPACE, "cellpadding", "0");
        HtmlPrinter.applyHtmlAttributes(logicalPageBox.getAttributes(), tableAttrList);
        this.styleManager.updateStyle(this.styleBuilder, tableAttrList);
        return tableAttrList;
    }

    public static void applyHtmlAttributes(ReportAttributeMap attributes, AttributeList attrList) {
        Object title;
        Object onMouseEnter;
        Object onMouseOut;
        Object onMouseUp;
        Object onMouseOver;
        Object onMouseMove;
        Object onMouseDown;
        Object onKeyUp;
        Object onKeyPressed;
        Object onKeyDown;
        Object onDblClick;
        Object onClick;
        Object styleClass;
        Object id;
        if (attributes == null) {
            throw new NullPointerException("Attributes must not be null");
        }
        if (attrList == null) {
            throw new NullPointerException();
        }
        Object name = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "name");
        if (name != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "name", String.valueOf(name));
        }
        if ((id = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "xml-id")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "id", String.valueOf(id));
        }
        if ((styleClass = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "class")) != null) {
            String styleClassAttr = attrList.getAttribute(XHTML_NAMESPACE, "class");
            if (styleClassAttr == null) {
                attrList.setAttribute(XHTML_NAMESPACE, "class", String.valueOf(styleClass));
            } else {
                attrList.setAttribute(XHTML_NAMESPACE, "class", styleClassAttr + ' ' + String.valueOf(styleClass));
            }
        }
        if ((onClick = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onclick")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onclick", String.valueOf(onClick));
        }
        if ((onDblClick = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "ondblclick")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "ondblclick", String.valueOf(onDblClick));
        }
        if ((onKeyDown = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onkeydown")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onkeydown", String.valueOf(onKeyDown));
        }
        if ((onKeyPressed = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onkeypressed")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onkeypressed", String.valueOf(onKeyPressed));
        }
        if ((onKeyUp = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onkeyup")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onkeyup", String.valueOf(onKeyUp));
        }
        if ((onMouseDown = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onmousedown")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onmousedown", String.valueOf(onMouseDown));
        }
        if ((onMouseMove = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onmousemove")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onmousemove", String.valueOf(onMouseMove));
        }
        if ((onMouseOver = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onmouseover")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onmouseover", String.valueOf(onMouseOver));
        }
        if ((onMouseUp = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onmouseup")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onmouseup", String.valueOf(onMouseUp));
        }
        if ((onMouseOut = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onmouseout")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onmouseout", String.valueOf(onMouseOut));
        }
        if ((onMouseEnter = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "onmouseenter")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "onmouseenter", String.valueOf(onMouseEnter));
        }
        if ((title = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "title")) != null) {
            attrList.setAttribute(XHTML_NAMESPACE, "title", String.valueOf(title));
        }
    }

    private void writeColumnDeclaration(SheetLayout sheetLayout) throws IOException {
        double colWidth;
        int width;
        int col;
        double totalWidth;
        String unit;
        if (sheetLayout == null) {
            throw new NullPointerException();
        }
        int colCount = sheetLayout.getColumnCount();
        int fullWidth = (int)StrictGeomUtility.toExternalValue(sheetLayout.getMaxWidth());
        String[] colWidths = new String[colCount];
        boolean proportionalColumnWidths = this.isProportionalColumnWidths();
        NumberFormat pointConverter = this.styleBuilder.getPointConverter();
        if (proportionalColumnWidths) {
            unit = "%";
            totalWidth = 0.0;
            for (col = 0; col < colCount; ++col) {
                width = (int)StrictGeomUtility.toExternalValue(sheetLayout.getCellWidth(col, col + 1));
                colWidth = this.fixLengthForSafari(Math.max(1.0, (double)width * 100.0 / (double)fullWidth));
                if (col == colCount - 1) {
                    colWidths[col] = pointConverter.format(100.0 - totalWidth);
                    continue;
                }
                totalWidth += colWidth;
                colWidths[col] = pointConverter.format(colWidth);
            }
        } else {
            unit = "pt";
            totalWidth = 0.0;
            for (col = 0; col < colCount; ++col) {
                width = (int)StrictGeomUtility.toExternalValue(sheetLayout.getCellWidth(col, col + 1));
                colWidth = this.fixLengthForSafari(Math.max(1, width));
                if (col == colCount - 1) {
                    colWidths[col] = pointConverter.format((double)fullWidth - totalWidth);
                    continue;
                }
                totalWidth += colWidth;
                colWidths[col] = pointConverter.format(colWidth);
            }
        }
        for (int col2 = 0; col2 < colCount; ++col2) {
            this.styleBuilder.clear();
            this.styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, colWidths[col2], unit);
            this.xmlWriter.writeTag(null, "col", "style", this.styleBuilder.toString(), true);
        }
    }

    public void print(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer, OutputProcessorMetaData metaData, boolean incremental) throws ContentProcessingException {
        block40: {
            try {
                SheetLayout sheetLayout = contentProducer.getSheetLayout();
                int startRow = contentProducer.getFinishedRows();
                int finishRow = contentProducer.getFilledRows();
                if (incremental && startRow == finishRow) {
                    return;
                }
                if (this.documentContentItem == null) {
                    String sheetName;
                    this.cellBackgroundProducer = new CellBackgroundProducer(metaData.isFeatureSupported(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE), metaData.isFeatureSupported(OutputProcessorFeature.UNALIGNED_PAGEBANDS));
                    this.configuration = metaData.getConfiguration();
                    this.allowRawLinkTargets = "true".equals(this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllowRawLinkTargets"));
                    this.copyExternalImages = "true".equals(this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.CopyExternalImages"));
                    this.documentContentItem = this.contentLocation.createItem(this.contentNameGenerator.generateName(null, "text/html"));
                    OutputStream out = this.documentContentItem.getOutputStream();
                    String encoding = this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
                    this.writer = new BufferedWriter(new OutputStreamWriter(out, encoding));
                    DefaultTagDescription td = new DefaultTagDescription();
                    td.setDefaultNamespace(XHTML_NAMESPACE);
                    td.setNamespaceHasCData(XHTML_NAMESPACE, true);
                    td.setNamespaceHasCData(XHTML_NAMESPACE, true);
                    td.setElementHasCData(XHTML_NAMESPACE, "body", false);
                    td.setElementHasCData(XHTML_NAMESPACE, "br", true);
                    td.setElementHasCData(XHTML_NAMESPACE, "col", false);
                    td.setElementHasCData(XHTML_NAMESPACE, "colgroup", false);
                    td.setElementHasCData(XHTML_NAMESPACE, "div", true);
                    td.setElementHasCData(XHTML_NAMESPACE, "head", false);
                    td.setElementHasCData(XHTML_NAMESPACE, "html", false);
                    td.setElementHasCData(XHTML_NAMESPACE, "img", true);
                    td.setElementHasCData(XHTML_NAMESPACE, "input", true);
                    td.setElementHasCData(XHTML_NAMESPACE, "meta", true);
                    td.setElementHasCData(XHTML_NAMESPACE, "p", true);
                    td.setElementHasCData(XHTML_NAMESPACE, "pre", true);
                    td.setElementHasCData(XHTML_NAMESPACE, "span", true);
                    td.setElementHasCData(XHTML_NAMESPACE, "style", false);
                    td.setElementHasCData(XHTML_NAMESPACE, "table", false);
                    td.setElementHasCData(XHTML_NAMESPACE, "tbody", false);
                    td.setElementHasCData(XHTML_NAMESPACE, "td", true);
                    td.setElementHasCData(XHTML_NAMESPACE, "tfoot", false);
                    td.setElementHasCData(XHTML_NAMESPACE, "th", false);
                    td.setElementHasCData(XHTML_NAMESPACE, "thead", false);
                    td.setElementHasCData(XHTML_NAMESPACE, "title", true);
                    td.setElementHasCData(XHTML_NAMESPACE, "tr", false);
                    if (!this.isCreateBodyFragment()) {
                        if (this.isInlineStylesRequested()) {
                            this.styleManager = new InlineStyleManager();
                            this.xmlWriter = new XmlWriter((Writer)this.writer, (TagDescription)td);
                            this.xmlWriter.addImpliedNamespace(XHTML_NAMESPACE, "");
                            this.xmlWriter.setHtmlCompatiblityMode(true);
                            this.writeCompleteHeader(this.xmlWriter, this.writer, contentProducer, logicalPage, null, null);
                        } else {
                            if (this.isExternalStyleSheetRequested()) {
                                this.styleFile = this.dataLocation.createItem(this.dataNameGenerator.generateName("style", "text/css"));
                                this.styleFileUrl = this.urlRewriter.rewrite((ContentEntity)this.documentContentItem, (ContentEntity)this.styleFile);
                            }
                            this.styleManager = new GlobalStyleManager();
                            if (!this.isForceBufferedWriting() && this.styleFile != null) {
                                this.xmlWriter = new XmlWriter((Writer)this.writer, (TagDescription)td);
                                this.xmlWriter.addImpliedNamespace(XHTML_NAMESPACE, "");
                                this.xmlWriter.setHtmlCompatiblityMode(true);
                                this.writeCompleteHeader(this.xmlWriter, this.writer, contentProducer, logicalPage, this.styleFileUrl, null);
                            } else {
                                this.bufferWriter = new MemoryStringWriter(524288);
                                this.xmlWriter = new XmlWriter((Writer)this.bufferWriter, (TagDescription)td);
                                this.xmlWriter.setAdditionalIndent(1);
                                this.xmlWriter.addImpliedNamespace(XHTML_NAMESPACE, "");
                                this.xmlWriter.setHtmlCompatiblityMode(true);
                            }
                        }
                        this.xmlWriter.writeTag(XHTML_NAMESPACE, "body", false);
                    } else {
                        this.styleManager = new InlineStyleManager();
                        this.xmlWriter = new XmlWriter((Writer)this.writer, (TagDescription)td);
                        this.xmlWriter.addImpliedNamespace(XHTML_NAMESPACE, "");
                        this.xmlWriter.setHtmlCompatiblityMode(true);
                    }
                    ReportAttributeMap map = logicalPage.getAttributes();
                    Object rawContent = map.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-content");
                    if (rawContent != null) {
                        this.xmlWriter.writeText(String.valueOf(rawContent));
                    }
                    if ("true".equals(metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.EnableSheetNameProcessing")) && (sheetName = contentProducer.getSheetName()) != null) {
                        this.xmlWriter.writeTag(XHTML_NAMESPACE, "h1", this.createSheetNameAttributes(), false);
                        this.xmlWriter.writeTextNormalized(sheetName, true);
                        this.xmlWriter.writeCloseTag();
                    }
                    this.xmlWriter.writeTag(XHTML_NAMESPACE, "table", this.createTableAttributes(sheetLayout, logicalPage), false);
                    this.writeColumnDeclaration(sheetLayout);
                }
                int colCount = sheetLayout.getColumnCount();
                boolean emptyCellsUseCSS = this.isEmptyCellsUseCSS();
                if (this.textExtractor == null) {
                    this.textExtractor = new HtmlTextExtractor(metaData, this.xmlWriter, this.styleManager, this);
                }
                for (int row = startRow; row < finishRow; ++row) {
                    this.xmlWriter.writeTag(XHTML_NAMESPACE, "tr", this.createRowAttributes(logicalPage, sheetLayout, row, contentProducer), false);
                    for (int col = 0; col < colCount; ++col) {
                        Object rawFooterContent;
                        RenderBox content = contentProducer.getContent(row, col);
                        CellMarker.SectionType sectionType = contentProducer.getSectionType(row, col);
                        if (content == null) {
                            StyleBuilder cellStyle;
                            RenderBox backgroundBox = contentProducer.getBackground(row, col);
                            CellBackground background = backgroundBox != null ? this.cellBackgroundProducer.getBackgroundForBox(logicalPage, sheetLayout, col, row, 1, 1, true, sectionType, backgroundBox) : this.cellBackgroundProducer.getBackgroundAt(logicalPage, sheetLayout, col, row, true, sectionType);
                            if (background == null) {
                                if (emptyCellsUseCSS) {
                                    this.xmlWriter.writeTag(XHTML_NAMESPACE, "td", true);
                                    continue;
                                }
                                AttributeList attrs = new AttributeList();
                                attrs.setAttribute(XHTML_NAMESPACE, "style", "font-size: 1pt");
                                this.xmlWriter.writeTag(XHTML_NAMESPACE, "td", attrs, false);
                                this.xmlWriter.writeText("&nbsp;");
                                this.xmlWriter.writeCloseTag();
                                continue;
                            }
                            String[] anchor = background.getAnchors();
                            if (anchor.length == 0 && emptyCellsUseCSS) {
                                cellStyle = this.createCellStyle(null, background, null, null);
                                AttributeList cellAttributes = this.createCellAttributes(1, 1, null, background, cellStyle);
                                this.xmlWriter.writeTag(XHTML_NAMESPACE, "td", cellAttributes, true);
                                continue;
                            }
                            cellStyle = this.createCellStyle(null, background, EMPTY_CELL_ATTRNAMES, EMPTY_CELL_ATTRVALS);
                            AttributeList cellAttributes = this.createCellAttributes(1, 1, null, background, cellStyle);
                            this.xmlWriter.writeTag(XHTML_NAMESPACE, "td", cellAttributes, false);
                            for (int i = 0; i < anchor.length; ++i) {
                                this.xmlWriter.writeTag(XHTML_NAMESPACE, "a", "name", anchor[i], true);
                            }
                            this.xmlWriter.writeText("&nbsp;");
                            this.xmlWriter.writeCloseTag();
                            continue;
                        }
                        if (!content.isCommited()) {
                            throw new InvalidReportStateException("Uncommited content encountered: " + row + ", " + col + ' ' + content);
                        }
                        long contentOffset = contentProducer.getContentOffset(row, col);
                        long colPos = sheetLayout.getXPosition(col);
                        long rowPos = sheetLayout.getYPosition(row);
                        if ((content.getX() != colPos || content.getY() + contentOffset != rowPos) && content.isFinishedTable()) continue;
                        int colSpan = sheetLayout.getColSpan(col, content.getX() + content.getWidth());
                        int rowSpan = sheetLayout.getRowSpan(row, content.getY() + content.getHeight() + contentOffset);
                        CellBackground realBackground = this.cellBackgroundProducer.getBackgroundForBox(logicalPage, sheetLayout, col, row, colSpan, rowSpan, true, sectionType, content);
                        StyleBuilder cellStyle = this.createCellStyle(content, realBackground, null, null);
                        AttributeList cellAttributes = this.createCellAttributes(colSpan, rowSpan, content, realBackground, cellStyle);
                        this.xmlWriter.writeTag(XHTML_NAMESPACE, "td", cellAttributes, false);
                        Object rawContent = content.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-content");
                        if (rawContent != null) {
                            this.xmlWriter.writeText(String.valueOf(rawContent));
                        }
                        if (realBackground != null) {
                            String[] anchors = realBackground.getAnchors();
                            for (int i = 0; i < anchors.length; ++i) {
                                String anchor = anchors[i];
                                this.xmlWriter.writeTag(XHTML_NAMESPACE, "a", "name", anchor, true);
                            }
                        }
                        if (!(Boolean.TRUE.equals(content.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "surpress-content")) || this.textExtractor.performOutput(content, cellStyle.toArray()) || emptyCellsUseCSS)) {
                            this.xmlWriter.writeText("&nbsp;");
                        }
                        if ((rawFooterContent = content.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-footer-content")) != null) {
                            this.xmlWriter.writeText(String.valueOf(rawFooterContent));
                        }
                        this.xmlWriter.writeCloseTag();
                        content.setFinishedTable(true);
                    }
                    this.xmlWriter.writeCloseTag();
                }
                if (incremental) break block40;
                this.performCloseFile(contentProducer, logicalPage);
                this.xmlWriter = null;
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to close writer instance", (Throwable)e);
                }
                this.textExtractor = null;
                this.writer = null;
                this.bufferWriter = null;
                this.documentContentItem = null;
            }
            catch (IOException ioe) {
                this.xmlWriter = null;
                try {
                    if (this.writer != null) {
                        this.writer.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.writer = null;
                this.bufferWriter = null;
                this.documentContentItem = null;
                this.styleFile = null;
                this.textExtractor = null;
                throw new ContentProcessingException("IOError while creating content", ioe);
            }
            catch (ContentIOException e) {
                this.xmlWriter = null;
                try {
                    if (this.writer != null) {
                        this.writer.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.writer = null;
                this.bufferWriter = null;
                this.documentContentItem = null;
                this.styleFile = null;
                this.textExtractor = null;
                throw new ContentProcessingException("Content-IOError while creating content", (Exception)((Object)e));
            }
            catch (URLRewriteException e) {
                try {
                    if (this.writer != null) {
                        this.writer.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.xmlWriter = null;
                this.writer = null;
                this.bufferWriter = null;
                this.documentContentItem = null;
                this.styleFile = null;
                this.textExtractor = null;
                throw new ContentProcessingException("Cannot create URL for external stylesheet", e);
            }
        }
    }

    private void writeCompleteHeader(XmlWriter docWriter, Writer writer, TableContentProducer contentProducer, LogicalPageBox logicalPage, String url, StyleManager inlineStyleSheet) throws IOException {
        String encoding = this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
        docWriter.writeXmlDeclaration(encoding);
        for (int i = 0; i < XHTML_HEADER.length; ++i) {
            docWriter.writeText(XHTML_HEADER[i]);
            docWriter.writeNewLine();
        }
        docWriter.writeTag(XHTML_NAMESPACE, "html", false);
        docWriter.writeTag(XHTML_NAMESPACE, "head", false);
        String title = this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Title");
        if (title != null) {
            docWriter.writeTag(XHTML_NAMESPACE, "title", false);
            docWriter.writeTextNormalized(title, false);
            docWriter.writeCloseTag();
        } else if (contentProducer.getSheetName() != null) {
            docWriter.writeTag(XHTML_NAMESPACE, "title", false);
            docWriter.writeTextNormalized(contentProducer.getSheetName(), true);
            docWriter.writeCloseTag();
        } else {
            docWriter.writeTag(XHTML_NAMESPACE, "title", false);
            docWriter.writeText(" ");
            docWriter.writeCloseTag();
        }
        this.writeMeta(docWriter, "subject", this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Subject"));
        this.writeMeta(docWriter, "author", this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Author"));
        this.writeMeta(docWriter, "keywords", this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Keywords"));
        this.writeMeta(docWriter, "generator", GENERATOR);
        AttributeList metaAttrs = new AttributeList();
        metaAttrs.setAttribute(XHTML_NAMESPACE, "http-equiv", "content-type");
        metaAttrs.setAttribute(XHTML_NAMESPACE, "content", "text/html; charset=" + encoding);
        docWriter.writeTag(XHTML_NAMESPACE, "meta", metaAttrs, true);
        if (url != null) {
            AttributeList attrList = new AttributeList();
            attrList.setAttribute(XHTML_NAMESPACE, "type", "text/css");
            attrList.setAttribute(XHTML_NAMESPACE, "rel", "stylesheet");
            attrList.setAttribute(XHTML_NAMESPACE, "href", url);
            docWriter.writeTag(XHTML_NAMESPACE, "link", attrList, true);
        } else if (inlineStyleSheet != null) {
            docWriter.writeTag(XHTML_NAMESPACE, "style", "type", "text/css", false);
            inlineStyleSheet.write(writer);
            docWriter.writeCloseTag();
        }
        ReportAttributeMap attributes = logicalPage.getAttributes();
        Object rawHeaderContent = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-header-content");
        if (rawHeaderContent != null) {
            docWriter.writeText(String.valueOf(rawHeaderContent));
        }
        docWriter.writeCloseTag();
    }

    private void performCloseFile(TableContentProducer contentProducer, LogicalPageBox logicalPageBox) throws IOException, ContentIOException {
        this.xmlWriter.writeCloseTag();
        Object rawFooterContent = logicalPageBox.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-footer-content");
        if (rawFooterContent != null) {
            this.xmlWriter.writeText(String.valueOf(rawFooterContent));
        }
        if (this.isCreateBodyFragment()) {
            this.xmlWriter.close();
            return;
        }
        if (this.styleFile != null) {
            String encoding = this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
            OutputStreamWriter styleOut = new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.styleFile.getOutputStream()), encoding);
            this.styleManager.write(styleOut);
            ((Writer)styleOut).flush();
            ((Writer)styleOut).close();
            if (!this.isForceBufferedWriting()) {
                this.xmlWriter.writeCloseTag();
                this.xmlWriter.writeCloseTag();
                this.xmlWriter.close();
                return;
            }
        }
        if (this.isInlineStylesRequested()) {
            this.xmlWriter.writeCloseTag();
            this.xmlWriter.writeCloseTag();
            this.xmlWriter.close();
            return;
        }
        XmlWriter docWriter = new XmlWriter((Writer)this.writer, this.xmlWriter.getTagDescription());
        docWriter.addImpliedNamespace(XHTML_NAMESPACE, "");
        docWriter.setHtmlCompatiblityMode(true);
        if (this.styleFile != null) {
            this.writeCompleteHeader(docWriter, this.writer, contentProducer, logicalPageBox, this.styleFileUrl, null);
        } else {
            this.writeCompleteHeader(docWriter, this.writer, contentProducer, logicalPageBox, null, this.styleManager);
        }
        this.xmlWriter.writeCloseTag();
        this.xmlWriter.flush();
        MemoryStringReader stringReader = this.bufferWriter.createReader();
        docWriter.writeStream((Reader)stringReader);
        stringReader.close();
        docWriter.writeCloseTag();
        docWriter.close();
    }

    private boolean isForceBufferedWriting() {
        return "true".equals(this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.ForceBufferedWriting"));
    }

    private void writeMeta(XmlWriter writer, String name, String value) throws IOException {
        if (value == null) {
            return;
        }
        AttributeList attrList = new AttributeList();
        attrList.setAttribute(XHTML_NAMESPACE, "name", name);
        attrList.setAttribute(XHTML_NAMESPACE, "content", value);
        writer.writeTag(XHTML_NAMESPACE, "meta", attrList, true);
    }

    private boolean isInlineStylesRequested() {
        return "true".equals(this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.InlineStyles"));
    }

    private boolean isExternalStyleSheetRequested() {
        if (this.isCreateBodyFragment()) {
            return false;
        }
        if (this.isInlineStylesRequested()) {
            return false;
        }
        if (this.dataLocation == null) {
            return false;
        }
        return "true".equals(this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.ExternalStyle", "true"));
    }

    public static StyleBuilder produceTextStyle(StyleBuilder styleBuilder, RenderBox box, boolean includeBorder, boolean fixLength, boolean useWhitespacePreWrap, boolean enableRoundBorderCorner, StyleBuilder.StyleCarrier[] parentElementStyle) {
        if (box == null) {
            throw new NullPointerException();
        }
        if (styleBuilder == null) {
            styleBuilder = new DefaultStyleBuilder();
        }
        styleBuilder.clear();
        FilterStyleBuilder filterStyleBuilder = new FilterStyleBuilder(styleBuilder, parentElementStyle);
        NumberFormat pointConverter = filterStyleBuilder.getPointConverter();
        StyleSheet styleSheet = box.getStyleSheet();
        Color textColor = (Color)styleSheet.getStyleProperty(ElementStyleKeys.PAINT);
        Color backgroundColor = (Color)styleSheet.getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR);
        if (includeBorder) {
            if (backgroundColor != null) {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.BACKGROUND_COLOR, HtmlColors.getColorString(backgroundColor));
            }
            BoxDefinition boxDefinition = box.getBoxDefinition();
            Border border = boxDefinition.getBorder();
            BorderEdge top = border.getTop();
            BorderEdge left = border.getLeft();
            BorderEdge bottom = border.getBottom();
            BorderEdge right = border.getRight();
            if (top.equals(left) && top.equals(right) && top.equals(bottom)) {
                if (!BorderEdge.EMPTY.equals(top)) {
                    styleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER, styleBuilder.printEdgeAsCSS(top));
                }
            } else {
                if (top != null && !BorderEdge.EMPTY.equals(top)) {
                    filterStyleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_TOP, filterStyleBuilder.printEdgeAsCSS(top));
                }
                if (left != null && !BorderEdge.EMPTY.equals(left)) {
                    filterStyleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_LEFT, filterStyleBuilder.printEdgeAsCSS(left));
                }
                if (bottom != null && !BorderEdge.EMPTY.equals(bottom)) {
                    filterStyleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_BOTTOM, filterStyleBuilder.printEdgeAsCSS(bottom));
                }
                if (right != null && !BorderEdge.EMPTY.equals(right)) {
                    filterStyleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_RIGHT, filterStyleBuilder.printEdgeAsCSS(right));
                }
            }
            if (enableRoundBorderCorner) {
                double blW = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH, 0.0));
                double blH = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT, 0.0));
                if (blW > 0.0 && blH > 0.0) {
                    filterStyleBuilder.append(StyleBuilder.CSSKeys.MOZ_BORDER_RADIUS_BOTTOM_LEFT, pointConverter.format(HtmlPrinter.fixLengthForSafari(blW, fixLength)) + "pt " + pointConverter.format(HtmlPrinter.fixLengthForSafari(blH, fixLength)) + "pt");
                    filterStyleBuilder.append(StyleBuilder.CSSKeys.BORDER_BOTTOM_LEFT_RADIUS, pointConverter.format(HtmlPrinter.fixLengthForSafari(blW, fixLength)) + "pt " + pointConverter.format(HtmlPrinter.fixLengthForSafari(blH, fixLength)) + "pt");
                }
                double brW = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH, 0.0));
                double brH = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT, 0.0));
                if (brW > 0.0 && brH > 0.0) {
                    filterStyleBuilder.append(StyleBuilder.CSSKeys.MOZ_BORDER_RADIUS_BOTTOM_RIGHT, pointConverter.format(HtmlPrinter.fixLengthForSafari(brW, fixLength)) + "pt " + pointConverter.format(HtmlPrinter.fixLengthForSafari(brH, fixLength)) + "pt");
                    filterStyleBuilder.append(StyleBuilder.CSSKeys.BORDER_BOTTOM_RIGHT_RADIUS, pointConverter.format(HtmlPrinter.fixLengthForSafari(brW, fixLength)) + "pt " + pointConverter.format(HtmlPrinter.fixLengthForSafari(brH, fixLength)) + "pt");
                }
                double tlW = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH, 0.0));
                double tlH = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT, 0.0));
                if (tlW > 0.0 && tlH > 0.0) {
                    filterStyleBuilder.append(StyleBuilder.CSSKeys.MOZ_BORDER_RADIUS_TOP_LEFT, pointConverter.format(HtmlPrinter.fixLengthForSafari(tlW, fixLength)) + "pt " + pointConverter.format(HtmlPrinter.fixLengthForSafari(tlH, fixLength)) + "pt");
                    filterStyleBuilder.append(StyleBuilder.CSSKeys.BORDER_TOP_LEFT_RADIUS, pointConverter.format(HtmlPrinter.fixLengthForSafari(tlW, fixLength)) + "pt " + pointConverter.format(HtmlPrinter.fixLengthForSafari(tlH, fixLength)) + "pt");
                }
                double trW = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH, 0.0));
                double trH = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT, 0.0));
                if (trW > 0.0 && trH > 0.0) {
                    filterStyleBuilder.append(StyleBuilder.CSSKeys.MOZ_BORDER_RADIUS_TOP_RIGHT, pointConverter.format(HtmlPrinter.fixLengthForSafari(trW, fixLength)) + "pt " + pointConverter.format(HtmlPrinter.fixLengthForSafari(trH, fixLength)) + "pt");
                    filterStyleBuilder.append(StyleBuilder.CSSKeys.BORDER_TOP_RIGHT_RADIUS, pointConverter.format(HtmlPrinter.fixLengthForSafari(trW, fixLength)) + "pt " + pointConverter.format(HtmlPrinter.fixLengthForSafari(trH, fixLength)) + "pt");
                }
            }
            long paddingTop = boxDefinition.getPaddingTop();
            long paddingLeft = boxDefinition.getPaddingLeft();
            long paddingBottom = boxDefinition.getPaddingBottom();
            long paddingRight = boxDefinition.getPaddingRight();
            if (paddingTop == paddingLeft && paddingTop == paddingRight && paddingTop == paddingBottom) {
                if (paddingTop > 0L) {
                    filterStyleBuilder.append(StyleBuilder.CSSKeys.PADDING, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue(paddingTop), fixLength)), "pt");
                }
            } else {
                if (paddingTop > 0L) {
                    filterStyleBuilder.append(StyleBuilder.CSSKeys.PADDING_TOP, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue(paddingTop), fixLength)), "pt");
                }
                if (paddingLeft > 0L) {
                    filterStyleBuilder.append(StyleBuilder.CSSKeys.PADDING_LEFT, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue(paddingLeft), fixLength)), "pt");
                }
                if (paddingBottom > 0L) {
                    filterStyleBuilder.append(StyleBuilder.CSSKeys.PADDING_BOTTOM, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue(paddingBottom), fixLength)), "pt");
                }
                if (paddingRight > 0L) {
                    filterStyleBuilder.append(StyleBuilder.CSSKeys.PADDING_RIGHT, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue(paddingRight), fixLength)), "pt");
                }
            }
        }
        if (textColor != null) {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.COLOR, HtmlColors.getColorString(textColor));
        }
        filterStyleBuilder.appendRaw(StyleBuilder.CSSKeys.FONT_FAMILY, HtmlPrinter.translateFontFamily(box));
        filterStyleBuilder.append(StyleBuilder.CSSKeys.FONT_SIZE, pointConverter.format(HtmlPrinter.fixLengthForSafari(styleSheet.getDoubleStyleProperty(TextStyleKeys.FONTSIZE, 0.0), fixLength)), "pt");
        if (styleSheet.getBooleanStyleProperty(TextStyleKeys.BOLD)) {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.FONT_WEIGHT, "bold");
        } else {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.FONT_WEIGHT, "normal");
        }
        if (styleSheet.getBooleanStyleProperty(TextStyleKeys.ITALIC)) {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.FONT_STYLE, "italic");
        } else {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.FONT_STYLE, "normal");
        }
        boolean underlined = styleSheet.getBooleanStyleProperty(TextStyleKeys.UNDERLINED);
        boolean strikeThrough = styleSheet.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH);
        if (underlined && strikeThrough) {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.TEXT_DECORATION, "underline line-through");
        } else if (strikeThrough) {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.TEXT_DECORATION, "line-through");
        }
        if (underlined) {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.TEXT_DECORATION, "underline");
        } else {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.TEXT_DECORATION, "none");
        }
        ElementAlignment align = (ElementAlignment)styleSheet.getStyleProperty(ElementStyleKeys.ALIGNMENT);
        filterStyleBuilder.append(StyleBuilder.CSSKeys.TEXT_ALIGN, HtmlPrinter.translateHorizontalAlignment(align));
        double wordSpacing = styleSheet.getDoubleStyleProperty(TextStyleKeys.WORD_SPACING, 0.0);
        filterStyleBuilder.append(StyleBuilder.CSSKeys.WORD_SPACING, pointConverter.format(HtmlPrinter.fixLengthForSafari(wordSpacing, fixLength)), "pt");
        double minLetterSpacing = styleSheet.getDoubleStyleProperty(TextStyleKeys.X_MIN_LETTER_SPACING, 0.0);
        double maxLetterSpacing = styleSheet.getDoubleStyleProperty(TextStyleKeys.X_MAX_LETTER_SPACING, 0.0);
        filterStyleBuilder.append(StyleBuilder.CSSKeys.LETTER_SPACING, pointConverter.format(HtmlPrinter.fixLengthForSafari(Math.min(minLetterSpacing, maxLetterSpacing), fixLength)), "pt");
        WhitespaceCollapse wsCollapse = (WhitespaceCollapse)styleSheet.getStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE);
        if (WhitespaceCollapse.PRESERVE.equals(wsCollapse)) {
            if (useWhitespacePreWrap) {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.WHITE_SPACE, "pre-wrap");
            } else {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.WHITE_SPACE, "pre");
            }
        } else if (WhitespaceCollapse.PRESERVE_BREAKS.equals(wsCollapse)) {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.WHITE_SPACE, "nowrap");
        } else {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.WHITE_SPACE, "normal");
        }
        return styleBuilder;
    }

    private static String translateFontFamily(RenderBox box) {
        String family = box.getStaticBoxLayoutProperties().getFontFamily();
        if ("Serif".equalsIgnoreCase(family)) {
            return "serif";
        }
        if ("Sans-serif".equalsIgnoreCase(family) || "SanSerif".equalsIgnoreCase(family) || "SansSerif".equalsIgnoreCase(family) || "Dialog".equalsIgnoreCase(family) || "DialogInput".equalsIgnoreCase(family)) {
            return "sans-serif";
        }
        if ("Monospaced".equalsIgnoreCase(family)) {
            return "monospace";
        }
        return '\"' + HtmlEncoderUtil.encodeCSS(family) + '\"';
    }

    public static String translateHorizontalAlignment(ElementAlignment ea) {
        if (ElementAlignment.JUSTIFY.equals(ea)) {
            return "justify";
        }
        if (ElementAlignment.RIGHT.equals(ea)) {
            return "right";
        }
        if (ElementAlignment.CENTER.equals(ea)) {
            return "center";
        }
        return "left";
    }

    @Override
    public void registerFailure(ResourceKey source) {
        this.knownResources.put(source, null);
    }

    @Override
    public void registerContent(ResourceKey source, String name) {
        this.knownResources.put(source, name);
    }

    @Override
    public boolean isRegistered(ResourceKey source) {
        return this.knownResources.containsKey(source);
    }

    @Override
    public String getRegisteredName(ResourceKey source) {
        String o = this.knownResources.get(source);
        if (o instanceof String) {
            return o;
        }
        return null;
    }

    private double fixLengthForSafari(double border) {
        return HtmlPrinter.fixLengthForSafari(border, this.safariLengthFix);
    }

    public static double fixLengthForSafari(double border, boolean safariLengthFix) {
        if (!safariLengthFix) {
            return border;
        }
        if (border == 0.0) {
            return 0.0;
        }
        return Math.max(1L, Math.round(border));
    }

    private static class RowBackgroundStruct {
        protected Color color;
        protected BorderEdge topEdge;
        protected BorderEdge bottomEdge;
        protected boolean failed;

        private RowBackgroundStruct() {
        }
    }

    private static class ImageData {
        private byte[] imageData;
        private String mimeType;
        private String originalFileName;

        private ImageData(byte[] imageData, String mimeType, String originalFileName) {
            if (imageData == null) {
                throw new NullPointerException();
            }
            if (mimeType == null) {
                throw new NullPointerException();
            }
            if (originalFileName == null) {
                throw new NullPointerException();
            }
            this.imageData = imageData;
            this.mimeType = mimeType;
            this.originalFileName = originalFileName;
        }

        public byte[] getImageData() {
            return this.imageData;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getOriginalFileName() {
            return this.originalFileName;
        }
    }
}

