/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderCorner;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.util.HtmlColors;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.util.HtmlEncoderUtil;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.base.util.StringBufferWriter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public final class DefaultStyleBuilder
implements StyleBuilder {
    public static final String INDENT = "    ";
    private LFUMap<BorderEdge, String> cachedBorderStyle;
    private LFUMap<BorderCorner, String> cachedCornerStyle;
    private String lineSeparator = StringUtils.getLineSeparator();
    private StringBuffer buffer;
    private StyleBuilder.StyleCarrier[] usedStyles;
    private NumberFormat pointConverter;
    private boolean safariLengthFix;

    public DefaultStyleBuilder() {
        this.cachedBorderStyle = new LFUMap(30);
        this.cachedCornerStyle = new LFUMap(30);
        this.buffer = new StringBuffer(100);
        this.usedStyles = new StyleBuilder.StyleCarrier[StyleBuilder.CSSKeys.values().length];
        if ("true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.SafariLengthHack"))) {
            this.pointConverter = new DecimalFormat("0", new DecimalFormatSymbols(Locale.US));
            this.safariLengthFix = true;
        } else {
            this.safariLengthFix = false;
            this.pointConverter = new DecimalFormat("0.####", new DecimalFormatSymbols(Locale.US));
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.usedStyles, null);
    }

    @Override
    public void append(StyleBuilder.CSSKeys key, String value) {
        StyleBuilder.StyleCarrier newCarrier;
        this.usedStyles[key.ordinal()] = newCarrier = new StyleBuilder.StyleCarrier(key, HtmlEncoderUtil.encodeCSS(value, this.prepareBuffer()), null);
    }

    @Override
    public void appendRaw(StyleBuilder.CSSKeys key, String value) {
        StyleBuilder.StyleCarrier newCarrier;
        this.usedStyles[key.ordinal()] = newCarrier = new StyleBuilder.StyleCarrier(key, value, null);
    }

    @Override
    public void append(StyleBuilder.CSSKeys key, String value, String unit) {
        StyleBuilder.StyleCarrier newCarrier;
        this.usedStyles[key.ordinal()] = newCarrier = new StyleBuilder.StyleCarrier(key, HtmlEncoderUtil.encodeCSS(value, this.prepareBuffer()), unit);
    }

    @Override
    public void append(StyleBuilder.CSSKeys key, String value, boolean replace) {
        StyleBuilder.StyleCarrier newCarrier;
        StyleBuilder.StyleCarrier stylePos;
        if (!replace && (stylePos = this.usedStyles[key.ordinal()]) != null) {
            return;
        }
        this.usedStyles[key.ordinal()] = newCarrier = new StyleBuilder.StyleCarrier(key, HtmlEncoderUtil.encodeCSS(value, this.prepareBuffer()), null);
    }

    @Override
    public void append(StyleBuilder.CSSKeys key, String value, String unit, boolean replace) {
        StyleBuilder.StyleCarrier newCarrier;
        StyleBuilder.StyleCarrier stylePos;
        if (!replace && (stylePos = this.usedStyles[key.ordinal()]) != null) {
            return;
        }
        this.usedStyles[key.ordinal()] = newCarrier = new StyleBuilder.StyleCarrier(key, HtmlEncoderUtil.encodeCSS(value, this.prepareBuffer()), unit);
    }

    private StringBuffer prepareBuffer() {
        this.buffer.delete(0, this.buffer.length());
        return this.buffer;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public void print(Writer writer, boolean compact) throws IOException {
        boolean first = true;
        for (StyleBuilder.StyleCarrier sc : this.usedStyles) {
            if (sc == null) continue;
            if (!first) {
                writer.write("; ");
            }
            if (!compact) {
                if (!first) {
                    writer.write(this.lineSeparator);
                }
                writer.write(INDENT);
            }
            writer.write(sc.getKey().getCssName());
            writer.write(": ");
            writer.write(sc.getValue());
            String unit = sc.getUnit();
            if (unit != null) {
                writer.write(unit);
            }
            first = false;
        }
    }

    @Override
    public String toString(boolean compact) {
        this.buffer.delete(0, this.buffer.length());
        StringBufferWriter writer = new StringBufferWriter(this.buffer);
        try {
            this.print((Writer)writer, compact);
        }
        catch (IOException e) {
            throw new IllegalStateException("How can a fully buffered writer cause a IO exception?");
        }
        return this.buffer.toString();
    }

    @Override
    public String printEdgeAsCSS(BorderEdge edge) {
        BorderStyle borderStyle = edge.getBorderStyle();
        long width = edge.getWidth();
        if (BorderStyle.NONE.equals(borderStyle) || width <= 0L) {
            return "none";
        }
        String cached = (String)this.cachedBorderStyle.get((Object)edge);
        if (cached != null) {
            return cached;
        }
        String value = this.pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue(width), this.safariLengthFix)) + "pt " + borderStyle.toString() + ' ' + HtmlColors.getColorString(edge.getColor());
        this.cachedBorderStyle.put((Object)edge, (Object)value);
        return value;
    }

    @Override
    public String printCornerAsCSS(BorderCorner edge) {
        String cached = (String)this.cachedCornerStyle.get((Object)edge);
        if (cached != null) {
            return cached;
        }
        String value = this.pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue(edge.getWidth()), this.safariLengthFix)) + "pt " + this.pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue(edge.getHeight()), this.safariLengthFix)) + "pt ";
        this.cachedCornerStyle.put((Object)edge, (Object)value);
        return value;
    }

    @Override
    public NumberFormat getPointConverter() {
        return this.pointConverter;
    }

    @Override
    public StyleBuilder.StyleCarrier[] toArray() {
        return (StyleBuilder.StyleCarrier[])this.usedStyles.clone();
    }

    @Override
    public boolean isEmpty() {
        for (StyleBuilder.StyleCarrier sc : this.usedStyles) {
            if (sc == null) continue;
            return false;
        }
        return true;
    }
}

