/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelColorProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.StaticExcelColorSupport;

public class DynamicExcelColorProducer
implements ExcelColorProducer {
    private short lastUsedColor = (short)8;
    private HSSFWorkbook workbook;
    private Map usedTripplets;

    public DynamicExcelColorProducer(HSSFWorkbook workbook) {
        if (workbook == null) {
            throw new NullPointerException();
        }
        this.workbook = workbook;
        this.usedTripplets = new HashMap();
    }

    public HSSFColor getColor(short index) {
        HSSFPalette palette = this.workbook.getCustomPalette();
        return palette.getColor(index);
    }

    @Override
    public short getNearestColor(Color awtColor) {
        if (this.lastUsedColor > 64) {
            return StaticExcelColorSupport.getNearestColor(awtColor, this.usedTripplets);
        }
        HSSFPalette palette = this.workbook.getCustomPalette();
        HSSFColor hssfColor = palette.findColor((byte)awtColor.getRed(), (byte)awtColor.getGreen(), (byte)awtColor.getBlue());
        if (hssfColor != null && hssfColor.getIndex() < this.lastUsedColor) {
            return hssfColor.getIndex();
        }
        palette.setColorAtIndex(this.lastUsedColor, (byte)awtColor.getRed(), (byte)awtColor.getGreen(), (byte)awtColor.getBlue());
        HSSFColor color = palette.getColor(this.lastUsedColor);
        this.usedTripplets.put(color.getHexString(), color);
        short s = this.lastUsedColor;
        this.lastUsedColor = (short)(s + 1);
        return s;
    }
}

