/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.DisplayAllFlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xml.internal.XmlDocumentWriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xml.internal.XmlTableOutputProcessorMetaData;

public class XmlTableOutputProcessor
extends AbstractTableOutputProcessor
implements PageableOutputProcessor {
    private List<PhysicalPageKey> physicalPages;
    private FlowSelector flowSelector;
    private OutputProcessorMetaData metaData;
    private OutputStream outputStream;
    private XmlDocumentWriter writer;

    public XmlTableOutputProcessor(OutputStream outputStream) {
        this(outputStream, new XmlTableOutputProcessorMetaData());
    }

    public XmlTableOutputProcessor(OutputStream outputStream, OutputProcessorMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException("MetaData must not be null");
        }
        if (outputStream == null) {
            throw new NullPointerException("OutputStream must not be null");
        }
        this.outputStream = outputStream;
        this.metaData = metaData;
        this.physicalPages = new ArrayList<PhysicalPageKey>();
        this.flowSelector = new DisplayAllFlowSelector();
    }

    @Override
    protected void processingPagesFinished() {
        super.processingPagesFinished();
        this.physicalPages = Collections.unmodifiableList(this.physicalPages);
    }

    @Override
    public int getPhysicalPageCount() {
        return this.physicalPages.size();
    }

    @Override
    public PhysicalPageKey getPhysicalPage(int page) {
        if (!this.isPaginationFinished()) {
            throw new IllegalStateException();
        }
        return this.physicalPages.get(page);
    }

    @Override
    protected LogicalPageKey createLogicalPage(int width, int height) {
        LogicalPageKey key = super.createLogicalPage(width, height);
        for (int h = 0; h < key.getHeight(); ++h) {
            for (int w = 0; w < key.getWidth(); ++w) {
                this.physicalPages.add(key.getPage(w, h));
            }
        }
        return key;
    }

    @Override
    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        if (this.writer != null) {
            try {
                this.metaData.commit();
                this.writer.close();
            }
            catch (IOException e) {
                throw new InvalidReportStateException("Failed to close writer");
            }
        }
    }

    @Override
    protected void processTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer) throws ContentProcessingException {
        try {
            if (this.writer == null) {
                this.writer = new XmlDocumentWriter(this.outputStream, this.metaData);
                this.writer.open();
            }
            this.writer.processTableContent(logicalPage, this.metaData, contentProducer);
        }
        catch (Exception e) {
            throw new ContentProcessingException("Failed to generate PDF document", e);
        }
    }

    @Override
    protected FlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    @Override
    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }
}

