/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xml.internal;

import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.fonts.FontMappingUtility;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class XmlTableOutputProcessorMetaData
extends AbstractOutputProcessorMetaData {
    public static final OutputProcessorFeature.BooleanOutputProcessorFeature WRITE_RESOURCEKEYS = new OutputProcessorFeature.BooleanOutputProcessorFeature("xml.write-resourcekeys");
    public static final int PAGINATION_NONE = 0;
    public static final int PAGINATION_MANUAL = 1;
    public static final int PAGINATION_FULL = 2;
    private int paginationMode;

    public XmlTableOutputProcessorMetaData() {
        this(0);
    }

    public XmlTableOutputProcessorMetaData(int paginationMode) {
        this(paginationMode, (FontRegistry)new AWTFontRegistry());
    }

    public XmlTableOutputProcessorMetaData(int paginationMode, FontRegistry fontRegistry) {
        super((FontStorage)new DefaultFontStorage(fontRegistry));
        this.paginationMode = paginationMode;
        this.setFamilyMapping(null, "Helvetica");
    }

    @Override
    public void initialize(Configuration configuration) {
        super.initialize(configuration);
        this.addFeature(OutputProcessorFeature.FAST_FONTRENDERING);
        this.addFeature(OutputProcessorFeature.BACKGROUND_IMAGE);
        this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        this.addFeature(OutputProcessorFeature.SPACING_SUPPORTED);
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xml.AssumeOverflowX"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_X);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xml.AssumeOverflowY"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_Y);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xml.ShapeAsContent"))) {
            this.addFeature(AbstractTableOutputProcessor.SHAPES_CONTENT);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xml.WriteResourceKeys"))) {
            this.addFeature(WRITE_RESOURCEKEYS);
        }
        if (this.paginationMode == 2) {
            this.addFeature(OutputProcessorFeature.PAGEBREAKS);
        } else if (this.paginationMode == 1) {
            this.addFeature(OutputProcessorFeature.PAGEBREAKS);
            this.addFeature(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        } else {
            this.addFeature(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        }
    }

    @Override
    public String getNormalizedFontFamilyName(String name) {
        String mappedName = super.getNormalizedFontFamilyName(name);
        if (FontMappingUtility.isSerif((String)mappedName)) {
            return "Times";
        }
        if (FontMappingUtility.isSansSerif((String)mappedName)) {
            return "Helvetica";
        }
        if (FontMappingUtility.isCourier((String)mappedName)) {
            return "Courier";
        }
        if (FontMappingUtility.isSymbol((String)mappedName)) {
            return "Symbol";
        }
        return mappedName;
    }

    @Override
    public String getExportDescriptor() {
        switch (this.paginationMode) {
            case 2: {
                return "table/xml+pagination";
            }
            case 1: {
                return "table/xml+flow";
            }
        }
        return "table/xml+stream";
    }
}

