/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.ElementReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleElementWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Locator;

public class BundleElementRegistry {
    private static final BundleElementRegistry instance = new BundleElementRegistry();
    private HashMap<String, Class<? extends BundleElementWriteHandler>> writeHandlers = new HashMap();
    private AttributeMap<Class<? extends ElementReadHandler>> readHandlers = new AttributeMap();
    private static final Log logger = LogFactory.getLog(BundleElementRegistry.class);

    public static BundleElementRegistry getInstance() {
        return instance;
    }

    private BundleElementRegistry() {
    }

    public BundleElementWriteHandler getWriteHandler(ReportElement element) throws BundleWriterException {
        return this.getWriteHandler(element.getElementType().getMetaData().getName());
    }

    public BundleElementWriteHandler getWriteHandler(String element) throws BundleWriterException {
        try {
            Class<? extends BundleElementWriteHandler> c = this.writeHandlers.get(element);
            if (c != null) {
                return c.newInstance();
            }
            throw new BundleWriterException("Failed to locate write-handler for [" + element + "]");
        }
        catch (BundleWriterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BundleWriterException("Failed to instantiate write-handler for [" + element + "]");
        }
    }

    public ElementReadHandler getReadHandler(String namespace, String tagName, Locator locator) throws ParseException {
        try {
            Class attribute = (Class)this.readHandlers.getAttribute(namespace, tagName);
            if (attribute != null) {
                return (ElementReadHandler)attribute.newInstance();
            }
            return null;
        }
        catch (Exception e) {
            throw new ParseException("Failed to instantiate element-read-handler for [" + namespace + "|" + tagName + "]", locator);
        }
    }

    public void register(String namespace, String tagName, Class<? extends ElementReadHandler> readHandler) {
        if (readHandler == null) {
            throw new IllegalStateException();
        }
        if (namespace == null) {
            throw new IllegalStateException();
        }
        if (tagName == null) {
            throw new IllegalStateException();
        }
        this.readHandlers.setAttribute(namespace, tagName, readHandler);
    }

    public void register(String elementType, Class<? extends BundleElementWriteHandler> writeHandler) {
        if (writeHandler == null) {
            return;
        }
        this.writeHandlers.put(elementType, writeHandler);
    }
}

