/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.data;

import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.data.AbstractParameterReadHandler;
import org.pentaho.reporting.engine.classic.core.parameters.AbstractParameter;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.StaticListParameter;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ListParameterReadHandler
extends AbstractParameterReadHandler {
    private String query;
    private String keyColumnName;
    private String valueColumnName;
    private ListParameter result;
    private boolean strictValueCheck;
    private boolean allowMultiSelection;

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.query = attrs.getValue(this.getUri(), "query");
        this.keyColumnName = attrs.getValue(this.getUri(), "key-column");
        if (this.query != null && this.keyColumnName == null) {
            throw new ParseException("Required parameter 'key-column' is missing.", this.getLocator());
        }
        this.valueColumnName = attrs.getValue(this.getUri(), "value-column");
        if (this.valueColumnName == null) {
            this.valueColumnName = this.keyColumnName;
        }
        this.strictValueCheck = "true".equals(attrs.getValue(this.getUri(), "strict-values"));
        this.allowMultiSelection = "true".equals(attrs.getValue(this.getUri(), "allow-multi-selection"));
    }

    protected void doneParsing() {
        AbstractParameter result = this.query != null ? new DefaultListParameter(this.query, this.keyColumnName, this.valueColumnName, this.getName(), this.allowMultiSelection, this.strictValueCheck, this.getType()) : new StaticListParameter(this.getName(), this.allowMultiSelection, this.strictValueCheck, this.getType());
        result.setMandatory(this.isMandatory());
        result.setDefaultValue(this.getDefaultValue());
        this.applyAttributes(result);
        this.result = result;
    }

    public Object getObject() throws SAXException {
        return this.result;
    }
}

