/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import java.io.IOException;
import java.util.Date;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ClassicEngineInfo;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentMetaData;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class BundleMetaFileWriter
implements BundleWriterHandler {
    @Override
    public int getProcessingOrder() {
        return 100000;
    }

    @Override
    public String writeReport(WriteableDocumentBundle bundle, BundleWriterState state) throws IOException, BundleWriterException {
        if (state == null) {
            throw new NullPointerException();
        }
        if (bundle == null) {
            throw new NullPointerException();
        }
        WriteableDocumentMetaData writeableMetaData = bundle.getWriteableDocumentMetaData();
        String version = ClassicEngineInfo.getInstance().getName() + ' ' + ClassicEngineInfo.getInstance().getVersion();
        writeableMetaData.setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "generator", (Object)version);
        Date currentDate = new Date();
        if (writeableMetaData.getBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "creation-date") == null) {
            writeableMetaData.setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "creation-date", (Object)currentDate);
        }
        writeableMetaData.setBundleAttribute("http://purl.org/dc/elements/1.1/", "date", (Object)currentDate);
        MasterReport masterReport = state.getMasterReport();
        Object visibleFlag = masterReport.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/pentaho", "visible");
        if (Boolean.FALSE.equals(visibleFlag)) {
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "visible", (Object)"false");
        } else {
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "visible", (Object)"true");
        }
        this.writeVersionMarker(writeableMetaData, masterReport);
        return null;
    }

    private void writeVersionMarker(WriteableDocumentMetaData writeableMetaData, MasterReport masterReport) {
        int releasePatch;
        int releaseMinor;
        int releaseMajor = ParserUtil.parseInt((String)ClassicEngineInfo.getInstance().getReleaseMajor(), (int)-1);
        if (ClassicEngineBoot.computeVersionId(releaseMajor, releaseMinor = ParserUtil.parseInt((String)ClassicEngineInfo.getInstance().getReleaseMinor(), (int)-1), releasePatch = ParserUtil.parseInt((String)ClassicEngineInfo.getInstance().getReleaseMilestone(), (int)-1)) > 0) {
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.major", (Object)releaseMajor);
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.minor", (Object)releaseMinor);
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.patch", (Object)releasePatch);
        } else {
            Integer reportCompatibility;
            Configuration configuration = masterReport.getConfiguration();
            if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.designtime.PreserveOriginalCompatibilitySettingInTrunk")) && (reportCompatibility = masterReport.getCompatibilityLevel()) != null && reportCompatibility > 0) {
                int patch = reportCompatibility % 1000;
                int minor = reportCompatibility / 1000 % 1000;
                int major = reportCompatibility / 1000000;
                writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.major", (Object)major);
                writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.minor", (Object)minor);
                writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.patch", (Object)patch);
                return;
            }
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.major", (Object)999);
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.minor", (Object)999);
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.patch", (Object)999);
        }
    }
}

