/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterHandlerRegistry;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterUtilities;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.ExpressionWriterUtility;
import org.pentaho.reporting.engine.classic.core.parameters.AbstractParameter;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultReportParameterValidator;
import org.pentaho.reporting.engine.classic.core.parameters.ListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.PlainParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterValidator;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class DataDefinitionFileWriter
implements BundleWriterHandler {
    @Override
    public int getProcessingOrder() {
        return 100000;
    }

    @Override
    public String writeReport(WriteableDocumentBundle bundle, BundleWriterState state) throws IOException, BundleWriterException {
        SubReport subreport;
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        BundleWriterState contentState = new BundleWriterState(state, state.getReport(), "datadefinition.xml");
        BufferedOutputStream outputStream = new BufferedOutputStream(bundle.createEntry(contentState.getFileName(), "text/xml"));
        DefaultTagDescription tagDescription = BundleWriterHandlerRegistry.getInstance().createWriterTagDescription();
        XmlWriter writer = new XmlWriter((Writer)new OutputStreamWriter((OutputStream)outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        writer.writeXmlDeclaration("UTF-8");
        AttributeList rootAttributes = new AttributeList();
        rootAttributes.addNamespaceDeclaration("", "http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0");
        writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "data-definition", rootAttributes, false);
        this.writeParameterDefinitions(contentState, writer);
        AbstractReportDefinition report = contentState.getReport();
        String query = report.getQuery();
        int queryLimit = report.getQueryLimit();
        int timeout = report.getQueryTimeout();
        AttributeList dataSourceAtts = new AttributeList();
        if (query != null) {
            dataSourceAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "report-query", query);
        }
        dataSourceAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "limit", String.valueOf(queryLimit));
        dataSourceAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "timout", String.valueOf(timeout));
        if (report instanceof MasterReport) {
            MasterReport masterReport = (MasterReport)report;
            String dataSourceDefFile = DataDefinitionFileWriter.writeDataFactory(bundle, contentState, masterReport.getDataFactory());
            String relativePath = IOUtils.getInstance().createRelativePath(dataSourceDefFile, contentState.getFileName());
            dataSourceAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "ref", relativePath);
        } else if (report instanceof SubReport && (subreport = (SubReport)report).getDataFactory() != null) {
            String dataSourceDefFile = DataDefinitionFileWriter.writeDataFactory(bundle, contentState, subreport.getDataFactory());
            String relativePath = IOUtils.getInstance().createRelativePath(dataSourceDefFile, contentState.getFileName());
            dataSourceAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "ref", relativePath);
        }
        writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "data-source", dataSourceAtts, true);
        ExpressionWriterUtility.writeDataExpressions(bundle, contentState, writer);
        writer.writeCloseTag();
        writer.close();
        return contentState.getFileName();
    }

    private void writeParameterDefinitions(BundleWriterState state, XmlWriter writer) throws IOException, BundleWriterException {
        AbstractReportDefinition report = state.getReport();
        if (report instanceof SubReport) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "parameter-mapping", false);
            SubReport subReport = (SubReport)report;
            ParameterMapping[] inputMappings = subReport.getInputMappings();
            for (int i = 0; i < inputMappings.length; ++i) {
                ParameterMapping mapping = inputMappings[i];
                AttributeList attList = new AttributeList();
                attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "name", mapping.getName());
                attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "alias", mapping.getAlias());
                writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "input-parameter", attList, true);
            }
            ParameterMapping[] exportMappings = subReport.getExportMappings();
            for (int i = 0; i < exportMappings.length; ++i) {
                ParameterMapping mapping = exportMappings[i];
                AttributeList attList = new AttributeList();
                attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "name", mapping.getName());
                attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "alias", mapping.getAlias());
                writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "export-parameter", attList, true);
            }
            writer.writeCloseTag();
            return;
        }
        if (report instanceof MasterReport) {
            MasterReport masterReport = (MasterReport)report;
            ReportParameterDefinition definition = masterReport.getParameterDefinition();
            ReportParameterValidator reportParameterValidator = definition.getValidator();
            AttributeList attList = new AttributeList();
            if (!DefaultReportParameterValidator.class.equals(reportParameterValidator.getClass())) {
                attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "validator", reportParameterValidator.getClass().getName());
            }
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "parameter-definition", attList, false);
            DataDefinitionFileWriter.writeMasterReportParameters(writer, definition);
            writer.writeCloseTag();
        }
    }

    private static HashSet writeMasterReportParameters(XmlWriter writer, ReportParameterDefinition definition) throws BundleWriterException, IOException {
        HashSet<String> parameters = new HashSet<String>();
        ParameterDefinitionEntry[] parameterDefinitions = definition.getParameterDefinitions();
        for (int i = 0; i < parameterDefinitions.length; ++i) {
            ParameterDefinitionEntry entry = parameterDefinitions[i];
            if (entry instanceof PlainParameter) {
                DataDefinitionFileWriter.writePlainParameter(writer, (PlainParameter)entry);
            } else if (entry instanceof ListParameter) {
                DataDefinitionFileWriter.writeListSelectionParameter(writer, (ListParameter)entry);
            }
            parameters.add(entry.getName());
        }
        return parameters;
    }

    private static void writePlainParameter(XmlWriter writer, PlainParameter plainParameter) throws BundleWriterException, IOException {
        String[] namespaces;
        if (StringUtils.isEmpty((String)plainParameter.getName())) {
            throw new BundleWriterException("Cannot write a unnamed parameter entry.");
        }
        AttributeList paramAttrs = new AttributeList();
        paramAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "name", plainParameter.getName());
        paramAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "mandatory", String.valueOf(plainParameter.isMandatory()));
        paramAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "type", plainParameter.getValueType().getName());
        Object defaultValue = plainParameter.getDefaultValue();
        if (defaultValue != null) {
            try {
                String valAsString = ConverterRegistry.toAttributeValue(defaultValue);
                if (!StringUtils.isEmpty((String)valAsString)) {
                    paramAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "default-value", valAsString);
                }
            }
            catch (BeanException e) {
                throw new BundleWriterException("Unable to convert parameter default-value to string for parameter '" + plainParameter.getName() + '\'');
            }
        }
        if ((namespaces = plainParameter.getParameterAttributeNamespaces()).length == 0) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "plain-parameter", paramAttrs, true);
        } else {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "plain-parameter", paramAttrs, false);
            for (int j = 0; j < namespaces.length; ++j) {
                String namespace = namespaces[j];
                String[] names = plainParameter.getParameterAttributeNames(namespace);
                for (int k = 0; k < names.length; ++k) {
                    String name = names[k];
                    String value = plainParameter.getParameterAttribute(namespace, name);
                    if (StringUtils.isEmpty((String)value)) continue;
                    AttributeList attrsAttr = new AttributeList();
                    attrsAttr.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "namespace", namespace);
                    attrsAttr.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "name", name);
                    writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "attribute", attrsAttr, false);
                    writer.writeTextNormalized(value, false);
                    writer.writeCloseTag();
                }
            }
            writer.writeCloseTag();
        }
    }

    private static void writeListSelectionParameter(XmlWriter writer, ListParameter parameter) throws BundleWriterException, IOException {
        String[] namespaces;
        Object defaultValue;
        if (StringUtils.isEmpty((String)parameter.getName())) {
            throw new BundleWriterException("Cannot write a unnamed parameter entry.");
        }
        AttributeList paramAttrs = new AttributeList();
        paramAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "name", parameter.getName());
        paramAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "allow-multi-selection", String.valueOf(parameter.isAllowMultiSelection()));
        paramAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "strict-values", String.valueOf(parameter.isStrictValueCheck()));
        paramAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "mandatory", String.valueOf(parameter.isMandatory()));
        paramAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "type", parameter.getValueType().getName());
        if (parameter instanceof DefaultListParameter) {
            DefaultListParameter defaultListParameter = (DefaultListParameter)parameter;
            if (!StringUtils.isEmpty((String)defaultListParameter.getQueryName())) {
                paramAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "query", defaultListParameter.getQueryName());
            }
            if (!StringUtils.isEmpty((String)defaultListParameter.getKeyColumn())) {
                paramAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "key-column", defaultListParameter.getKeyColumn());
            }
            if (!StringUtils.isEmpty((String)defaultListParameter.getTextColumn())) {
                paramAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "value-column", defaultListParameter.getTextColumn());
            }
        }
        if ((defaultValue = ((AbstractParameter)((Object)parameter)).getDefaultValue()) != null) {
            try {
                String valAsString = ConverterRegistry.toAttributeValue(defaultValue);
                if (!StringUtils.isEmpty((String)valAsString)) {
                    paramAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "default-value", valAsString);
                }
            }
            catch (BeanException e) {
                throw new BundleWriterException("Unable to convert parameter default-value to string for parameter '" + parameter.getName() + '\'');
            }
        }
        if ((namespaces = parameter.getParameterAttributeNamespaces()).length == 0) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "list-parameter", paramAttrs, true);
        } else {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "list-parameter", paramAttrs, false);
            for (int j = 0; j < namespaces.length; ++j) {
                String namespace = namespaces[j];
                String[] names = parameter.getParameterAttributeNames(namespace);
                for (int k = 0; k < names.length; ++k) {
                    String name = names[k];
                    String value = ((AbstractParameter)((Object)parameter)).getParameterAttribute(namespace, name);
                    if (StringUtils.isEmpty((String)value)) continue;
                    AttributeList attrsAttr = new AttributeList();
                    attrsAttr.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "namespace", namespace);
                    attrsAttr.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "name", name);
                    writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "attribute", attrsAttr, false);
                    writer.writeTextNormalized(value, false);
                    writer.writeCloseTag();
                }
            }
            writer.writeCloseTag();
        }
    }

    public static String writeDataFactory(WriteableDocumentBundle bundle, BundleWriterState state, DataFactory df) throws IOException, BundleWriterException {
        BundleDataFactoryWriterHandler writerHandler = BundleWriterUtilities.lookupWriteHandler(df);
        if (writerHandler == null) {
            throw new BundleWriterException("Unable to find writer-handler for data-factory " + df.getClass());
        }
        String file = writerHandler.writeDataFactory(bundle, df, state);
        if (file == null) {
            throw new BundleWriterException("Data-factory writer did not create a file for " + df.getClass());
        }
        return file;
    }
}

