/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.states.LayoutProcess;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.datarow.ExpressionEventHelper;
import org.pentaho.reporting.engine.classic.core.states.datarow.InlineDataRowRuntime;
import org.pentaho.reporting.engine.classic.core.states.datarow.LevelStorage;
import org.pentaho.reporting.engine.classic.core.states.datarow.OutputFunctionLevelStorage;

public class InitialLayoutProcess
extends ExpressionEventHelper
implements LayoutProcess {
    private static final StructureFunction[] EMPTY_FUNCTIONS = new StructureFunction[0];
    private InlineDataRowRuntime inlineDataRowRuntime;
    private OutputFunction outputFunction;
    private boolean outputFunctionIsPageListener;

    public InitialLayoutProcess(OutputFunction outputFunction) {
        if (outputFunction == null) {
            throw new NullPointerException();
        }
        this.outputFunction = outputFunction;
        this.outputFunctionIsPageListener = outputFunction instanceof PageEventListener;
    }

    @Override
    public LayoutProcess getParent() {
        return null;
    }

    @Override
    public boolean isPageListener() {
        return this.outputFunctionIsPageListener;
    }

    @Override
    public OutputFunction getOutputFunction() {
        return this.outputFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart(ReportState state) throws ReportProcessingException {
        ExpressionRuntime oldRuntime;
        if (this.inlineDataRowRuntime == null) {
            this.inlineDataRowRuntime = new InlineDataRowRuntime();
        }
        this.inlineDataRowRuntime.setState(state);
        OutputFunction outputFunction = this.getOutputFunction();
        if (outputFunction != null) {
            oldRuntime = outputFunction.getRuntime();
            outputFunction.setRuntime(this.inlineDataRowRuntime);
        } else {
            oldRuntime = null;
        }
        try {
            if (outputFunction != null) {
                outputFunction.restart(state);
            }
        }
        finally {
            if (outputFunction != null) {
                outputFunction.setRuntime(oldRuntime);
            }
        }
    }

    @Override
    public StructureFunction[] getCollectionFunctions() {
        return EMPTY_FUNCTIONS;
    }

    @Override
    public LayoutProcess deriveForStorage() {
        try {
            InitialLayoutProcess lp = (InitialLayoutProcess)super.clone();
            lp.inlineDataRowRuntime = null;
            lp.outputFunction = this.outputFunction.deriveForStorage();
            return lp;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public LayoutProcess deriveForPagebreak() {
        try {
            InitialLayoutProcess lp = (InitialLayoutProcess)super.clone();
            lp.inlineDataRowRuntime = null;
            lp.outputFunction = this.outputFunction.deriveForPagebreak();
            return lp;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public Object clone() {
        try {
            InitialLayoutProcess lp = (InitialLayoutProcess)super.clone();
            lp.inlineDataRowRuntime = null;
            lp.outputFunction = (OutputFunction)this.outputFunction.clone();
            return lp;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException(cne);
        }
    }

    @Override
    protected int getRunLevelCount() {
        return 1;
    }

    @Override
    protected LevelStorage getRunLevel(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new OutputFunctionLevelStorage(-2, this.outputFunction, this.outputFunctionIsPageListener);
    }

    @Override
    protected ExpressionRuntime getRuntime() {
        return this.inlineDataRowRuntime;
    }

    @Override
    public void fireReportEvent(ReportEvent event) {
        if (this.inlineDataRowRuntime == null) {
            this.inlineDataRowRuntime = new InlineDataRowRuntime();
        }
        ReportState state = this.inlineDataRowRuntime.getState();
        this.inlineDataRowRuntime.setState(event.getState());
        try {
            int pageEventMask = 1026;
            if ((event.getType() & 0x402) == 0 && (event.getType() & 0x8000) == 32768) {
                this.fireGroupBodyFinishedEvent(event);
            } else {
                super.fireReportEvent(event);
            }
        }
        catch (InvalidReportStateException exception) {
            throw exception;
        }
        catch (Throwable t) {
            throw new InvalidReportStateException("Failed to fire report event for sub-layout-process", t);
        }
        finally {
            this.inlineDataRowRuntime.setState(state);
        }
    }

    private void fireGroupBodyFinishedEvent(ReportEvent event) {
        if (event.getLevel() != -2) {
            return;
        }
        ExpressionRuntime runtime = this.getRuntime();
        OutputFunction expression = this.getOutputFunction();
        boolean deepTraversing = event.isDeepTraversing();
        if (deepTraversing && !expression.isDeepTraversing()) {
            return;
        }
        ExpressionRuntime oldRuntime = expression.getRuntime();
        expression.setRuntime(runtime);
        try {
            expression.groupBodyFinished(event);
            this.evaluateSingleExpression(expression);
        }
        catch (InvalidReportStateException rse) {
            throw rse;
        }
        catch (Exception ex) {
            this.evaluateToNull(expression);
        }
        expression.setRuntime(oldRuntime);
    }
}

