/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.crosstab;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.crosstab.DimensionNode;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class SortedMergeCrosstabSpecification
implements CrosstabSpecification {
    private ArrayList<Object[]> entries;
    private ArrayList<DimensionNode> currentRow;
    private DimensionNode rootNode;
    private HashMap<DimensionNode, DimensionNode> existingNodes;
    private String[] columnSet;
    private String[] rowSet;
    private ReportStateKey key;
    private int rowCount;

    public SortedMergeCrosstabSpecification(ReportStateKey key, String[] dimensionColumnSet, String[] rowColumnSet) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (dimensionColumnSet == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.columnSet = (String[])dimensionColumnSet.clone();
        this.rowSet = (String[])rowColumnSet.clone();
        this.entries = new ArrayList();
        this.currentRow = new ArrayList();
        this.existingNodes = new HashMap();
        this.rootNode = new DimensionNode(new Object[0], -1);
        this.rowCount = -1;
    }

    @Override
    public int indexOf(int start, Object[] key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException();
        }
        int size = this.entries.size();
        for (int i = start; i < size; ++i) {
            Object[] objects = this.entries.get(i);
            if (!ObjectUtilities.equalArray((Object[])key, (Object[])objects)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String[] getColumnDimensionNames() {
        return (String[])this.columnSet.clone();
    }

    @Override
    public String[] getRowDimensionNames() {
        return (String[])this.rowSet.clone();
    }

    @Override
    public ReportStateKey getKey() {
        return this.key;
    }

    @Override
    public void startRow() {
        this.currentRow.clear();
        ++this.rowCount;
    }

    @Override
    public void endRow() {
        boolean modified = false;
        if (this.currentRow.size() > 0) {
            for (int i = 1; i < this.currentRow.size(); ++i) {
                DimensionNode dimensionNode = this.currentRow.get(i);
                if (!dimensionNode.addParent(this.currentRow.get(i - 1))) continue;
                modified = true;
            }
            if (this.currentRow.get(0).addParent(this.rootNode)) {
                modified = true;
            }
        }
        if (modified) {
            for (DimensionNode node : this.existingNodes.keySet()) {
                node.rebalance();
            }
        }
    }

    @Override
    public void endCrosstab() {
        Object[] dimensionNodes = this.existingNodes.keySet().toArray(new DimensionNode[this.existingNodes.size()]);
        Arrays.sort(dimensionNodes);
        this.entries.clear();
        for (int i = 0; i < dimensionNodes.length; ++i) {
            Object node = dimensionNodes[i];
            this.entries.add(((DimensionNode)node).getData());
        }
    }

    @Override
    public void add(DataRow dataRow) {
        DimensionNode node;
        if (this.columnSet.length == 0) {
            return;
        }
        Object[] newKey = new Object[this.columnSet.length];
        for (int i = 0; i < this.columnSet.length; ++i) {
            String columnName = this.columnSet[i];
            newKey[i] = dataRow.get(columnName);
        }
        if (!this.currentRow.isEmpty() && Arrays.equals((node = this.currentRow.get(this.currentRow.size() - 1)).getData(), newKey)) {
            return;
        }
        node = this.createUniqueNode(newKey);
        if (this.currentRow.contains(node)) {
            throw new InvalidReportStateException("Unsorted column dimension data within a single row-dimension instance.");
        }
        this.currentRow.add(node);
    }

    private DimensionNode createUniqueNode(Object[] data) {
        DimensionNode dimensionNode = new DimensionNode(data, this.rowCount);
        DimensionNode existing = this.existingNodes.get(dimensionNode);
        if (existing != null) {
            return existing;
        }
        this.existingNodes.put(dimensionNode, dimensionNode);
        return dimensionNode;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Object[] getKeyAt(int column) {
        Object[] data = this.entries.get(column);
        return (Object[])data.clone();
    }
}

