/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import java.util.ArrayList;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.states.LengthLimitingTableModel;
import org.pentaho.reporting.engine.classic.core.states.QueryDataRowWrapper;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.datarow.EmptyTableModel;
import org.pentaho.reporting.engine.classic.core.states.datarow.ExpressionDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.GlobalMasterRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.ImportedVariablesDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.ReportDataRow;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.libraries.base.util.FastStack;

public final class DefaultFlowController {
    private MasterDataRow dataRow;
    private boolean advanceRequested;
    private FastStack<Integer> expressionsStack;
    private FastStack<ReportDataContext> dataContextStack;
    private String exportDescriptor;
    private ProcessingContext reportContext;
    private ReportParameterValues parameters;
    private boolean storedAdvanceRequested;

    public DefaultFlowController(ProcessingContext reportContext, DataSchemaDefinition schemaDefinition, ReportParameterValues parameters) throws ReportDataFactoryException {
        if (reportContext == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        if (schemaDefinition == null) {
            throw new NullPointerException();
        }
        this.reportContext = reportContext;
        this.exportDescriptor = reportContext.getExportDescriptor();
        this.expressionsStack = new FastStack(10);
        this.dataContextStack = new FastStack(10);
        this.advanceRequested = false;
        this.parameters = parameters;
        this.dataRow = GlobalMasterRow.createReportRow(reportContext, schemaDefinition, new ParameterDataRow(parameters));
    }

    private DefaultFlowController(DefaultFlowController fc, MasterDataRow dataRow) {
        if (dataRow == null) {
            throw new NullPointerException();
        }
        this.reportContext = fc.reportContext;
        this.exportDescriptor = fc.exportDescriptor;
        this.dataContextStack = fc.dataContextStack.clone();
        this.expressionsStack = fc.expressionsStack.clone();
        this.advanceRequested = fc.advanceRequested;
        this.storedAdvanceRequested = fc.storedAdvanceRequested;
        this.dataRow = dataRow;
        this.parameters = fc.parameters;
    }

    public void requireStructuralProcessing() {
        this.dataRow.requireStructuralProcessing();
    }

    public DefaultFlowController derive() {
        return new DefaultFlowController(this, this.dataRow.derive());
    }

    public DefaultFlowController performAdvance() {
        if (this.dataRow.isAdvanceable() && !this.advanceRequested) {
            DefaultFlowController fc = new DefaultFlowController(this, this.dataRow);
            fc.advanceRequested = true;
            return fc;
        }
        return this;
    }

    public DefaultFlowController performCommit() {
        if (this.isAdvanceRequested()) {
            DefaultFlowController fc = new DefaultFlowController(this, this.dataRow);
            fc.dataRow = this.dataRow.advance();
            fc.advanceRequested = false;
            return fc;
        }
        return this;
    }

    public MasterDataRow getMasterRow() {
        return this.dataRow;
    }

    public boolean isAdvanceRequested() {
        return this.advanceRequested;
    }

    public DefaultFlowController performQuery(DataFactory dataFactory, String query, int queryLimit, int queryTimeout, ResourceBundleFactory resourceBundleFactory) throws ReportDataFactoryException {
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        if (resourceBundleFactory == null) {
            throw new NullPointerException();
        }
        MasterDataRow masterRowWithoutData = this.dataRow.deriveSubDataRow(this.reportContext, dataFactory, new ParameterDataRow(this.parameters), resourceBundleFactory);
        TableModel tableData = this.performQueryData(masterRowWithoutData.getDataFactory(), query, queryLimit, queryTimeout, masterRowWithoutData.getGlobalView());
        MasterDataRow masterRow = masterRowWithoutData.deriveWithQueryData(tableData);
        DefaultFlowController fc = new DefaultFlowController(this, masterRow);
        fc.dataContextStack.push((Object)new ReportDataContext(this.advanceRequested));
        fc.dataRow = masterRow;
        fc.dataRow.resetDataSchema();
        return fc;
    }

    private TableModel performQueryData(DataFactory dataFactory, String query, int queryLimit, int queryTimeout, DataRow parameters) throws ReportDataFactoryException {
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        if (query == null) {
            return new EmptyTableModel();
        }
        TableModel reportData = dataFactory.queryData(query, new QueryDataRowWrapper(parameters, queryLimit, queryTimeout));
        if (queryLimit > 0 && reportData.getRowCount() > queryLimit) {
            return new LengthLimitingTableModel(reportData, queryLimit);
        }
        return reportData;
    }

    public DefaultFlowController performInitSubreport(DataFactory dataFactory, ParameterMapping[] inputParameters, ResourceBundleFactory resourceBundleFactory) {
        MasterDataRow subReportDataRow;
        ParameterDataRow parameterRow;
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        if (inputParameters == null) {
            throw new NullPointerException();
        }
        if (resourceBundleFactory == null) {
            throw new NullPointerException();
        }
        if (this.isGlobalImportOrExport(inputParameters)) {
            parameterRow = new ParameterDataRow(this.dataRow.getGlobalView());
            subReportDataRow = this.dataRow.deriveSubDataRow(this.reportContext, dataFactory, parameterRow, resourceBundleFactory);
        } else {
            parameterRow = new ParameterDataRow(inputParameters, this.dataRow.getGlobalView());
            subReportDataRow = this.dataRow.deriveSubDataRow(this.reportContext, dataFactory, parameterRow, resourceBundleFactory);
        }
        DefaultFlowController fc = new DefaultFlowController(this, subReportDataRow);
        fc.dataContextStack.push((Object)new ReportDataContext(this.advanceRequested));
        fc.dataRow = subReportDataRow;
        fc.dataRow.resetDataSchema();
        return fc;
    }

    public DefaultFlowController performSubReportQuery(String query, int queryLimit, int queryTimeout, ParameterMapping[] outputParameters) throws ReportDataFactoryException {
        if (outputParameters == null) {
            throw new NullPointerException();
        }
        MasterDataRow subReportDataRow = this.dataRow;
        TableModel tableData = this.performQueryData(subReportDataRow.getDataFactory(), query, queryLimit, queryTimeout, subReportDataRow.getGlobalView());
        MasterDataRow masterRow = subReportDataRow.deriveWithQueryData(tableData);
        if (this.isGlobalImportOrExport(outputParameters)) {
            if ("true".equals(this.reportContext.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.EnableGlobalSubReportImports"))) {
                masterRow.getParentDataRow().setImportedDataRow(new ImportedVariablesDataRow(masterRow));
            } else {
                masterRow.getParentDataRow().setImportedDataRow(new ImportedVariablesDataRow(masterRow, this.filterGlobalImport(outputParameters)));
            }
        } else {
            masterRow.getParentDataRow().setImportedDataRow(new ImportedVariablesDataRow(masterRow, outputParameters));
        }
        DefaultFlowController fc = new DefaultFlowController(this, masterRow);
        fc.dataContextStack.push((Object)new ReportDataContext(this.advanceRequested));
        fc.dataRow = masterRow;
        fc.dataRow.resetDataSchema();
        return fc;
    }

    private ParameterMapping[] filterGlobalImport(ParameterMapping[] parameterMapping) {
        ArrayList<ParameterMapping> filteredList = new ArrayList<ParameterMapping>(parameterMapping.length);
        for (int i = 0; i < parameterMapping.length; ++i) {
            ParameterMapping mapping = parameterMapping[i];
            if ("*".equals(mapping.getName()) && "*".equals(mapping.getAlias())) continue;
            filteredList.add(mapping);
        }
        return filteredList.toArray(new ParameterMapping[filteredList.size()]);
    }

    private boolean isGlobalImportOrExport(ParameterMapping[] inputParameters) {
        for (int i = 0; i < inputParameters.length; ++i) {
            ParameterMapping inputParameter = inputParameters[i];
            if (!"*".equals(inputParameter.getName()) || !"*".equals(inputParameter.getAlias())) continue;
            return true;
        }
        return false;
    }

    public DefaultFlowController activateExpressions(Expression[] expressions, boolean preserveState) throws ReportProcessingException {
        if (expressions == null) {
            throw new NullPointerException();
        }
        MasterDataRow dataRow = this.dataRow.derive();
        ExpressionDataRow edr = dataRow.getExpressionDataRow();
        edr.pushExpressions(expressions, preserveState);
        dataRow.resetDataSchema();
        DefaultFlowController fc = new DefaultFlowController(this, dataRow);
        Integer exCount = IntegerCache.getInteger(expressions.length);
        fc.expressionsStack.push((Object)exCount);
        return fc;
    }

    public DefaultFlowController deactivateExpressions() {
        Integer counter = (Integer)this.expressionsStack.peek();
        int counterRaw = counter;
        if (counterRaw == 0) {
            DefaultFlowController fc = new DefaultFlowController(this, this.dataRow);
            fc.expressionsStack.pop();
            return fc;
        }
        MasterDataRow dataRow = this.dataRow.derive();
        ExpressionDataRow edr = dataRow.getExpressionDataRow();
        DefaultFlowController fc = new DefaultFlowController(this, dataRow);
        fc.expressionsStack.pop();
        edr.popExpressions(counterRaw);
        dataRow.resetDataSchema();
        return fc;
    }

    public DefaultFlowController performReturnFromQuery() {
        ReportDataRow reportDataRow = this.dataRow.getReportDataRow();
        if (reportDataRow == null) {
            return this;
        }
        MasterDataRow innerDr = this.dataRow.deriveWithReturnFromQuery();
        DefaultFlowController fc = new DefaultFlowController(this, innerDr);
        ReportDataContext context = (ReportDataContext)fc.dataContextStack.pop();
        fc.dataRow = this.dataRow.getParentDataRow();
        fc.dataRow = fc.dataRow.derive();
        fc.advanceRequested = context.isAdvanceRequested();
        innerDr.resetDataSchema();
        return fc;
    }

    public DefaultFlowController performReturnFromSubreport() {
        MasterDataRow innerDrFromQuery = this.dataRow.deriveWithReturnFromQuery();
        DefaultFlowController fc = new DefaultFlowController(this, innerDrFromQuery);
        fc.advanceRequested = ((ReportDataContext)fc.dataContextStack.pop()).isAdvanceRequested();
        DefaultFlowController fc2 = new DefaultFlowController(fc, this.dataRow.getParentDataRow().derive());
        fc2.advanceRequested = ((ReportDataContext)fc2.dataContextStack.pop()).isAdvanceRequested();
        return fc2;
    }

    public DefaultFlowController performClearExportedParameters() {
        MasterDataRow masterDataRow = this.dataRow.clearExportedParameters();
        if (masterDataRow == this.dataRow) {
            return this;
        }
        return new DefaultFlowController(this, this.dataRow.clearExportedParameters());
    }

    public String getExportDescriptor() {
        return this.exportDescriptor;
    }

    public ProcessingContext getReportContext() {
        return this.reportContext;
    }

    public DefaultFlowController fireReportEvent(ReportEvent event) {
        this.dataRow.fireReportEvent(event);
        return this;
    }

    public DataSchema getDataSchema() {
        return this.dataRow.getDataSchema();
    }

    public DataFactory getDataFactory() {
        return this.dataRow.getDataFactory();
    }

    public DefaultFlowController startCrosstabMode(CrosstabSpecification crosstabSpecification) {
        MasterDataRow dataRow = this.dataRow.startCrosstabMode(crosstabSpecification);
        return new DefaultFlowController(this, dataRow);
    }

    public DefaultFlowController endCrosstabMode() {
        MasterDataRow dataRow = this.dataRow.endCrosstabMode();
        return new DefaultFlowController(this, dataRow);
    }

    public DefaultFlowController resetRowCursor() {
        MasterDataRow dataRow = this.dataRow.resetRowCursor();
        return new DefaultFlowController(this, dataRow);
    }

    public DefaultFlowController restart() {
        GlobalMasterRow innerDr = this.dataRow.rebuild();
        return new DefaultFlowController(this, innerDr);
    }

    public DefaultFlowController updateDataSchema(DataSchemaDefinition dataSchemaDefinition) {
        return new DefaultFlowController(this, this.dataRow.updateDataSchema(dataSchemaDefinition));
    }

    public DefaultFlowController refreshDataRow() {
        this.dataRow.refresh();
        return this;
    }

    public boolean isCrosstabActive() {
        return this.dataRow.isCrosstabActive();
    }

    public DefaultFlowController recordCrosstabRowState() {
        MasterDataRow dataRow = this.dataRow.recordCrosstabRowState();
        DefaultFlowController flowController = new DefaultFlowController(this, dataRow);
        flowController.storedAdvanceRequested = this.advanceRequested;
        return flowController;
    }

    public DefaultFlowController clearRecordedCrosstabRowState() {
        MasterDataRow dataRow = this.dataRow.clearRecordedCrosstabRowState();
        return new DefaultFlowController(this, dataRow);
    }

    public DefaultFlowController replayStoredCrosstabRowState() {
        MasterDataRow dataRow = this.dataRow.replayStoredCrosstabRowState();
        DefaultFlowController flowController = new DefaultFlowController(this, dataRow);
        flowController.advanceRequested = this.storedAdvanceRequested;
        return flowController;
    }

    private static class ReportDataContext {
        private boolean advanceRequested;

        protected ReportDataContext(boolean advanceRequested) {
            this.advanceRequested = advanceRequested;
        }

        public boolean isAdvanceRequested() {
            return this.advanceRequested;
        }
    }
}

