/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.states.CascadingDataFactory;
import org.pentaho.reporting.engine.classic.core.states.EmptyDataFactory;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.datarow.DataProcessor;
import org.pentaho.reporting.engine.classic.core.states.datarow.DataRowEventHelper;
import org.pentaho.reporting.engine.classic.core.states.datarow.ExpressionDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.FastGlobalView;
import org.pentaho.reporting.engine.classic.core.states.datarow.ImportedVariablesDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.ProcessingDataSchemaCompiler;
import org.pentaho.reporting.engine.classic.core.states.datarow.ReportDataRow;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;

public final class GlobalMasterRow
implements MasterDataRow {
    private GlobalMasterRow parentRow;
    private FastGlobalView globalView;
    private DataFactory dataFactory;
    private DataSchemaDefinition schemaDefinition;
    private ProcessingDataSchemaCompiler schemaCompiler;
    private DataSchema dataSchema;
    private ResourceBundleFactory resourceBundleFactory;
    private OutputProcessorMetaData outputProcessorMetaData;
    private ReportEnvironmentDataRow environmentDataRow;
    private ParameterDataRow parameterDataRow;
    private ExpressionDataRow expressionDataRow;
    private ImportedVariablesDataRow importedDataRow;
    private DataProcessor paddingData;
    private DataProcessor storedPaddingData;
    private FastGlobalView storedGlobalView;

    private GlobalMasterRow() {
    }

    public static GlobalMasterRow createReportRow(ProcessingContext reportContext, DataSchemaDefinition schemaDefinition, ParameterDataRow parameterDataRow) {
        if (reportContext == null) {
            throw new NullPointerException();
        }
        if (schemaDefinition == null) {
            throw new NullPointerException();
        }
        if (parameterDataRow == null) {
            throw new NullPointerException();
        }
        GlobalMasterRow gmr = new GlobalMasterRow();
        gmr.globalView = new FastGlobalView();
        gmr.paddingData = new DataProcessor();
        gmr.expressionDataRow = new ExpressionDataRow(gmr.globalView, gmr, reportContext);
        gmr.schemaDefinition = schemaDefinition;
        gmr.dataFactory = new EmptyDataFactory();
        gmr.resourceBundleFactory = reportContext.getResourceBundleFactory();
        gmr.outputProcessorMetaData = reportContext.getOutputProcessorMetaData();
        DefaultDataAttributeContext dac = new DefaultDataAttributeContext(gmr.outputProcessorMetaData, gmr.getResourceBundleFactory().getLocale());
        gmr.schemaCompiler = new ProcessingDataSchemaCompiler(schemaDefinition, dac, reportContext.getResourceManager(), null);
        gmr.dataSchema = null;
        gmr.setEnvironmentDataRow(new ReportEnvironmentDataRow(reportContext.getEnvironment()));
        gmr.setParameterDataRow(parameterDataRow);
        return gmr;
    }

    @Override
    public void requireStructuralProcessing() {
        this.expressionDataRow.setIncludeStructuralProcessing(true);
    }

    @Override
    public MasterDataRow deriveSubDataRow(ProcessingContext reportContext, DataFactory reportFactory, ParameterDataRow parameterDataRow, ResourceBundleFactory resourceBundleFactory) {
        if (reportContext == null) {
            throw new NullPointerException();
        }
        if (reportFactory == null) {
            throw new NullPointerException();
        }
        if (resourceBundleFactory == null) {
            throw new NullPointerException();
        }
        if (parameterDataRow == null) {
            throw new NullPointerException();
        }
        GlobalMasterRow gmr = new GlobalMasterRow();
        gmr.outputProcessorMetaData = this.outputProcessorMetaData;
        gmr.schemaDefinition = this.schemaDefinition;
        gmr.schemaCompiler = this.schemaCompiler;
        gmr.globalView = new FastGlobalView();
        gmr.expressionDataRow = new ExpressionDataRow(gmr.globalView, gmr, reportContext);
        gmr.expressionDataRow.setIncludeStructuralProcessing(this.expressionDataRow.isIncludeStructuralProcessing());
        gmr.parentRow = this;
        gmr.dataSchema = null;
        gmr.resourceBundleFactory = resourceBundleFactory;
        gmr.paddingData = new DataProcessor();
        CascadingDataFactory dataFactory = new CascadingDataFactory();
        dataFactory.add(reportFactory);
        dataFactory.add(this.dataFactory);
        gmr.dataFactory = dataFactory;
        gmr.setEnvironmentDataRow(this.environmentDataRow);
        gmr.setParameterDataRow(parameterDataRow);
        return gmr;
    }

    @Override
    public MasterDataRow deriveWithQueryData(TableModel tableData) {
        if (tableData == null) {
            throw new NullPointerException();
        }
        GlobalMasterRow derived = this.derive();
        derived.paddingData.setReportDataRow(new ReportDataRow(tableData), derived.globalView);
        derived.dataSchema = null;
        return derived;
    }

    @Override
    public MasterDataRow deriveWithReturnFromQuery() {
        GlobalMasterRow derived = this.derive();
        derived.paddingData.clearReportDataRow(derived.globalView);
        derived.setParameterDataRow(null);
        derived.dataSchema = null;
        return derived;
    }

    @Override
    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    @Override
    public DataSchema getDataSchema() {
        if (this.dataSchema == null) {
            try {
                this.dataSchema = this.schemaCompiler.compile(this, this.environmentDataRow.getEnvironment());
            }
            catch (ReportDataFactoryException re) {
                throw new IllegalStateException("Failed to compile data-schema - aborting report processing", re);
            }
        }
        return this.dataSchema;
    }

    @Override
    public ReportDataRow getReportDataRow() {
        return this.paddingData.getReportDataRow();
    }

    @Override
    public ExpressionDataRow getExpressionDataRow() {
        return this.expressionDataRow;
    }

    private void setEnvironmentDataRow(ReportEnvironmentDataRow environmentDataRow) {
        if (this.environmentDataRow != null) {
            DataRowEventHelper.removeAllColumns(this.environmentDataRow, this.globalView);
        }
        this.environmentDataRow = environmentDataRow;
        if (environmentDataRow != null) {
            DataRowEventHelper.addColumns(environmentDataRow, this.globalView);
        }
        this.dataSchema = null;
    }

    @Override
    public ParameterDataRow getParameterDataRow() {
        return this.parameterDataRow;
    }

    private void setParameterDataRow(ParameterDataRow parameterDataRow) {
        if (this.parameterDataRow != null) {
            DataRowEventHelper.removeAllColumns(this.parameterDataRow, this.globalView);
        }
        this.parameterDataRow = parameterDataRow;
        if (parameterDataRow != null) {
            DataRowEventHelper.addColumns(this.parameterDataRow, this.globalView);
        }
        this.dataSchema = null;
    }

    @Override
    public DataRow getGlobalView() {
        return this.globalView;
    }

    @Override
    public boolean isAdvanceable() {
        return this.paddingData.isAdvanceable(this.globalView);
    }

    @Override
    public GlobalMasterRow derive() {
        GlobalMasterRow o = new GlobalMasterRow();
        o.storedGlobalView = this.storedGlobalView;
        o.storedPaddingData = this.storedPaddingData;
        o.environmentDataRow = this.environmentDataRow;
        o.outputProcessorMetaData = this.outputProcessorMetaData;
        o.dataFactory = this.dataFactory;
        o.dataSchema = this.dataSchema;
        o.schemaCompiler = this.schemaCompiler;
        o.schemaDefinition = this.schemaDefinition;
        o.globalView = this.globalView.derive();
        o.parameterDataRow = this.parameterDataRow;
        o.paddingData = this.paddingData.derive();
        o.resourceBundleFactory = this.resourceBundleFactory;
        o.expressionDataRow = this.expressionDataRow.derive(o.globalView, o, false);
        if (this.parentRow != null) {
            o.parentRow = this.parentRow.derive();
        }
        o.importedDataRow = this.importedDataRow;
        return o;
    }

    @Override
    public void setImportedDataRow(ImportedVariablesDataRow dataRow) {
        if (this.importedDataRow != null) {
            DataRowEventHelper.removeAllColumns(this.importedDataRow, this.globalView);
        }
        this.importedDataRow = dataRow;
        if (this.importedDataRow != null) {
            DataRowEventHelper.addColumns(this.importedDataRow, this.globalView);
        }
        this.dataSchema = null;
    }

    @Override
    public MasterDataRow getParentDataRow() {
        return this.parentRow;
    }

    @Override
    public MasterDataRow advance() {
        return this.advanceRecursively(false, null);
    }

    @Override
    public GlobalMasterRow advanceRecursively(boolean deepTraversingOnly, MasterDataRow subReportRow) {
        GlobalMasterRow dataRow = new GlobalMasterRow();
        dataRow.storedPaddingData = this.storedPaddingData;
        dataRow.storedGlobalView = this.storedGlobalView;
        dataRow.environmentDataRow = this.environmentDataRow;
        dataRow.outputProcessorMetaData = this.outputProcessorMetaData;
        dataRow.globalView = !deepTraversingOnly ? this.globalView.advance() : this.globalView.derive();
        dataRow.dataSchema = this.dataSchema;
        dataRow.dataFactory = this.dataFactory;
        dataRow.schemaCompiler = this.schemaCompiler;
        dataRow.schemaDefinition = this.schemaDefinition;
        dataRow.resourceBundleFactory = this.resourceBundleFactory;
        dataRow.paddingData = this.paddingData.advance(deepTraversingOnly, dataRow.globalView);
        if (this.parameterDataRow != null) {
            dataRow.parameterDataRow = this.parameterDataRow;
            DataRowEventHelper.refreshDataRow(dataRow.parameterDataRow, dataRow.globalView);
        }
        if (this.expressionDataRow != null) {
            dataRow.expressionDataRow = this.expressionDataRow.derive(dataRow.globalView, dataRow, true);
        }
        if (this.parentRow != null) {
            dataRow.parentRow = this.parentRow.advanceRecursively(true, dataRow);
        }
        if (this.importedDataRow != null) {
            if (subReportRow != null) {
                dataRow.importedDataRow = this.importedDataRow.refresh(subReportRow.getGlobalView(), subReportRow.getDataSchema());
                DataRowEventHelper.refreshDataRow(dataRow.importedDataRow, dataRow.globalView);
            } else {
                dataRow.importedDataRow = this.importedDataRow;
                DataRowEventHelper.refreshDataRow(dataRow.importedDataRow, dataRow.globalView);
            }
        }
        dataRow.refresh();
        dataRow.globalView.validateChangedFlags();
        return dataRow;
    }

    @Override
    public void fireReportEvent(ReportEvent event) {
        if (this.expressionDataRow != null) {
            this.expressionDataRow.fireReportEvent(event);
        }
        if ((event.getType() & 0x8000000) == 0x8000000) {
            return;
        }
        if (this.parentRow != null) {
            ReportState parentState = event.getState().getParentSubReportState();
            ReportEvent deepEvent = parentState == null ? event : new ReportEvent(parentState, event.getState(), event.getType() | 0x4000000);
            this.parentRow.fireReportEvent(deepEvent);
            if (this.parentRow.importedDataRow != null) {
                this.parentRow.importedDataRow = this.parentRow.importedDataRow.refresh(this.getGlobalView(), this.getDataSchema());
                DataRowEventHelper.refreshDataRow(this.parentRow.importedDataRow, this.parentRow.globalView);
            }
        }
    }

    @Override
    public MasterDataRow startCrosstabMode(CrosstabSpecification crosstabSpecification) {
        GlobalMasterRow retval = this.derive();
        retval.paddingData = this.paddingData.startCrosstabMode(crosstabSpecification, retval.globalView);
        return retval;
    }

    @Override
    public MasterDataRow endCrosstabMode() {
        GlobalMasterRow retval = this.derive();
        retval.paddingData = this.paddingData.endCrosstabMode();
        return retval;
    }

    @Override
    public MasterDataRow resetRowCursor() {
        GlobalMasterRow retval = this.derive();
        retval.paddingData = this.paddingData.resetRowCursor();
        return retval;
    }

    @Override
    public MasterDataRow clearExportedParameters() {
        if (this.importedDataRow == null) {
            return this;
        }
        GlobalMasterRow derived = this.derive();
        derived.setImportedDataRow(null);
        derived.resetDataSchema();
        return derived;
    }

    @Override
    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    @Override
    public void resetDataSchema() {
        this.dataSchema = null;
    }

    @Override
    public GlobalMasterRow rebuild() {
        if (this.globalView.getColumnNames().length == 0) {
            return this;
        }
        if (this.parentRow != null) {
            throw new IllegalStateException("This should be at the beginning of the master-report processing. No parent allowed.");
        }
        if (this.paddingData.getReportDataRow() != null) {
            throw new IllegalStateException("This should be at the beginning of the master-report processing. No report-data allowed.");
        }
        GlobalMasterRow gmr = this.derive();
        gmr.dataSchema = null;
        gmr.globalView = new FastGlobalView();
        gmr.setEnvironmentDataRow(this.environmentDataRow);
        gmr.setParameterDataRow(this.parameterDataRow);
        return gmr;
    }

    @Override
    public MasterDataRow updateDataSchema(DataSchemaDefinition dataSchemaDefinition) {
        if (dataSchemaDefinition == null) {
            throw new NullPointerException();
        }
        DefaultDataAttributeContext dac = new DefaultDataAttributeContext(this.outputProcessorMetaData, this.resourceBundleFactory.getLocale());
        GlobalMasterRow gmr = this.derive();
        gmr.schemaDefinition = dataSchemaDefinition;
        gmr.schemaCompiler = new ProcessingDataSchemaCompiler(dataSchemaDefinition, dac, this.schemaCompiler.getResourceManager(), this.schemaCompiler.getGlobalDefaults());
        gmr.dataSchema = null;
        return gmr;
    }

    @Override
    public DataSchemaDefinition getDataSchemaDefinition() {
        return this.schemaDefinition;
    }

    @Override
    public void refresh() {
        if (this.environmentDataRow != null) {
            DataRowEventHelper.refreshDataRow(this.environmentDataRow, this.globalView);
        }
        if (this.parameterDataRow == null) {
            throw new NullPointerException();
        }
        DataRowEventHelper.refreshDataRow(this.parameterDataRow, this.globalView);
        if (this.expressionDataRow != null) {
            this.expressionDataRow.refresh();
        }
        if (this.importedDataRow != null) {
            DataRowEventHelper.refreshDataRow(this.importedDataRow, this.globalView);
        }
    }

    @Override
    public ImportedVariablesDataRow getImportedDataRow() {
        return this.importedDataRow;
    }

    @Override
    public TableModel getReportData() {
        return this.paddingData.getRawData();
    }

    @Override
    public int getCursor() {
        return this.paddingData.getCursor();
    }

    @Override
    public int getRawDataCursor() {
        return this.paddingData.getRawDataCursor();
    }

    @Override
    public int getRowCount() {
        TableModel rawData = this.paddingData.getRawData();
        if (rawData != null) {
            return rawData.getRowCount();
        }
        return 0;
    }

    @Override
    public CrosstabSpecification getCrosstabSpecification() {
        return this.paddingData.getCrosstabSpecification();
    }

    @Override
    public boolean isCrosstabActive() {
        return this.paddingData.isCrosstabActive();
    }

    @Override
    public MasterDataRow recordCrosstabRowState() {
        GlobalMasterRow copy = this.derive();
        copy.storedPaddingData = this.paddingData.clone();
        copy.storedGlobalView = this.globalView.derive();
        return copy;
    }

    @Override
    public MasterDataRow clearRecordedCrosstabRowState() {
        GlobalMasterRow copy = this.derive();
        copy.storedPaddingData = null;
        copy.storedGlobalView = null;
        return copy;
    }

    @Override
    public MasterDataRow replayStoredCrosstabRowState() {
        GlobalMasterRow copy = this.derive();
        copy.globalView = this.storedGlobalView.derive();
        copy.paddingData = this.storedPaddingData.clone();
        copy.paddingData.refresh(copy.globalView);
        copy.expressionDataRow = this.expressionDataRow.derive(copy.globalView, copy, false);
        copy.refresh();
        return copy;
    }

    @Override
    public void validateReplayFinished() throws ReportProcessingException {
    }
}

