/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.states.LengthLimitingTableModel;
import org.pentaho.reporting.engine.classic.core.states.QueryDataRowWrapper;
import org.pentaho.reporting.engine.classic.core.states.datarow.EmptyTableModel;

public final class ReportDataRow {
    private String[] names;
    private final TableModel reportData;
    private int cursor;

    public ReportDataRow(TableModel reportData) {
        if (reportData == null) {
            throw new NullPointerException();
        }
        this.reportData = reportData;
        this.cursor = 0;
        int columnCount = reportData.getColumnCount();
        this.names = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            this.names[i] = reportData.getColumnName(i);
        }
    }

    private ReportDataRow(TableModel reportData, ReportDataRow reportDataRow) {
        if (reportData == null) {
            throw new NullPointerException();
        }
        if (reportDataRow == null) {
            throw new NullPointerException();
        }
        this.reportData = reportData;
        this.cursor = 0;
        this.cursor = reportDataRow.cursor + 1;
        this.names = reportDataRow.names;
    }

    public static ReportDataRow createDataRow(DataFactory dataFactory, String query, int queryLimit, int queryTimeout, DataRow parameters) throws ReportDataFactoryException {
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        if (query == null) {
            return new ReportDataRow(new EmptyTableModel());
        }
        TableModel reportData = dataFactory.queryData(query, new QueryDataRowWrapper(parameters, queryLimit, queryTimeout));
        if (queryLimit > 0 && reportData.getRowCount() > queryLimit) {
            return new ReportDataRow(new LengthLimitingTableModel(reportData, queryLimit));
        }
        return new ReportDataRow(reportData);
    }

    public Object get(int col) {
        return this.reportData.getValueAt(this.cursor, col);
    }

    public String getColumnName(int col) {
        return this.names[col];
    }

    public int getColumnCount() {
        return this.names.length;
    }

    public ReportDataRow advance() {
        return new ReportDataRow(this.reportData, this);
    }

    public boolean isAdvanceable() {
        return this.cursor < this.reportData.getRowCount() - 1;
    }

    public boolean isReadable() {
        return this.cursor >= 0 && this.cursor < this.reportData.getRowCount();
    }

    public TableModel getReportData() {
        return this.reportData;
    }

    public int getCursor() {
        return this.cursor;
    }
}

