/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.BoxSizing;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.FontSmooth;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextWrap;
import org.pentaho.reporting.engine.classic.core.style.VerticalTextAlign;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;

public class ElementDefaultStyleSheet
extends ElementStyleSheet {
    public static final Color DEFAULT_PAINT = Color.black;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(0.5f);
    private static ElementDefaultStyleSheet defaultStyle;
    private boolean locked;

    protected ElementDefaultStyleSheet() {
        this.setStyleProperty(ElementStyleKeys.BOX_SIZING, BoxSizing.BORDER_BOX);
        this.setStyleProperty(ElementStyleKeys.MIN_WIDTH, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, new Float(0.0f));
        this.setStyleProperty(TextStyleKeys.LINEHEIGHT, new Float(0.0f));
        this.setStyleProperty(TextStyleKeys.RESERVED_LITERAL, "..");
        this.setStyleProperty(TextStyleKeys.BOLD, Boolean.FALSE);
        this.setStyleProperty(TextStyleKeys.ITALIC, Boolean.FALSE);
        this.setStyleProperty(TextStyleKeys.UNDERLINED, Boolean.FALSE);
        this.setStyleProperty(TextStyleKeys.STRIKETHROUGH, Boolean.FALSE);
        this.setStyleProperty(TextStyleKeys.EMBEDDED_FONT, Boolean.FALSE);
        this.setStyleProperty(TextStyleKeys.FONT_SMOOTH, FontSmooth.AUTO);
        this.setStyleProperty(TextStyleKeys.FONT, "Serif");
        this.setStyleProperty(TextStyleKeys.FONTSIZE, new Integer(10));
        this.setStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE, WhitespaceCollapse.PRESERVE);
        this.setStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT, Boolean.FALSE);
        this.setStyleProperty(TextStyleKeys.TEXT_WRAP, TextWrap.WRAP);
        this.setStyleProperty(ElementStyleKeys.PAINT, DEFAULT_PAINT);
        this.setStyleProperty(ElementStyleKeys.STROKE, DEFAULT_STROKE);
        this.setStyleProperty(ElementStyleKeys.VALIGNMENT, ElementAlignment.TOP);
        this.setStyleProperty(ElementStyleKeys.ALIGNMENT, ElementAlignment.LEFT);
        this.setStyleProperty(TextStyleKeys.VERTICAL_TEXT_ALIGNMENT, VerticalTextAlign.BASELINE);
        this.setStyleProperty(ElementStyleKeys.VISIBLE, Boolean.TRUE);
        this.setStyleProperty(ElementStyleKeys.BORDER_TOP_WIDTH, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.BORDER_LEFT_WIDTH, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_WIDTH, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.BORDER_RIGHT_WIDTH, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.BORDER_BREAK_WIDTH, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.BORDER_TOP_COLOR, Color.black);
        this.setStyleProperty(ElementStyleKeys.BORDER_LEFT_COLOR, Color.black);
        this.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_COLOR, Color.black);
        this.setStyleProperty(ElementStyleKeys.BORDER_RIGHT_COLOR, Color.black);
        this.setStyleProperty(ElementStyleKeys.BORDER_BREAK_COLOR, Color.black);
        this.setStyleProperty(ElementStyleKeys.BORDER_TOP_STYLE, BorderStyle.NONE);
        this.setStyleProperty(ElementStyleKeys.BORDER_LEFT_STYLE, BorderStyle.NONE);
        this.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_STYLE, BorderStyle.NONE);
        this.setStyleProperty(ElementStyleKeys.BORDER_RIGHT_STYLE, BorderStyle.NONE);
        this.setStyleProperty(ElementStyleKeys.BORDER_BREAK_STYLE, BorderStyle.NONE);
        this.setStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.PADDING_TOP, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.PADDING_LEFT, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.PADDING_RIGHT, new Float(0.0f));
        this.setStyleProperty(ElementStyleKeys.PADDING_BOTTOM, new Float(0.0f));
        this.setBooleanStyleProperty(ElementStyleKeys.FILL_SHAPE, false);
        this.setBooleanStyleProperty(ElementStyleKeys.DRAW_SHAPE, false);
        this.setBooleanStyleProperty(ElementStyleKeys.WIDOW_ORPHAN_OPT_OUT, true);
        this.setLocked(true);
    }

    protected boolean isLocked() {
        return this.locked;
    }

    protected void setLocked(boolean locked) {
        this.locked = locked;
    }

    public static synchronized ElementDefaultStyleSheet getDefaultStyle() {
        if (defaultStyle == null) {
            defaultStyle = new ElementDefaultStyleSheet();
        }
        return defaultStyle;
    }

    @Override
    public void setStyleProperty(StyleKey key, Object value) {
        if (this.isLocked()) {
            throw new UnsupportedOperationException("This stylesheet is readonly");
        }
        super.setStyleProperty(key, value);
    }

    public ElementStyleSheet getCopy() {
        return this;
    }
}

