/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.AbstractStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleChangeListener;
import org.pentaho.reporting.engine.classic.core.style.StyleChangeSupport;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.serializer.SerializerHelper;

public class ElementStyleSheet
extends AbstractStyleSheet
implements Serializable,
Cloneable {
    private StyleKey[] propertyKeys;
    private transient Object[] properties;
    private byte[] source;
    private static final byte SOURCE_UNDEFINED = 0;
    private static final byte SOURCE_FROM_PARENT = 1;
    private static final byte SOURCE_DIRECT = 2;
    private transient StyleChangeSupport styleChangeSupport = new StyleChangeSupport(this);
    private long modificationCount;
    private long changeTrackerHash;
    private static final StyleKey[] EMPTY_KEYS = new StyleKey[0];

    public ElementStyleSheet() {
        this.propertyKeys = StyleKey.getDefinedStyleKeys();
        if (this.propertyKeys[0] == null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public long getChangeTracker() {
        return this.changeTrackerHash << 16 | this.modificationCount;
    }

    @Override
    public boolean isLocalKey(StyleKey key) {
        if (this.source == null) {
            return false;
        }
        int identifier = key.identifier;
        if (this.source.length <= identifier) {
            return false;
        }
        return this.source[identifier] == 2;
    }

    private void pruneCachedEntries() {
        if (this.source != null && this.properties != null) {
            for (int i = 0; i < this.source.length; ++i) {
                if (this.source[i] != 1) continue;
                this.source[i] = 0;
                this.properties[i] = null;
            }
        }
    }

    @Override
    public final Object[] toArray() {
        StyleKey[] keys = this.propertyKeys;
        Object[] data = new Object[keys.length];
        if (this.source == null) {
            this.source = new byte[keys.length];
            this.properties = new Object[keys.length];
        }
        for (int i = 0; i < keys.length; ++i) {
            StyleKey key = keys[i];
            if (key == null) {
                throw new NullPointerException();
            }
            int identifier = key.identifier;
            byte sourceHint = this.source[identifier];
            data[identifier] = sourceHint == 0 ? this.getStyleProperty(key) : this.properties[identifier];
        }
        return data;
    }

    @Override
    public Object getStyleProperty(StyleKey key, Object defaultValue) {
        int identifier = key.identifier;
        if (this.properties != null) {
            if (this.properties.length <= identifier) {
                throw new IllegalStateException();
            }
            byte source = this.source[identifier];
            if (source != 0) {
                Object value = this.properties[identifier];
                if (value == null) {
                    return defaultValue;
                }
                return value;
            }
        }
        this.putInCache(key, null, (byte)1);
        return defaultValue;
    }

    private void putInCache(StyleKey key, Object value, byte sourceHint) {
        this.ensurePropertiesReady();
        int identifier = key.identifier;
        this.properties[identifier] = value;
        this.source[identifier] = sourceHint;
    }

    public void setBooleanStyleProperty(StyleKey key, boolean value) {
        if (value) {
            this.setStyleProperty(key, Boolean.TRUE);
        } else {
            this.setStyleProperty(key, Boolean.FALSE);
        }
    }

    public void setStyleProperty(StyleKey key, Object value) {
        if (key == null) {
            throw new NullPointerException("ElementStyleSheet.setStyleProperty: key is null.");
        }
        int identifier = key.identifier;
        if (value == null) {
            if (this.properties != null) {
                if (this.properties[identifier] == null) {
                    return;
                }
                this.putInCache(key, null, (byte)0);
                this.updateChangeTracker(key, null);
                this.properties[identifier] = null;
                this.styleChangeSupport.fireStyleRemoved(key);
            }
            return;
        }
        if (!key.getValueType().isAssignableFrom(value.getClass())) {
            throw new ClassCastException("Value for key " + key.getName() + " is not assignable: " + value.getClass() + " is not assignable from " + key.getValueType());
        }
        this.ensurePropertiesReady();
        if (ObjectUtilities.equal((Object)this.properties[identifier], (Object)value)) {
            return;
        }
        this.putInCache(key, value, (byte)2);
        this.updateChangeTracker(key, value);
        this.styleChangeSupport.fireStyleChanged(key, value);
    }

    private void ensurePropertiesReady() {
        if (this.properties == null) {
            int definedStyleKeyCount = this.propertyKeys.length;
            this.properties = new Object[definedStyleKeyCount];
            this.source = new byte[definedStyleKeyCount];
        }
    }

    @Override
    public ElementStyleSheet clone() {
        ElementStyleSheet sc = (ElementStyleSheet)super.clone();
        if (this.properties != null) {
            sc.properties = (Object[])this.properties.clone();
        }
        if (this.source != null) {
            sc.source = (byte[])this.source.clone();
        }
        sc.styleChangeSupport = new StyleChangeSupport(sc);
        sc.pruneCachedEntries();
        return sc;
    }

    @Override
    public ElementStyleSheet derive(boolean preserveId) {
        ElementStyleSheet sc = (ElementStyleSheet)super.derive(preserveId);
        if (this.properties != null) {
            sc.properties = (Object[])this.properties.clone();
        }
        if (this.source != null) {
            sc.source = (byte[])this.source.clone();
        }
        sc.styleChangeSupport = new StyleChangeSupport(sc);
        sc.pruneCachedEntries();
        return sc;
    }

    public StyleKey[] getDefinedPropertyNamesArray() {
        if (this.source == null) {
            return EMPTY_KEYS;
        }
        StyleKey[] retval = (StyleKey[])this.propertyKeys.clone();
        for (int i = 0; i < this.source.length; ++i) {
            if (this.source[i] == 2) continue;
            retval[i] = null;
        }
        return retval;
    }

    public void addListener(StyleChangeListener l) {
        this.styleChangeSupport.addListener(l);
    }

    public void removeListener(StyleChangeListener l) {
        this.styleChangeSupport.removeListener(l);
    }

    private void updateChangeTracker(StyleKey key, Object value) {
        ++this.modificationCount;
        this.changeTrackerHash = this.changeTrackerHash * 31L + (long)key.getIdentifier();
        this.changeTrackerHash = value == null ? (this.changeTrackerHash *= 31L) : this.changeTrackerHash * 31L + (long)value.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.properties == null) {
            out.writeInt(0);
        } else {
            int size = this.properties.length;
            out.writeInt(size);
            for (int i = 0; i < size; ++i) {
                Object value = this.properties[i];
                SerializerHelper.getInstance().writeObject(value, out);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int i;
        in.defaultReadObject();
        int size = in.readInt();
        this.propertyKeys = StyleKey.getDefinedStyleKeys();
        this.styleChangeSupport = new StyleChangeSupport(this);
        if (size == 0) {
            this.properties = null;
            return;
        }
        if (size != this.propertyKeys.length) {
            throw new IOException("Encountered a different style-system configuration. This report cannot be deserialized.");
        }
        if (this.propertyKeys[0] == null) {
            throw new IllegalStateException();
        }
        this.properties = new Object[size];
        Object[] values = new Object[size];
        SerializerHelper serHelper = SerializerHelper.getInstance();
        for (i = 0; i < size; ++i) {
            values[i] = serHelper.readObject(in);
        }
        for (i = 0; i < size; ++i) {
            StyleKey key = this.propertyKeys[i];
            if (key == null) continue;
            int identifier = key.identifier;
            this.properties[identifier] = values[i];
        }
    }

    public StyleKey[] getPropertyKeys() {
        return (StyleKey[])this.propertyKeys.clone();
    }

    public void addAll(ElementStyleSheet sourceStyleSheet) {
        if (sourceStyleSheet.source == null || sourceStyleSheet.properties == null) {
            return;
        }
        this.ensurePropertiesReady();
        for (int i = 0; i < sourceStyleSheet.source.length; ++i) {
            byte sourceFlag = sourceStyleSheet.source[i];
            if (sourceFlag != 2) continue;
            this.properties[i] = sourceStyleSheet.properties[i];
            this.source[i] = sourceFlag;
        }
    }

    public void addInherited(ElementStyleSheet sourceStyleSheet) {
        if (sourceStyleSheet.source == null || sourceStyleSheet.properties == null) {
            return;
        }
        this.ensurePropertiesReady();
        for (int i = 0; i < this.source.length; ++i) {
            byte sourceFlag;
            if (!this.propertyKeys[i].isInheritable() || (sourceFlag = sourceStyleSheet.source[i]) != 2) continue;
            this.properties[i] = sourceStyleSheet.properties[i];
            this.source[i] = 1;
        }
    }

    public void addInherited(SimpleStyleSheet sourceStyleSheet) {
        this.ensurePropertiesReady();
        for (int i = 0; i < this.source.length; ++i) {
            if (!this.propertyKeys[i].isInheritable()) continue;
            this.properties[i] = sourceStyleSheet.getStyleProperty(this.propertyKeys[i], null);
            this.source[i] = 1;
        }
    }

    public void addDefault(ElementStyleSheet sourceStyleSheet) {
        if (sourceStyleSheet.source == null || sourceStyleSheet.properties == null) {
            return;
        }
        this.ensurePropertiesReady();
        for (int i = 0; i < this.source.length; ++i) {
            byte sourceFlag = sourceStyleSheet.source[i];
            if (sourceFlag != 2 || this.source[i] != 0) continue;
            this.properties[i] = sourceStyleSheet.properties[i];
            this.source[i] = sourceFlag;
        }
    }

    public void clear() {
        if (this.source == null || this.properties == null) {
            return;
        }
        this.changeTrackerHash = 0L;
        this.modificationCount = 0L;
        Arrays.fill(this.properties, null);
        Arrays.fill(this.source, (byte)0);
    }

    @Override
    public long getModificationCount() {
        return this.modificationCount;
    }

    protected void setModificationCount(long modificationCount) {
        this.modificationCount = modificationCount;
    }

    @Override
    public long getChangeTrackerHash() {
        return this.changeTrackerHash;
    }

    protected void setChangeTrackerHash(long changeTracker) {
        this.changeTrackerHash = changeTracker;
    }

    public void copyFrom(ElementStyleSheet style) {
        this.changeTrackerHash = style.changeTrackerHash;
        this.modificationCount = style.modificationCount;
        this.propertyKeys = (StyleKey[])style.propertyKeys.clone();
        if (style.source != null) {
            this.source = (byte[])style.source.clone();
        } else if (this.source != null) {
            Arrays.fill(this.source, (byte)0);
        }
        if (style.properties != null) {
            this.properties = (Object[])style.properties.clone();
        } else if (this.properties != null) {
            Arrays.fill(this.properties, null);
        }
    }
}

